/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.serialize.hosted;

import com.oracle.svm.core.jdk.Package_jdk_internal_reflect;
import com.oracle.svm.core.jdk.serialize.SerializationRegistry;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.reflect.serialize.SerializationSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.io.Externalizable;
import java.io.ObjectStreamClass;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.graalvm.nativeimage.ImageSingletons;

final class SerializationBuilder {
    private final Object reflectionFactory;
    private final Method newConstructorForSerializationMethod1;
    private final Method newConstructorForSerializationMethod2;
    private final Method getConstructorAccessorMethod;
    private final Method getExternalizableConstructorMethod;
    private final Constructor<?> stubConstructor;
    private final SerializationSupport serializationSupport;

    SerializationBuilder(FeatureImpl.DuringSetupAccessImpl access) {
        try {
            Class<?> reflectionFactoryClass = access.findClassByName(Package_jdk_internal_reflect.getQualifiedName() + ".ReflectionFactory");
            Method getReflectionFactoryMethod = ReflectionUtil.lookupMethod(reflectionFactoryClass, (String)"getReflectionFactory", (Class[])new Class[0]);
            this.reflectionFactory = getReflectionFactoryMethod.invoke(null, new Object[0]);
            this.newConstructorForSerializationMethod1 = ReflectionUtil.lookupMethod(reflectionFactoryClass, (String)"newConstructorForSerialization", (Class[])new Class[]{Class.class});
            this.newConstructorForSerializationMethod2 = ReflectionUtil.lookupMethod(reflectionFactoryClass, (String)"newConstructorForSerialization", (Class[])new Class[]{Class.class, Constructor.class});
            this.getConstructorAccessorMethod = ReflectionUtil.lookupMethod(Constructor.class, (String)"getConstructorAccessor", (Class[])new Class[0]);
            this.getExternalizableConstructorMethod = ReflectionUtil.lookupMethod(ObjectStreamClass.class, (String)"getExternalizableConstructor", (Class[])new Class[]{Class.class});
        }
        catch (ReflectiveOperationException e) {
            throw VMError.shouldNotReachHere(e);
        }
        this.stubConstructor = this.newConstructorForSerialization(SerializationSupport.StubForAbstractClass.class, null);
        this.serializationSupport = new SerializationSupport();
        ImageSingletons.add(SerializationRegistry.class, (Object)this.serializationSupport);
    }

    private Constructor<?> newConstructorForSerialization(Class<?> serializationTargetClass, Constructor<?> customConstructorToCall) {
        try {
            if (customConstructorToCall == null) {
                return (Constructor)this.newConstructorForSerializationMethod1.invoke(this.reflectionFactory, serializationTargetClass);
            }
            return (Constructor)this.newConstructorForSerializationMethod2.invoke(this.reflectionFactory, serializationTargetClass, customConstructorToCall);
        }
        catch (ReflectiveOperationException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    private Object getConstructorAccessor(Constructor<?> constructor) {
        try {
            return this.getConstructorAccessorMethod.invoke(constructor, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    private Constructor<?> getExternalizableConstructor(Class<?> serializationTargetClass) {
        try {
            return (Constructor)this.getExternalizableConstructorMethod.invoke(null, serializationTargetClass);
        }
        catch (ReflectiveOperationException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    Class<?> addConstructorAccessor(Class<?> serializationTargetClass, Class<?> customTargetConstructorClass) {
        Class<?> targetConstructorClass;
        Constructor<?> targetConstructor;
        if (serializationTargetClass.isArray() || Enum.class.isAssignableFrom(serializationTargetClass)) {
            return null;
        }
        if (Externalizable.class.isAssignableFrom(serializationTargetClass)) {
            try {
                Constructor<?> externalizableConstructor = this.getExternalizableConstructor(serializationTargetClass);
                return externalizableConstructor.getDeclaringClass();
            }
            catch (Exception e) {
                throw VMError.shouldNotReachHere(e);
            }
        }
        if (Modifier.isAbstract(serializationTargetClass.getModifiers())) {
            targetConstructor = this.stubConstructor;
            targetConstructorClass = targetConstructor.getDeclaringClass();
        } else {
            Constructor<?> customConstructorToCall = null;
            if (customTargetConstructorClass != null) {
                try {
                    customConstructorToCall = customTargetConstructorClass.getDeclaredConstructor(new Class[0]);
                }
                catch (NoSuchMethodException ex) {
                    UserError.abort("The given targetConstructorClass %s does not declare a parameterless constructor.", customTargetConstructorClass.getTypeName());
                }
            }
            targetConstructor = this.newConstructorForSerialization(serializationTargetClass, customConstructorToCall);
            targetConstructorClass = targetConstructor.getDeclaringClass();
        }
        this.serializationSupport.addConstructorAccessor(serializationTargetClass, targetConstructorClass, this.getConstructorAccessor(targetConstructor));
        return targetConstructorClass;
    }
}

