/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.target;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.reflect.hosted.ExecutableAccessorComputer;
import com.oracle.svm.reflect.target.ReflectionHelper;
import com.oracle.svm.reflect.target.Target_jdk_internal_reflect_MethodAccessor;
import java.lang.reflect.Method;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import sun.reflect.generics.repository.MethodRepository;

@TargetClass(value=Method.class)
public final class Target_java_lang_reflect_Method {
    @Alias
    MethodRepository genericInfo;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ExecutableAccessorComputer.class)
    Target_jdk_internal_reflect_MethodAccessor methodAccessor;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=DefaultValueComputer.class)
    Object defaultValue;

    @Alias
    native Target_java_lang_reflect_Method copy();

    @Substitute
    public Target_jdk_internal_reflect_MethodAccessor acquireMethodAccessor() {
        if (this.methodAccessor == null) {
            throw VMError.unsupportedFeature("Runtime reflection is not supported.");
        }
        return this.methodAccessor;
    }

    @Substitute
    public Object getDefaultValue() {
        Target_java_lang_reflect_Method holder = ReflectionHelper.getHolder(this);
        return holder.defaultValue;
    }

    public static final class DefaultValueComputer
    implements RecomputeFieldValue.CustomFieldValueComputer {
        @Override
        public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
            Method method = (Method)receiver;
            return method.getDefaultValue();
        }
    }
}

