/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.RegisterDumper;
import com.oracle.svm.core.SubstrateDiagnostics;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.StubCallingConvention;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Method;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.LogHandler;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordFactory;

public final class InvalidVTableEntryHandler {
    public static final Method HANDLER_METHOD = ReflectionUtil.lookupMethod(InvalidVTableEntryHandler.class, (String)"invalidVTableEntryHandler", (Class[])new Class[0]);
    public static final String MSG = "Fatal error: Virtual method call used an illegal vtable entry that was seen as unused by the static analysis";

    @StubCallingConvention
    @NeverInline(value="We need a separate frame that stores all registers")
    private static void invalidVTableEntryHandler() {
        VMThreads.StatusSupport.setStatusIgnoreSafepoints();
        StackOverflowCheck.singleton().disableStackOverflowChecksForFatalError();
        Pointer callerSP = KnownIntrinsics.readCallerStackPointer();
        CodePointer callerIP = KnownIntrinsics.readReturnAddress();
        LogHandler logHandler = (LogHandler)ImageSingletons.lookup(LogHandler.class);
        Log log = Log.enterFatalContext(logHandler, callerIP, MSG, null);
        if (log != null) {
            SubstrateDiagnostics.printFatalError(log, callerSP, callerIP, (RegisterDumper.Context)WordFactory.nullPointer(), true);
            log.string(MSG).newline();
        }
        logHandler.fatalError();
    }
}

