/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.graal;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.genscavenge.AbstractImageHeapLayouter;
import com.oracle.svm.core.genscavenge.ChunkedImageHeapLayouter;
import com.oracle.svm.core.genscavenge.CompleteGarbageCollectorMXBean;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapImplMemoryMXBean;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.IncrementalGarbageCollectorMXBean;
import com.oracle.svm.core.genscavenge.LinearImageHeapLayouter;
import com.oracle.svm.core.genscavenge.graal.BarrierSnippets;
import com.oracle.svm.core.genscavenge.graal.GenScavengeAllocationSnippets;
import com.oracle.svm.core.genscavenge.remset.CardTableBasedRememberedSet;
import com.oracle.svm.core.genscavenge.remset.NoRememberedSet;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateAllocationSnippets;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.image.ImageHeapLayouter;
import com.oracle.svm.core.jdk.RuntimeFeature;
import com.oracle.svm.core.jdk.management.ManagementFeature;
import com.oracle.svm.core.jdk.management.ManagementSupport;
import com.sun.management.GarbageCollectorMXBean;
import java.lang.management.MemoryMXBean;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
class HeapFeature
implements GraalFeature {
    HeapFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return SubstrateOptions.UseSerialGC.getValue();
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Arrays.asList(RuntimeFeature.class, ManagementFeature.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        HeapImpl heap = new HeapImpl(SubstrateOptions.getPageSize());
        ImageSingletons.add(Heap.class, (Object)heap);
        ImageSingletons.add(SubstrateAllocationSnippets.class, (Object)((Object)new GenScavengeAllocationSnippets()));
        ImageSingletons.add(RememberedSet.class, (Object)HeapFeature.createRememberedSet());
        ManagementSupport managementSupport = ManagementSupport.getSingleton();
        managementSupport.addPlatformManagedObjectSingleton(MemoryMXBean.class, new HeapImplMemoryMXBean());
        managementSupport.addPlatformManagedObjectList(GarbageCollectorMXBean.class, Arrays.asList(new IncrementalGarbageCollectorMXBean(), new CompleteGarbageCollectorMXBean()));
    }

    @Override
    public void registerLowerings(RuntimeConfiguration runtimeConfig, OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, boolean hosted) {
        if (SubstrateOptions.useRememberedSet()) {
            BarrierSnippets barrierSnippets = new BarrierSnippets(options, factories, providers, snippetReflection);
            barrierSnippets.registerLowerings(lowerings);
        }
        GenScavengeAllocationSnippets.registerLowering(options, factories, providers, snippetReflection, lowerings);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        access.registerAsUsed(Object[].class);
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        int imageHeapNullRegionSize = Heap.getHeap().getImageHeapNullRegionSize();
        AbstractImageHeapLayouter heapLayouter = HeapImpl.usesImageHeapChunks() ? new ChunkedImageHeapLayouter(HeapImpl.getImageHeapInfo(), 0L, imageHeapNullRegionSize) : new LinearImageHeapLayouter(HeapImpl.getImageHeapInfo(), 0L, imageHeapNullRegionSize);
        ImageSingletons.add(ImageHeapLayouter.class, (Object)heapLayouter);
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        ImageHeapInfo imageHeapInfo = HeapImpl.getImageHeapInfo();
        access.registerAsImmutable((Object)imageHeapInfo);
    }

    @Override
    public void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        GenScavengeAllocationSnippets.registerForeignCalls(foreignCalls);
    }

    private static RememberedSet createRememberedSet() {
        if (SubstrateOptions.useRememberedSet()) {
            return new CardTableBasedRememberedSet();
        }
        return new NoRememberedSet();
    }
}

