/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.RuntimeCodeCache;
import com.oracle.svm.core.code.RuntimeCodeInfoAccess;
import com.oracle.svm.core.code.RuntimeCodeInfoHistory;
import com.oracle.svm.core.code.RuntimeCodeInfoMemory;
import com.oracle.svm.core.graal.meta.SharedRuntimeMethod;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class RuntimeCodeCacheCleaner
implements RuntimeCodeCache.CodeInfoVisitor {
    public static final Class<?>[] CLASSES_ASSUMED_REACHABLE = new Class[]{SpeculationLog.SpeculationReason.class, SharedRuntimeMethod.class};

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public RuntimeCodeCacheCleaner() {
    }

    @Override
    public <T extends CodeInfo> boolean visitCode(T codeInfo) {
        if (RuntimeCodeInfoAccess.areAllObjectsOnImageHeap(codeInfo)) {
            return true;
        }
        int state = CodeInfoAccess.getState(codeInfo);
        if (state == 5) {
            RuntimeCodeCacheCleaner.freeMemory(codeInfo);
        } else if (state == 3) {
            CodeInfoTable.invalidateNonStackCodeAtSafepoint(codeInfo);
            assert (CodeInfoAccess.getState(codeInfo) == 4);
            RuntimeCodeCacheCleaner.freeMemory(codeInfo);
        }
        return true;
    }

    private static void freeMemory(CodeInfo codeInfo) {
        boolean removed = RuntimeCodeInfoMemory.singleton().removeDuringGC(codeInfo);
        assert (removed) : "must have been present";
        RuntimeCodeInfoHistory.singleton().logFree(codeInfo);
        RuntimeCodeInfoAccess.releaseMethodInfoMemory(codeInfo, false);
    }
}

