/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.ClassLoaderSupport;
import com.oracle.svm.hosted.NativeImageClassLoaderSupport;
import com.oracle.svm.hosted.NativeImageSystemClassLoader;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public final class ClassLoaderSupportImpl
extends ClassLoaderSupport {
    private final ClassLoader imageClassLoader;

    ClassLoaderSupportImpl(NativeImageClassLoaderSupport classLoaderSupport) {
        this.imageClassLoader = classLoaderSupport.getClassLoader();
    }

    @Override
    protected boolean isNativeImageClassLoaderImpl(ClassLoader loader) {
        return loader == this.imageClassLoader || loader instanceof NativeImageSystemClassLoader;
    }

    @Override
    public List<ResourceBundle> getResourceBundle(String bundleName, Locale locale) {
        return Collections.singletonList(ResourceBundle.getBundle(bundleName, locale, this.imageClassLoader));
    }
}

