/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.target;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.reflect.hosted.ExecutableAccessorComputer;
import com.oracle.svm.reflect.target.ReflectionHelper;
import com.oracle.svm.reflect.target.Target_java_lang_reflect_Executable;
import com.oracle.svm.reflect.target.Target_jdk_internal_reflect_MethodAccessor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import sun.reflect.generics.repository.MethodRepository;

@TargetClass(value=Method.class)
public final class Target_java_lang_reflect_Method {
    @Alias
    MethodRepository genericInfo;
    @Alias
    private Class<?>[] parameterTypes;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private byte[] annotations;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private byte[] parameterAnnotations;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ExecutableAccessorComputer.class)
    Target_jdk_internal_reflect_MethodAccessor methodAccessor;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=DefaultValueComputer.class)
    Object defaultValue;

    @Alias
    @TargetElement(name="<init>")
    public native void constructor(Class<?> var1, String var2, Class<?>[] var3, Class<?> var4, Class<?>[] var5, int var6, int var7, String var8, byte[] var9, byte[] var10, byte[] var11);

    @Alias
    native Target_java_lang_reflect_Method copy();

    @Substitute
    public Target_jdk_internal_reflect_MethodAccessor acquireMethodAccessor() {
        if (this.methodAccessor == null) {
            throw VMError.unsupportedFeature("Runtime reflection is not supported for " + this);
        }
        return this.methodAccessor;
    }

    @Substitute
    public Annotation[][] getParameterAnnotations() {
        Target_java_lang_reflect_Executable self = SubstrateUtil.cast(this, Target_java_lang_reflect_Executable.class);
        Target_java_lang_reflect_Executable holder = ReflectionHelper.getHolder(self);
        if (holder.parameterAnnotations != null) {
            return holder.parameterAnnotations;
        }
        return self.sharedGetParameterAnnotations(this.parameterTypes, this.parameterAnnotations);
    }

    @Substitute
    public Object getDefaultValue() {
        Target_java_lang_reflect_Method holder = ReflectionHelper.getHolder(this);
        return holder.defaultValue;
    }

    public static final class DefaultValueComputer
    implements RecomputeFieldValue.CustomFieldValueComputer {
        @Override
        public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
            Method method = (Method)receiver;
            return method.getDefaultValue();
        }
    }
}

