/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.isolated;

import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.ClientIsolateThread;
import com.oracle.svm.graal.isolated.CompilerHandle;
import com.oracle.svm.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.graal.isolated.IsolatedCompileContext;
import com.oracle.svm.truffle.isolated.IsolatedCompilationResultData;
import com.oracle.svm.truffle.isolated.IsolatedCompilationResultInfo;
import com.oracle.svm.truffle.isolated.IsolatedEventContext;
import com.oracle.svm.truffle.isolated.IsolatedGraphInfo;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCompilerListener;
import org.graalvm.compiler.truffle.common.TruffleInliningData;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;

final class IsolatedTruffleCompilerEventForwarder
implements TruffleCompilerListener {
    private final ClientHandle<IsolatedEventContext> contextHandle;

    IsolatedTruffleCompilerEventForwarder(ClientHandle<IsolatedEventContext> contextHandle) {
        this.contextHandle = contextHandle;
    }

    public void onGraalTierFinished(CompilableTruffleAST compilable, TruffleCompilerListener.GraphInfo graph) {
        IsolatedTruffleCompilerEventForwarder.onGraalTierFinished0(IsolatedCompileContext.get().getClient(), this.contextHandle, IsolatedCompileContext.get().hand(graph), graph.getNodeCount());
    }

    public void onTruffleTierFinished(CompilableTruffleAST compilable, TruffleInliningData inliningPlan, TruffleCompilerListener.GraphInfo graph) {
        IsolatedTruffleCompilerEventForwarder.onTruffleTierFinished0(IsolatedCompileContext.get().getClient(), this.contextHandle, IsolatedCompileContext.get().hand(graph), graph.getNodeCount());
    }

    public void onSuccess(CompilableTruffleAST compilable, TruffleInliningData inliningPlan, TruffleCompilerListener.GraphInfo graph, TruffleCompilerListener.CompilationResultInfo info, int tier) {
        IsolatedCompilationResultData data = (IsolatedCompilationResultData)StackValue.get(IsolatedCompilationResultData.class);
        data.setOriginalObjectHandle(IsolatedCompileContext.get().hand(info));
        data.setTargetCodeSize(info.getTargetCodeSize());
        data.setTotalFrameSize(info.getTotalFrameSize());
        data.setExceptionHandlersCount(info.getExceptionHandlersCount());
        data.setInfopointsCount(info.getInfopointsCount());
        data.setMarksCount(info.getMarksCount());
        data.setDataPatchesCount(info.getDataPatchesCount());
        IsolatedTruffleCompilerEventForwarder.onSuccess0(IsolatedCompileContext.get().getClient(), this.contextHandle, IsolatedCompileContext.get().hand(graph), graph.getNodeCount(), data, tier);
    }

    public void onFailure(CompilableTruffleAST compilable, String reason, boolean bailout, boolean permanentBailout, int tier) {
        try (CTypeConversion.CCharPointerHolder reasonCstr = CTypeConversion.toCString((CharSequence)reason);){
            IsolatedTruffleCompilerEventForwarder.onFailure0(IsolatedCompileContext.get().getClient(), this.contextHandle, reasonCstr.get(), bailout, permanentBailout, tier);
        }
    }

    public void onCompilationRetry(CompilableTruffleAST compilable, int tier) {
        IsolatedTruffleCompilerEventForwarder.onCompilationRetry0(IsolatedCompileContext.get().getClient(), this.contextHandle, tier);
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static void onGraalTierFinished0(ClientIsolateThread client, ClientHandle<IsolatedEventContext> contextHandle, CompilerHandle<TruffleCompilerListener.GraphInfo> graphInfo, int nodeCount) {
        IsolatedEventContext context = IsolatedCompileClient.get().unhand(contextHandle);
        context.listener.onGraalTierFinished(context.compilable, (TruffleCompilerListener.GraphInfo)new IsolatedGraphInfo(graphInfo, nodeCount));
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static void onTruffleTierFinished0(ClientIsolateThread client, ClientHandle<IsolatedEventContext> contextHandle, CompilerHandle<TruffleCompilerListener.GraphInfo> graphInfo, int nodeCount) {
        IsolatedEventContext context = IsolatedCompileClient.get().unhand(contextHandle);
        context.listener.onTruffleTierFinished(context.compilable, context.task.inliningData(), (TruffleCompilerListener.GraphInfo)new IsolatedGraphInfo(graphInfo, nodeCount));
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static void onSuccess0(ClientIsolateThread client, ClientHandle<IsolatedEventContext> contextHandle, CompilerHandle<TruffleCompilerListener.GraphInfo> graphInfo, int nodeCount, IsolatedCompilationResultData resultData, int tier) {
        IsolatedEventContext context = IsolatedCompileClient.get().unhand(contextHandle);
        context.listener.onSuccess(context.compilable, context.task.inliningData(), (TruffleCompilerListener.GraphInfo)new IsolatedGraphInfo(graphInfo, nodeCount), (TruffleCompilerListener.CompilationResultInfo)new IsolatedCompilationResultInfo(resultData), tier);
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static void onFailure0(ClientIsolateThread client, ClientHandle<IsolatedEventContext> contextHandle, CCharPointer reason, boolean bailout, boolean permanentBailout, int tier) {
        IsolatedEventContext context = IsolatedCompileClient.get().unhand(contextHandle);
        context.listener.onFailure(context.compilable, CTypeConversion.toJavaString((CCharPointer)reason), bailout, permanentBailout, tier);
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static void onCompilationRetry0(ClientIsolateThread client, ClientHandle<IsolatedEventContext> contextHandle, int tier) {
        IsolatedEventContext context = IsolatedCompileClient.get().unhand(contextHandle);
        context.listener.onCompilationRetry(context.compilable, tier);
    }
}

