/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.reflect.MethodMetadataDecoder;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.graalvm.collections.Pair;
import org.graalvm.nativeimage.ImageSingletons;

public final class DynamicHubCompanion {
    private final DynamicHub hub;
    private String packageName;
    private Object classLoader = DynamicHub.NO_CLASS_LOADER;
    private ProtectionDomain protectionDomain;
    private DynamicHub.ReflectionData completeReflectionData;

    public DynamicHubCompanion(DynamicHub hub) {
        this.hub = hub;
    }

    public String getPackageName() {
        if (this.packageName == null) {
            this.packageName = this.hub.computePackageName();
        }
        return this.packageName;
    }

    boolean hasClassLoader() {
        return this.classLoader != DynamicHub.NO_CLASS_LOADER;
    }

    public ClassLoader getClassLoader() {
        Object loader = this.classLoader;
        VMError.guarantee(loader != DynamicHub.NO_CLASS_LOADER);
        return (ClassLoader)loader;
    }

    public void setClassLoader(ClassLoader loader) {
        VMError.guarantee(this.classLoader == DynamicHub.NO_CLASS_LOADER && loader != DynamicHub.NO_CLASS_LOADER);
        this.classLoader = loader;
    }

    public ProtectionDomain getProtectionDomain() {
        if (this.protectionDomain == null) {
            this.protectionDomain = DynamicHub.allPermDomainReference.get();
        }
        return this.protectionDomain;
    }

    public void setProtectionDomain(ProtectionDomain domain) {
        VMError.guarantee(this.protectionDomain == null && domain != null);
        this.protectionDomain = domain;
    }

    public DynamicHub.ReflectionData getCompleteReflectionData() {
        if (this.completeReflectionData == null) {
            ArrayList<Method> newDeclaredMethods = new ArrayList<Method>(Arrays.asList(this.hub.rd.declaredMethods));
            ArrayList<Method> newPublicMethods = new ArrayList<Method>(Arrays.asList(this.hub.rd.publicMethods));
            ArrayList newDeclaredConstructors = new ArrayList(Arrays.asList(this.hub.rd.declaredConstructors));
            ArrayList newPublicConstructors = new ArrayList(Arrays.asList(this.hub.rd.publicConstructors));
            ArrayList<Method> newDeclaredPublicMethods = new ArrayList<Method>(Arrays.asList(this.hub.rd.declaredPublicMethods));
            Pair<Executable[], MethodMetadataDecoder.MethodDescriptor[]> queriedAndHidingMethods = ((MethodMetadataDecoder)ImageSingletons.lookup(MethodMetadataDecoder.class)).getQueriedAndHidingMethods(this.hub);
            Executable[] queriedMethods = (Executable[])queriedAndHidingMethods.getLeft();
            MethodMetadataDecoder.MethodDescriptor[] hidingMethods = (MethodMetadataDecoder.MethodDescriptor[])queriedAndHidingMethods.getRight();
            block0: for (Executable method : queriedMethods) {
                if (method instanceof Constructor) {
                    Constructor c = (Constructor)method;
                    for (Executable executable : this.hub.rd.declaredConstructors) {
                        if (Arrays.equals(c.getParameterTypes(), ((Constructor)executable).getParameterTypes())) continue block0;
                    }
                    newDeclaredConstructors.add(c);
                    if (!Modifier.isPublic(c.getModifiers())) continue;
                    newPublicConstructors.add(c);
                    continue;
                }
                Method m = (Method)method;
                for (Executable executable : this.hub.rd.declaredMethods) {
                    if (m.getName().equals(((Method)executable).getName()) && Arrays.equals(m.getParameterTypes(), ((Method)executable).getParameterTypes())) continue block0;
                }
                newDeclaredMethods.add(m);
                if (!Modifier.isPublic(m.getModifiers())) continue;
                newPublicMethods.add(m);
                newDeclaredPublicMethods.add(m);
            }
            DynamicHub superHub = this.hub.getSuperHub();
            if (superHub != null) {
                DynamicHubCompanion.addInheritedPublicMethods(newPublicMethods, superHub.privateGetPublicMethods(), hidingMethods, true);
            }
            for (DynamicHub interfaceHub : this.hub.getInterfaces()) {
                DynamicHubCompanion.addInheritedPublicMethods(newPublicMethods, interfaceHub.privateGetPublicMethods(), hidingMethods, this.hub.isInterface());
            }
            this.completeReflectionData = new DynamicHub.ReflectionData(this.hub.rd.declaredFields, this.hub.rd.publicFields, this.hub.rd.publicUnhiddenFields, newDeclaredMethods.toArray(new Method[0]), newPublicMethods.toArray(new Method[0]), newDeclaredConstructors.toArray(new Constructor[0]), newPublicConstructors.toArray(new Constructor[0]), this.hub.rd.nullaryConstructor, this.hub.rd.declaredPublicFields, newDeclaredPublicMethods.toArray(new Method[0]), this.hub.rd.declaredClasses, this.hub.rd.publicClasses, this.hub.rd.enclosingMethodOrConstructor, this.hub.rd.recordComponents);
        }
        return this.completeReflectionData;
    }

    private static void addInheritedPublicMethods(List<Method> newPublicMethods, Method[] parentMethods, MethodMetadataDecoder.MethodDescriptor[] hidingMethods, boolean includeStaticMethods) {
        block0: for (Method m : parentMethods) {
            if (!includeStaticMethods && Modifier.isStatic(m.getModifiers())) continue;
            for (Method m2 : newPublicMethods) {
                if (!m.getName().equals(m2.getName()) || !Arrays.equals(m.getParameterTypes(), m2.getParameterTypes())) continue;
                if (m.getDeclaringClass() == m2.getDeclaringClass() || !m2.getDeclaringClass().isAssignableFrom(m.getDeclaringClass())) continue block0;
                newPublicMethods.remove(m2);
                newPublicMethods.add(m);
                continue block0;
            }
            for (MethodMetadataDecoder.MethodDescriptor hidingMethod : hidingMethods) {
                if (m.getName().equals(hidingMethod.getName()) && Arrays.equals(m.getParameterTypes(), hidingMethod.getParameterTypes())) continue block0;
            }
            newPublicMethods.add(m);
        }
    }
}

