/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni.hosted;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.graal.nodes.CEntryPointEnterNode;
import com.oracle.svm.core.graal.nodes.CEntryPointLeaveNode;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.code.NonBytecodeStaticMethod;
import com.oracle.svm.hosted.code.SimpleSignature;
import com.oracle.svm.jni.hosted.JNIGraphKit;
import com.oracle.svm.jni.nativeapi.JNIEnvironment;
import com.oracle.svm.jni.nativeapi.JNIObjectHandle;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.java.FrameStateBuilder;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.calc.IntegerLessThanNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.WordPointer;

public final class JNIPrimitiveArrayOperationMethod
extends NonBytecodeStaticMethod {
    private final JavaKind elementKind;
    private final Operation operation;

    public JNIPrimitiveArrayOperationMethod(JavaKind elementKind, Operation operation, ResolvedJavaType declaringClass, ConstantPool constantPool, MetaAccessProvider metaAccess) {
        super(JNIPrimitiveArrayOperationMethod.createName(elementKind, operation), declaringClass, JNIPrimitiveArrayOperationMethod.createSignature(operation, metaAccess), constantPool);
        if (!EnumSet.of(JavaKind.Boolean, new JavaKind[]{JavaKind.Byte, JavaKind.Char, JavaKind.Short, JavaKind.Int, JavaKind.Long, JavaKind.Float, JavaKind.Double}).contains(elementKind)) {
            throw VMError.shouldNotReachHere();
        }
        this.elementKind = elementKind;
        this.operation = operation;
    }

    private static String createName(JavaKind elementKind, Operation operation) {
        StringBuilder sb = new StringBuilder(32);
        String kindName = elementKind.name();
        switch (operation) {
            case NEW: {
                sb.append("New").append(kindName).append("Array");
                break;
            }
            case GET_ELEMENTS: {
                sb.append("Get").append(kindName).append("ArrayElements");
                break;
            }
            case RELEASE_ELEMENTS: {
                sb.append("Release").append(kindName).append("ArrayElements");
                break;
            }
            case GET_REGION: {
                sb.append("Get").append(kindName).append("ArrayRegion");
                break;
            }
            case SET_REGION: {
                sb.append("Set").append(kindName).append("ArrayRegion");
            }
        }
        return sb.toString();
    }

    private static SimpleSignature createSignature(Operation operation, MetaAccessProvider metaAccess) {
        ResolvedJavaType returnType;
        ResolvedJavaType objectHandleType = metaAccess.lookupJavaType(JNIObjectHandle.class);
        ResolvedJavaType intType = metaAccess.lookupJavaType(Integer.TYPE);
        ArrayList<JavaType> args = new ArrayList<JavaType>();
        args.add((JavaType)metaAccess.lookupJavaType(JNIEnvironment.class));
        if (operation == Operation.NEW) {
            args.add((JavaType)intType);
            returnType = objectHandleType;
        } else {
            args.add((JavaType)objectHandleType);
            if (operation == Operation.GET_ELEMENTS) {
                args.add((JavaType)metaAccess.lookupJavaType(CCharPointer.class));
                returnType = metaAccess.lookupJavaType(WordPointer.class);
            } else if (operation == Operation.RELEASE_ELEMENTS) {
                args.add((JavaType)metaAccess.lookupJavaType(WordPointer.class));
                args.add((JavaType)intType);
                returnType = metaAccess.lookupJavaType(Void.TYPE);
            } else if (operation == Operation.GET_REGION || operation == Operation.SET_REGION) {
                args.add((JavaType)intType);
                args.add((JavaType)intType);
                args.add((JavaType)metaAccess.lookupJavaType(WordPointer.class));
                returnType = metaAccess.lookupJavaType(Void.TYPE);
            } else {
                throw VMError.shouldNotReachHere();
            }
        }
        return new SimpleSignature(args, (JavaType)returnType);
    }

    public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        JNIGraphKit kit = new JNIGraphKit(debug, providers, method);
        StructuredGraph graph = kit.getGraph();
        FrameStateBuilder state = new FrameStateBuilder(null, method, graph);
        state.initializeForMethodStart(null, true, providers.getGraphBuilderPlugins());
        ValueNode vmThread = kit.loadLocal(0, this.getSignature().getParameterKind(0));
        kit.append((ValueNode)CEntryPointEnterNode.enter(vmThread));
        List<ValueNode> arguments = kit.loadArguments(this.getSignature().toParameterTypes(null));
        ValueNode result = null;
        switch (this.operation) {
            case NEW: {
                result = this.newArray(providers, kit, arguments);
                break;
            }
            case GET_ELEMENTS: {
                ValueNode arrayHandle = arguments.get(1);
                InvokeWithExceptionNode array = kit.unboxHandle(arrayHandle);
                ValueNode isCopy = arguments.get(2);
                result = kit.pinArrayAndGetAddress((ValueNode)array, isCopy);
                break;
            }
            case RELEASE_ELEMENTS: {
                ValueNode address = arguments.get(2);
                kit.unpinArrayByAddress(address);
                break;
            }
            case GET_REGION: 
            case SET_REGION: {
                ValueNode arrayHandle = arguments.get(1);
                InvokeWithExceptionNode array = kit.unboxHandle(arrayHandle);
                ValueNode start = arguments.get(2);
                ValueNode count = arguments.get(3);
                ValueNode buffer = arguments.get(4);
                FixedWithNextNode fwn = this.operation == Operation.GET_REGION ? kit.getPrimitiveArrayRegionRetainException(this.elementKind, (ValueNode)array, start, count, buffer) : kit.setPrimitiveArrayRegionRetainException(this.elementKind, (ValueNode)array, start, count, buffer);
                if (!(fwn instanceof MergeNode)) break;
                MergeNode merge = (MergeNode)fwn;
                ((MergeNode)fwn).setStateAfter(state.create(kit.bci(), (StateSplit)merge));
                break;
            }
            default: {
                throw VMError.shouldNotReachHere();
            }
        }
        kit.appendStateSplitProxy(state);
        CEntryPointLeaveNode leave = new CEntryPointLeaveNode(CEntryPointLeaveNode.LeaveAction.Leave);
        kit.append((ValueNode)leave);
        kit.createReturn(result, result != null ? result.getStackKind() : JavaKind.Void);
        return kit.finalizeGraph();
    }

    private ValueNode newArray(HostedProviders providers, JNIGraphKit kit, List<ValueNode> arguments) {
        ResolvedJavaType elementType = providers.getMetaAccess().lookupJavaType(this.elementKind.toJavaClass());
        ValueNode length = arguments.get(1);
        ConstantNode zero = kit.createInt(0);
        kit.startIf((LogicNode)new IntegerLessThanNode(length, (ValueNode)zero), BranchProbabilityNode.VERY_SLOW_PATH_PROFILE);
        kit.thenPart();
        ConstantNode nullHandle = kit.createConstant((Constant)JavaConstant.INT_0, providers.getWordTypes().getWordKind());
        kit.elsePart();
        ValueNode array = kit.append((ValueNode)new NewArrayNode(elementType, length, true));
        InvokeWithExceptionNode arrayHandle = kit.boxObjectInLocalHandle(array);
        AbstractMergeNode merge = kit.endIf();
        merge.setStateAfter(kit.getFrameState().create(kit.bci(), (StateSplit)merge));
        Stamp handleStamp = providers.getWordTypes().getWordStamp(providers.getMetaAccess().lookupJavaType(JNIObjectHandle.class));
        return kit.unique((FloatingNode)new ValuePhiNode(handleStamp, merge, new ValueNode[]{nullHandle, arrayHandle}));
    }

    public CEntryPointData createEntryPointData() {
        return CEntryPointData.create(this, "", CEntryPointData.DEFAULT_NAME_TRANSFORMATION, "", CEntryPointOptions.NoPrologue.class, CEntryPointOptions.NoEpilogue.class, CEntryPoint.FatalExceptionHandler.class, CEntryPointOptions.Publish.NotPublished);
    }

    public static enum Operation {
        NEW,
        GET_ELEMENTS,
        RELEASE_ELEMENTS,
        GET_REGION,
        SET_REGION;

    }
}

