/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public abstract class ClassLoaderSupport {
    public boolean isNativeImageClassLoader(ClassLoader classLoader) {
        for (ClassLoader loader = classLoader; loader != null; loader = loader.getParent()) {
            if (!this.isNativeImageClassLoaderImpl(loader)) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean isNativeImageClassLoaderImpl(ClassLoader var1);

    public abstract void collectResources(ResourceCollector var1);

    public abstract List<ResourceBundle> getResourceBundle(String var1, Locale var2);

    public static interface ResourceCollector {
        public boolean isIncluded(String var1, String var2);

        public void addResource(String var1, String var2, InputStream var3);

        public void addDirectoryResource(String var1, String var2, String var3);
    }
}

