/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.struct.PinnedObjectField;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.option.HostedOptionKey;
import java.util.function.IntUnaryOperator;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.UniqueLocationIdentity;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class HeapChunk {
    private HeapChunk() {
    }

    public static void initialize(Header<?> chunk, Pointer objectsStart, UnsignedWord chunkSize) {
        HeapChunk.setEndOffset(chunk, chunkSize);
        HeapChunk.setTopPointer(chunk, objectsStart);
        HeapChunk.setSpace(chunk, null);
        HeapChunk.setNext(chunk, (Header)WordFactory.nullPointer());
        HeapChunk.setPrevious(chunk, (Header)WordFactory.nullPointer());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getTopOffset(Header<?> that) {
        assert (HeapChunk.getTopPointer(that).isNonNull()) : "Not safe: top currently points to NULL.";
        return that.getTopOffset();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer getTopPointer(Header<?> that) {
        return HeapChunk.asPointer(that).add(that.getTopOffset());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setTopPointer(Header<?> that, Pointer newTop) {
        that.setTopOffset((UnsignedWord)newTop.subtract((UnsignedWord)HeapChunk.asPointer(that)));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static void setTopPointerCarefully(Header<?> that, Pointer newTop) {
        assert (HeapChunk.getTopPointer(that).isNonNull()) : "Not safe: top currently points to NULL.";
        assert (HeapChunk.getTopPointer(that).belowOrEqual((UnsignedWord)newTop)) : "newTop too low.";
        assert (newTop.belowOrEqual((UnsignedWord)HeapChunk.getEndPointer(that))) : "newTop too high.";
        HeapChunk.setTopPointer(that, newTop);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getEndOffset(Header<?> that) {
        return that.getEndOffset();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer getEndPointer(Header<?> that) {
        return HeapChunk.asPointer(that).add(HeapChunk.getEndOffset(that));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setEndOffset(Header<?> that, UnsignedWord newEnd) {
        that.setEndOffset(newEnd);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Space getSpace(Header<?> that) {
        return that.getSpace();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setSpace(Header<?> that, Space newSpace) {
        that.setSpace(newSpace);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends Header<T>> T getPrevious(Header<T> that) {
        return (T)((Header)HeapChunk.pointerFromOffset(that, (ComparableWord)that.getOffsetToPreviousChunk()));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends Header<T>> void setPrevious(Header<T> that, T newPrevious) {
        that.setOffsetToPreviousChunk(HeapChunk.offsetFromPointer(that, newPrevious));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends Header<T>> T getNext(Header<T> that) {
        return (T)((Header)HeapChunk.pointerFromOffset(that, (ComparableWord)that.getOffsetToNextChunk()));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends Header<T>> void setNext(Header<T> that, T newNext) {
        that.setOffsetToNextChunk(HeapChunk.offsetFromPointer(that, newNext));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static <T extends PointerBase> T pointerFromOffset(Header<?> that, ComparableWord offset) {
        PointerBase pointer = WordFactory.nullPointer();
        if (offset.notEqual((ComparableWord)WordFactory.zero())) {
            pointer = (PointerBase)((SignedWord)that).add((SignedWord)offset);
        }
        return (T)pointer;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static SignedWord offsetFromPointer(Header<?> that, PointerBase pointer) {
        SignedWord offset = (SignedWord)WordFactory.zero();
        if (pointer.isNonNull()) {
            offset = ((SignedWord)pointer).subtract((SignedWord)that);
        }
        return offset;
    }

    @NeverInline(value="Not performance critical")
    public static boolean walkObjectsFrom(Header<?> that, Pointer offset, ObjectVisitor visitor) {
        return HeapChunk.walkObjectsFromInline(that, offset, visitor);
    }

    @AlwaysInline(value="GC performance")
    public static boolean walkObjectsFromInline(Header<?> that, Pointer startOffset, ObjectVisitor visitor) {
        Pointer offset = startOffset;
        while (offset.belowThan((UnsignedWord)HeapChunk.getTopPointer(that))) {
            Object obj = offset.toObject();
            if (!visitor.visitObjectInline(obj)) {
                return false;
            }
            offset = offset.add(LayoutEncoding.getSizeFromObjectInline(obj));
        }
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord availableObjectMemory(Header<?> that) {
        return that.getEndOffset().subtract(that.getTopOffset());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer asPointer(Header<?> that) {
        return (Pointer)that;
    }

    public static Header<?> getEnclosingHeapChunk(Object obj) {
        assert (!HeapImpl.getHeapImpl().isInImageHeap(obj) || HeapImpl.usesImageHeapChunks()) : "Must be checked before calling this method";
        assert (!ObjectHeaderImpl.isPointerToForwardedObject((Pointer)Word.objectToUntrackedPointer((Object)obj))) : "Forwarded objects must be a pointer and not an object";
        if (ObjectHeaderImpl.isAlignedObject(obj)) {
            return AlignedHeapChunk.getEnclosingChunk(obj);
        }
        assert (ObjectHeaderImpl.isUnalignedObject(obj));
        return UnalignedHeapChunk.getEnclosingChunk(obj);
    }

    public static Header<?> getEnclosingHeapChunk(Pointer ptrToObj, UnsignedWord header) {
        if (ObjectHeaderImpl.isAlignedHeader(header)) {
            return AlignedHeapChunk.getEnclosingChunkFromObjectPointer(ptrToObj);
        }
        return UnalignedHeapChunk.getEnclosingChunkFromObjectPointer(ptrToObj);
    }

    static abstract class MemoryWalkerAccessImpl<T extends Header<?>>
    implements MemoryWalker.HeapChunkAccess<T> {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        MemoryWalkerAccessImpl() {
        }

        @Override
        public UnsignedWord getStart(T heapChunk) {
            return (UnsignedWord)heapChunk;
        }

        @Override
        public UnsignedWord getSize(T heapChunk) {
            return HeapChunk.getEndOffset(heapChunk);
        }

        @Override
        public UnsignedWord getAllocationEnd(T heapChunk) {
            return HeapChunk.getTopPointer(heapChunk);
        }

        @Override
        public String getRegion(T heapChunk) {
            Space space = HeapChunk.getSpace(heapChunk);
            String result = space == null ? "free" : (space.isYoungSpace() ? "young" : "old");
            return result;
        }
    }

    @RawStructure
    public static interface Header<T extends Header<T>>
    extends HeaderPadding {
        @RawField
        @UniqueLocationIdentity
        public UnsignedWord getTopOffset();

        @RawField
        @UniqueLocationIdentity
        public void setTopOffset(UnsignedWord var1);

        @RawField
        @UniqueLocationIdentity
        public UnsignedWord getEndOffset();

        @RawField
        @UniqueLocationIdentity
        public void setEndOffset(UnsignedWord var1);

        @RawField
        @UniqueLocationIdentity
        @PinnedObjectField
        public Space getSpace();

        @RawField
        @UniqueLocationIdentity
        @PinnedObjectField
        public void setSpace(Space var1);

        @RawField
        @UniqueLocationIdentity
        public SignedWord getOffsetToPreviousChunk();

        @RawField
        @UniqueLocationIdentity
        public void setOffsetToPreviousChunk(SignedWord var1);

        @RawField
        @UniqueLocationIdentity
        public SignedWord getOffsetToNextChunk();

        @RawField
        @UniqueLocationIdentity
        public void setOffsetToNextChunk(SignedWord var1);
    }

    @RawStructure(sizeProvider=HeaderPaddingSizeProvider.class)
    private static interface HeaderPadding
    extends PointerBase {
    }

    static class HeaderPaddingSizeProvider
    implements IntUnaryOperator {
        HeaderPaddingSizeProvider() {
        }

        @Override
        public int applyAsInt(int operand) {
            assert (operand == 0) : "padding structure does not declare any fields";
            return Options.HeapChunkHeaderPadding.getValue();
        }
    }

    static class Options {
        @Option(help={"Number of bytes at the beginning of each heap chunk that are not used for payload data, i.e., can be freely used as metadata by the heap chunk provider."})
        public static final HostedOptionKey<Integer> HeapChunkHeaderPadding = new HostedOptionKey<Integer>(0);

        Options() {
        }
    }
}

