/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import com.oracle.svm.core.ReservedRegisters;
import com.oracle.svm.core.graal.nodes.ReadReservedRegisterFixedNode;
import com.oracle.svm.core.graal.nodes.ReadReservedRegisterFloatingNode;
import com.oracle.svm.core.meta.SharedMethod;
import jdk.vm.ci.code.Register;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;

public class ReadReservedRegister {
    public static ValueNode createReadStackPointerNode(StructuredGraph graph) {
        return ReadReservedRegister.createReadNode(graph, ReservedRegisters.singleton().getFrameRegister());
    }

    public static ValueNode createReadIsolateThreadNode(StructuredGraph graph) {
        return ReadReservedRegister.createReadNode(graph, ReservedRegisters.singleton().getThreadRegister());
    }

    public static ValueNode createReadHeapBaseNode(StructuredGraph graph) {
        return ReadReservedRegister.createReadNode(graph, ReservedRegisters.singleton().getHeapBaseRegister());
    }

    private static ValueNode createReadNode(StructuredGraph graph, Register register) {
        boolean isDeoptTarget;
        boolean bl = isDeoptTarget = graph.method() instanceof SharedMethod && ((SharedMethod)graph.method()).isDeoptTarget();
        if (isDeoptTarget) {
            return new ReadReservedRegisterFixedNode(register);
        }
        return new ReadReservedRegisterFloatingNode(register);
    }
}

