/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.jdk.UninterruptibleEntry;
import com.oracle.svm.core.jdk.UninterruptibleHashtable;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.UnmanagedMemorySupport;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public abstract class AbstractUninterruptibleHashtable
implements UninterruptibleHashtable {
    private static final int DEFAULT_TABLE_LENGTH = 2053;
    private final UninterruptibleEntry[] table;
    private int size;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public AbstractUninterruptibleHashtable() {
        this(2053);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public AbstractUninterruptibleHashtable(int primeLength) {
        this.table = this.createTable(primeLength);
        this.size = 0;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected abstract UninterruptibleEntry[] createTable(int var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected abstract boolean isEqual(UninterruptibleEntry var1, UninterruptibleEntry var2);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected abstract UninterruptibleEntry copyToHeap(UninterruptibleEntry var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected UninterruptibleEntry copyToHeap(UninterruptibleEntry pointerOnStack, UnsignedWord sizeToAlloc) {
        UninterruptibleEntry pointerOnHeap = (UninterruptibleEntry)((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).malloc(sizeToAlloc);
        if (pointerOnHeap.isNonNull()) {
            UnmanagedMemoryUtil.copy((Pointer)pointerOnStack, (Pointer)pointerOnHeap, sizeToAlloc);
            return pointerOnHeap;
        }
        return (UninterruptibleEntry)WordFactory.nullPointer();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void free(UninterruptibleEntry entry) {
        ((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).free((PointerBase)entry);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected UninterruptibleEntry insertEntry(UninterruptibleEntry valueOnStack) {
        int index = Integer.remainderUnsigned(valueOnStack.getHash(), 2053);
        UninterruptibleEntry newEntry = this.copyToHeap(valueOnStack);
        if (newEntry.isNonNull()) {
            UninterruptibleEntry existingEntry = this.table[index];
            newEntry.setNext(existingEntry);
            this.table[index] = newEntry;
            ++this.size;
            return newEntry;
        }
        return (UninterruptibleEntry)WordFactory.nullPointer();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getSize() {
        return this.size;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UninterruptibleEntry[] getTable() {
        return this.table;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UninterruptibleEntry get(UninterruptibleEntry valueOnStack) {
        int index = Integer.remainderUnsigned(valueOnStack.getHash(), 2053);
        UninterruptibleEntry entry = this.table[index];
        while (entry.isNonNull()) {
            if (this.isEqual(valueOnStack, entry)) {
                return entry;
            }
            entry = entry.getNext();
        }
        return (UninterruptibleEntry)WordFactory.nullPointer();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UninterruptibleEntry getOrPut(UninterruptibleEntry valueOnStack) {
        assert (valueOnStack.isNonNull());
        UninterruptibleEntry entry = this.get(valueOnStack);
        if (entry.isNonNull()) {
            return (UninterruptibleEntry)WordFactory.nullPointer();
        }
        return this.insertEntry(valueOnStack);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean putIfAbsent(UninterruptibleEntry valueOnStack) {
        assert (valueOnStack.isNonNull());
        UninterruptibleEntry existingEntry = this.get(valueOnStack);
        if (existingEntry.isNonNull()) {
            return false;
        }
        UninterruptibleEntry newEntry = this.insertEntry(valueOnStack);
        return newEntry.isNonNull();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void clear() {
        for (int i = 0; i < this.table.length; ++i) {
            UninterruptibleEntry entry = this.table[i];
            while (entry.isNonNull()) {
                UninterruptibleEntry tmp = entry;
                entry = entry.getNext();
                this.free(tmp);
            }
            this.table[i] = (UninterruptibleEntry)WordFactory.nullPointer();
        }
        this.size = 0;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void teardown() {
        this.clear();
    }
}

