/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.jdk.StackTraceUtils;
import com.oracle.svm.core.jdk.Target_jdk_internal_loader_ClassLoaders;
import com.oracle.svm.core.stack.JavaStackFrameVisitor;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;

class GetLatestUserDefinedClassLoaderVisitor
extends JavaStackFrameVisitor {
    ClassLoader result;

    GetLatestUserDefinedClassLoaderVisitor() {
    }

    @Override
    public boolean visitFrame(FrameInfoQueryResult frameInfo) {
        if (!StackTraceUtils.shouldShowFrame(frameInfo, true, true, false)) {
            return true;
        }
        ClassLoader classLoader = frameInfo.getSourceClass().getClassLoader();
        if (classLoader == null || GetLatestUserDefinedClassLoaderVisitor.isExtensionOrPlatformLoader(classLoader)) {
            return true;
        }
        this.result = classLoader;
        return false;
    }

    private static boolean isExtensionOrPlatformLoader(ClassLoader classLoader) {
        if (JavaVersionUtil.JAVA_SPEC > 8) {
            return classLoader == Target_jdk_internal_loader_ClassLoaders.platformClassLoader();
        }
        return false;
    }
}

