/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.ProtectionDomainSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.security.CodeSource;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
final class ProtectionDomainFeature
implements Feature {
    ProtectionDomainFeature() {
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(ProtectionDomainSupport.class, (Object)new ProtectionDomainSupport());
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        Boolean useApplicationCodeSourceLocation = ProtectionDomainSupport.Options.UseApplicationCodeSourceLocation.getValue();
        if (useApplicationCodeSourceLocation == null) {
            access.registerReachabilityHandler(ProtectionDomainSupport::enableCodeSource, new Object[]{ReflectionUtil.lookupMethod(CodeSource.class, (String)"getLocation", (Class[])new Class[0])});
        } else if (useApplicationCodeSourceLocation.booleanValue()) {
            ProtectionDomainSupport.enableCodeSource(null);
        }
    }
}

