/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.headers;

import com.oracle.svm.core.RegisterDumper;
import com.oracle.svm.core.posix.headers.PosixDirectives;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.constant.CEnum;
import org.graalvm.nativeimage.c.constant.CEnumValue;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;
import org.graalvm.nativeimage.c.struct.CField;
import org.graalvm.nativeimage.c.struct.CFieldAddress;
import org.graalvm.nativeimage.c.struct.CFieldOffset;
import org.graalvm.nativeimage.c.struct.CPointerTo;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.nativeimage.c.type.VoidPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.PointerBase;

@CContext(value=PosixDirectives.class)
public class Signal {
    @CFunction
    public static native int kill(int var0, int var1);

    @CConstant
    public static native int SIG_BLOCK();

    @CConstant
    public static native int SIG_UNBLOCK();

    @CConstant
    public static native int SIG_SETMASK();

    @CFunction
    public static native int sigprocmask(int var0, sigset_tPointer var1, sigset_tPointer var2);

    @CConstant
    public static native SignalDispatcher SIG_DFL();

    @CConstant
    public static native SignalDispatcher SIG_IGN();

    @CConstant
    public static native SignalDispatcher SIG_ERR();

    @CFunction
    public static native int raise(int var0);

    @CConstant
    public static native int SA_RESTART();

    @CConstant
    public static native int SA_SIGINFO();

    @CConstant
    public static native int SA_NODEFER();

    @CFunction
    public static native int sigaction(int var0, sigaction var1, sigaction var2);

    @CFunction
    public static native int sigemptyset(sigset_tPointer var0);

    @CFunction
    public static native int sigaddset(sigset_tPointer var0, int var1);

    @Platforms(value={Platform.DARWIN_AARCH64.class, Platform.IOS_AARCH64.class})
    @CStruct(value="__darwin_mcontext64", addStructKeyword=true)
    public static interface AArch64DarwinMContext64
    extends PointerBase {
        @CFieldAddress(value="__ss.__x")
        public GregsPointer regs();

        @CField(value="__ss.__fp")
        public long fp();

        @CField(value="__ss.__lr")
        public long lr();

        @CField(value="__ss.__sp")
        public long sp();

        @CField(value="__ss.__pc")
        public long pc();
    }

    @Platforms(value={Platform.DARWIN_AMD64.class})
    @CStruct(value="__darwin_mcontext64", addStructKeyword=true)
    public static interface AMD64DarwinMContext64
    extends PointerBase {
        @CFieldOffset(value="__ss.__rax")
        public int rax_offset();

        @CFieldOffset(value="__ss.__rbx")
        public int rbx_offset();

        @CFieldOffset(value="__ss.__rip")
        public int rip_offset();

        @CFieldOffset(value="__ss.__rsp")
        public int rsp_offset();

        @CFieldOffset(value="__ss.__rcx")
        public int rcx_offset();

        @CFieldOffset(value="__ss.__rdx")
        public int rdx_offset();

        @CFieldOffset(value="__ss.__rbp")
        public int rbp_offset();

        @CFieldOffset(value="__ss.__rsi")
        public int rsi_offset();

        @CFieldOffset(value="__ss.__rdi")
        public int rdi_offset();

        @CFieldOffset(value="__ss.__r8")
        public int r8_offset();

        @CFieldOffset(value="__ss.__r9")
        public int r9_offset();

        @CFieldOffset(value="__ss.__r10")
        public int r10_offset();

        @CFieldOffset(value="__ss.__r11")
        public int r11_offset();

        @CFieldOffset(value="__ss.__r12")
        public int r12_offset();

        @CFieldOffset(value="__ss.__r13")
        public int r13_offset();

        @CFieldOffset(value="__ss.__r14")
        public int r14_offset();

        @CFieldOffset(value="__ss.__r15")
        public int r15_offset();

        @CFieldOffset(value="__ss.__rflags")
        public int efl_offset();
    }

    @CStruct(value="mcontext_t")
    @Platforms(value={Platform.LINUX_AARCH64.class, Platform.ANDROID_AARCH64.class})
    public static interface mcontext_linux_aarch64_t
    extends PointerBase {
        @CField
        public long fault_address();

        @CFieldAddress
        public GregsPointer regs();

        @CField
        public long sp();

        @CField
        public long pc();

        @CField
        public long pstate();
    }

    @Platforms(value={Platform.LINUX_AMD64.class})
    @CContext(value=PosixDirectives.class)
    public static final class GregEnumLinuxAMD64 {
        @CConstant
        public static native int REG_R8();

        @CConstant
        public static native int REG_R9();

        @CConstant
        public static native int REG_R10();

        @CConstant
        public static native int REG_R11();

        @CConstant
        public static native int REG_R12();

        @CConstant
        public static native int REG_R13();

        @CConstant
        public static native int REG_R14();

        @CConstant
        public static native int REG_R15();

        @CConstant
        public static native int REG_RDI();

        @CConstant
        public static native int REG_RSI();

        @CConstant
        public static native int REG_RBP();

        @CConstant
        public static native int REG_RBX();

        @CConstant
        public static native int REG_RDX();

        @CConstant
        public static native int REG_RAX();

        @CConstant
        public static native int REG_RCX();

        @CConstant
        public static native int REG_RSP();

        @CConstant
        public static native int REG_RIP();

        @CConstant
        public static native int REG_EFL();

        @CConstant
        public static native int REG_CSGSFS();

        @CConstant
        public static native int REG_ERR();

        @CConstant
        public static native int REG_TRAPNO();

        @CConstant
        public static native int REG_OLDMASK();

        @CConstant
        public static native int REG_CR2();
    }

    @Platforms(value={Platform.DARWIN.class})
    @CEnum
    @CContext(value=PosixDirectives.class)
    public static enum DarwinSignalEnum {
        SIGINFO,
        SIGEMT;


        @CEnumValue
        public native int getCValue();
    }

    @Platforms(value={Platform.LINUX.class})
    @CEnum
    @CContext(value=PosixDirectives.class)
    public static enum LinuxSignalEnum {
        SIGPOLL,
        SIGPWR;


        @CEnumValue
        public native int getCValue();
    }

    @CEnum
    @CContext(value=PosixDirectives.class)
    public static enum SignalEnum {
        SIGABRT,
        SIGALRM,
        SIGBUS,
        SIGCHLD,
        SIGCONT,
        SIGFPE,
        SIGHUP,
        SIGILL,
        SIGINT,
        SIGIO,
        SIGIOT,
        SIGKILL,
        SIGPIPE,
        SIGPROF,
        SIGQUIT,
        SIGSEGV,
        SIGSTOP,
        SIGSYS,
        SIGTERM,
        SIGTRAP,
        SIGTSTP,
        SIGTTIN,
        SIGTTOU,
        SIGURG,
        SIGUSR1,
        SIGUSR2,
        SIGVTALRM,
        SIGWINCH,
        SIGXCPU,
        SIGXFSZ;


        @CEnumValue
        public native int getCValue();
    }

    @CStruct(addStructKeyword=true)
    public static interface sigaction
    extends PointerBase {
        @CField
        public SignalDispatcher sa_handler();

        @CField
        public void sa_handler(SignalDispatcher var1);

        @CField
        public AdvancedSignalDispatcher sa_sigaction();

        @CField
        public void sa_sigaction(AdvancedSignalDispatcher var1);

        @CField
        public int sa_flags();

        @CField
        public void sa_flags(int var1);

        @CFieldAddress
        public sigset_tPointer sa_mask();
    }

    public static interface AdvancedSignalDispatcher
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void dispatch(int var1, siginfo_t var2, WordPointer var3);
    }

    @CStruct
    public static interface ucontext_t
    extends RegisterDumper.Context {
        @CFieldAddress(value="uc_mcontext.gregs")
        @Platforms(value={Platform.LINUX_AMD64.class})
        public GregsPointer uc_mcontext_linux_amd64_gregs();

        @CFieldAddress(value="uc_mcontext")
        @Platforms(value={Platform.LINUX_AARCH64.class, Platform.ANDROID_AARCH64.class})
        public mcontext_linux_aarch64_t uc_mcontext_linux_aarch64();

        @CField(value="uc_mcontext")
        @Platforms(value={Platform.DARWIN_AMD64.class})
        public AMD64DarwinMContext64 uc_mcontext_darwin_amd64();

        @CField(value="uc_mcontext")
        @Platforms(value={Platform.DARWIN_AARCH64.class, Platform.IOS_AARCH64.class})
        public AArch64DarwinMContext64 uc_mcontext_darwin_aarch64();
    }

    @Platforms(value={Platform.LINUX.class, Platform.DARWIN_AARCH64.class, Platform.IOS_AARCH64.class})
    @CPointerTo(nameOfCType="long long int")
    public static interface GregsPointer
    extends PointerBase {
        public long read(int var1);
    }

    @CStruct(isIncomplete=true)
    public static interface siginfo_t
    extends PointerBase {
        @CField
        public int si_signo();

        @CField
        public int si_errno();

        @CField
        public int si_code();

        @CField
        public VoidPointer si_addr();
    }

    public static interface SignalDispatcher
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void dispatch(int var1);
    }

    @CPointerTo(nameOfCType="sigset_t")
    public static interface sigset_tPointer
    extends PointerBase {
    }
}

