/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.isolated;

import com.oracle.svm.core.meta.SubstrateObjectConstant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.replacements.SnippetCounter;
import org.graalvm.compiler.replacements.SnippetIntegerHistogram;

final class DisableSnippetCountersPlugin
implements NodePlugin {
    private static final String snippetCounterName = 'L' + SnippetCounter.class.getName().replace('.', '/') + ';';
    private static final String snippetIntegerHistogramName = 'L' + SnippetIntegerHistogram.class.getName().replace('.', '/') + ';';

    DisableSnippetCountersPlugin() {
    }

    public boolean handleLoadField(GraphBuilderContext b, ValueNode object, ResolvedJavaField field) {
        if (field.getName().equals("group") && field.getDeclaringClass().getName().equals(snippetCounterName)) {
            b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forConstant((JavaConstant)JavaConstant.NULL_POINTER, (MetaAccessProvider)b.getMetaAccess()));
            return true;
        }
        if (field.getType().getName().equals(snippetCounterName)) {
            b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forConstant((JavaConstant)SubstrateObjectConstant.forObject(SnippetCounter.DISABLED_COUNTER), (MetaAccessProvider)b.getMetaAccess()));
            return true;
        }
        if (field.getType().getName().equals(snippetIntegerHistogramName)) {
            b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forConstant((JavaConstant)SubstrateObjectConstant.forObject(SnippetIntegerHistogram.DISABLED_COUNTER), (MetaAccessProvider)b.getMetaAccess()));
            return true;
        }
        return false;
    }
}

