/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.classinitialization;

import com.oracle.graal.pointsto.phases.NoClassInitializationPlugin;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.classinitialization.EnsureClassInitializedNode;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.hosted.classinitialization.AbortOnDisallowedNode;
import com.oracle.svm.hosted.classinitialization.AbortOnRecursiveInliningPlugin;
import com.oracle.svm.hosted.classinitialization.ClassInitializerGraphBuilderPhase;
import com.oracle.svm.hosted.classinitialization.ClassInitializerHasSideEffectsException;
import com.oracle.svm.hosted.classinitialization.ConfigurableClassInitialization;
import com.oracle.svm.hosted.classinitialization.InitKind;
import com.oracle.svm.hosted.phases.EarlyConstantFoldLoadFieldPlugin;
import com.oracle.svm.hosted.snippets.ReflectionPlugins;
import com.oracle.svm.hosted.snippets.SubstrateGraphBuilderPlugins;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.java.BytecodeParser;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.ClassInitializationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.phases.util.Providers;

final class EarlyClassInitializerAnalysis {
    private final ConfigurableClassInitialization classInitializationSupport;
    private final Providers originalProviders;
    private final HighTierContext context;

    EarlyClassInitializerAnalysis(ConfigurableClassInitialization classInitializationSupport) {
        this.classInitializationSupport = classInitializationSupport;
        this.originalProviders = GraalAccess.getOriginalProviders();
        this.context = new HighTierContext(this.originalProviders, null, OptimisticOptimizations.NONE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean canInitializeWithoutSideEffects(Class<?> clazz, Set<Class<?>> existingAnalyzedClasses) {
        ResolvedJavaType type = this.originalProviders.getMetaAccess().lookupJavaType(clazz);
        assert (type.getSuperclass() == null || type.getSuperclass().isInitialized()) : "This analysis assumes that the superclass was successfully analyzed and initialized beforehand: " + type.toJavaName(true);
        ResolvedJavaMethod clinit = type.getClassInitializer();
        if (clinit == null) {
            return true;
        }
        if (clinit.getCode() == null) {
            return false;
        }
        Set<Class<?>> analyzedClasses = existingAnalyzedClasses;
        if (analyzedClasses == null) {
            analyzedClasses = new HashSet();
        } else if (analyzedClasses.contains(clazz)) {
            return false;
        }
        analyzedClasses.add(clazz);
        OptionValues options = HostedOptionValues.singleton();
        DebugContext debug = new DebugContext.Builder(options).build();
        try (DebugContext.Scope s = debug.scope((Object)"EarlyClassInitializerAnalysis", (Object)clinit);){
            boolean bl = this.canInitializeWithoutSideEffects(clinit, analyzedClasses, options, debug);
            return bl;
        }
        catch (Throwable ex) {
            throw debug.handle(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canInitializeWithoutSideEffects(ResolvedJavaMethod clinit, Set<Class<?>> analyzedClasses, OptionValues options, DebugContext debug) {
        InvocationPlugins invocationPlugins = new InvocationPlugins();
        GraphBuilderConfiguration.Plugins plugins = new GraphBuilderConfiguration.Plugins(invocationPlugins);
        plugins.appendInlineInvokePlugin((InlineInvokePlugin)new AbortOnRecursiveInliningPlugin());
        AbortOnUnitializedClassPlugin classInitializationPlugin = new AbortOnUnitializedClassPlugin(analyzedClasses);
        plugins.setClassInitializationPlugin((ClassInitializationPlugin)classInitializationPlugin);
        plugins.appendNodePlugin((NodePlugin)new EarlyConstantFoldLoadFieldPlugin(this.originalProviders.getMetaAccess(), this.originalProviders.getSnippetReflection()));
        SubstrateGraphBuilderPlugins.registerClassDesiredAssertionStatusPlugin(invocationPlugins, this.originalProviders.getSnippetReflection());
        ReflectionPlugins.registerInvocationPlugins(this.classInitializationSupport.loader, this.originalProviders.getSnippetReflection(), null, (ClassInitializationPlugin)classInitializationPlugin, invocationPlugins, null, ParsingReason.EarlyClassInitializerAnalysis);
        GraphBuilderConfiguration graphBuilderConfig = GraphBuilderConfiguration.getDefault((GraphBuilderConfiguration.Plugins)plugins).withEagerResolving(true);
        StructuredGraph graph = new StructuredGraph.Builder(options, debug).method(clinit).build();
        graph.setGuardsStage(StructuredGraph.GuardsStage.FIXED_DEOPTS);
        ClassInitializerGraphBuilderPhase builderPhase = new ClassInitializerGraphBuilderPhase((CoreProviders)this.context, graphBuilderConfig, this.context.getOptimisticOptimizations());
        try (Graph.NodeEventScope nes = graph.trackNodeEvents((Graph.NodeEventListener)new AbortOnDisallowedNode());){
            builderPhase.apply(graph, this.context);
            boolean bl = true;
            return bl;
        }
        catch (ClassInitializerHasSideEffectsException ex) {
            return false;
        }
        catch (BytecodeParser.BytecodeParserError ex) {
            if (!(ex.getCause() instanceof ClassInitializerHasSideEffectsException)) throw ex;
            return false;
        }
    }

    final class AbortOnUnitializedClassPlugin
    extends NoClassInitializationPlugin {
        private final Set<Class<?>> analyzedClasses;

        AbortOnUnitializedClassPlugin(Set<Class<?>> analyzedClasses) {
            this.analyzedClasses = analyzedClasses;
        }

        public boolean apply(GraphBuilderContext b, ResolvedJavaType type, Supplier<FrameState> frameState, ValueNode[] classInit) {
            ResolvedJavaMethod clinitMethod = b.getGraph().method();
            if (!EnsureClassInitializedNode.needsRuntimeInitialization(clinitMethod.getDeclaringClass(), type)) {
                return false;
            }
            if (EarlyClassInitializerAnalysis.this.classInitializationSupport.computeInitKindAndMaybeInitializeClass(ConfigurableClassInitialization.getJavaClass(type), true, this.analyzedClasses) != InitKind.RUN_TIME) {
                assert (type.isInitialized()) : "Type must be initialized now";
                return false;
            }
            throw new ClassInitializerHasSideEffectsException("Reference of class that is not initialized: " + type.toJavaName(true));
        }
    }
}

