/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.target;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.reflect.MethodMetadataDecoder;
import com.oracle.svm.core.util.ByteArrayReader;
import com.oracle.svm.reflect.target.MethodMetadataEncoding;
import com.oracle.svm.reflect.target.Target_java_lang_reflect_Constructor;
import com.oracle.svm.reflect.target.Target_java_lang_reflect_Executable;
import com.oracle.svm.reflect.target.Target_java_lang_reflect_Method;
import com.oracle.svm.reflect.target.Target_java_lang_reflect_Parameter;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.util.UnsafeArrayTypeReader;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;

public class MethodMetadataDecoderImpl
implements MethodMetadataDecoder {
    public static final int NO_METHOD_METADATA = -1;

    @Fold
    static boolean hasQueriedMethods() {
        return !((RuntimeReflectionSupport)ImageSingletons.lookup(RuntimeReflectionSupport.class)).getQueriedOnlyMethods().isEmpty();
    }

    @Override
    public Pair<Executable[], MethodMetadataDecoder.MethodDescriptor[]> getQueriedAndHidingMethods(DynamicHub declaringType) {
        int dataOffset = MethodMetadataDecoderImpl.getOffset(declaringType.getTypeID());
        if (SubstrateOptions.ConfigureReflectionMetadata.getValue().booleanValue() && MethodMetadataDecoderImpl.getOffset(declaringType.getTypeID()) != -1) {
            CodeInfo codeInfo = CodeInfoTable.getImageCodeInfo();
            byte[] data = ((MethodMetadataEncoding)ImageSingletons.lookup(MethodMetadataEncoding.class)).getMethodsEncoding();
            UnsafeArrayTypeReader dataReader = UnsafeArrayTypeReader.create((byte[])data, (long)dataOffset, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
            Executable[] queriedMethods = MethodMetadataDecoderImpl.decodeArray(dataReader, Executable.class, () -> MethodMetadataDecoderImpl.decodeReflectionMethod(dataReader, codeInfo, DynamicHub.toClass(declaringType)));
            MethodMetadataDecoder.MethodDescriptor[] hiddenMethods = MethodMetadataDecoderImpl.decodeArray(dataReader, MethodMetadataDecoder.MethodDescriptor.class, () -> MethodMetadataDecoderImpl.decodeSimpleMethod(dataReader, codeInfo, DynamicHub.toClass(declaringType)));
            return Pair.create((Object)queriedMethods, (Object)hiddenMethods);
        }
        return Pair.create((Object)new Executable[0], (Object)new MethodMetadataDecoder.MethodDescriptor[0]);
    }

    @Override
    public MethodMetadataDecoder.MethodDescriptor[] getAllReachableMethods() {
        if (!SubstrateOptions.IncludeMethodData.getValue().booleanValue()) {
            return new MethodMetadataDecoder.MethodDescriptor[0];
        }
        CodeInfo codeInfo = CodeInfoTable.getImageCodeInfo();
        byte[] data = ((MethodMetadataEncoding)ImageSingletons.lookup(MethodMetadataEncoding.class)).getMethodsEncoding();
        UnsafeArrayTypeReader dataReader = UnsafeArrayTypeReader.create((byte[])data, (long)0L, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        ArrayList<MethodMetadataDecoder.MethodDescriptor> allMethods = new ArrayList<MethodMetadataDecoder.MethodDescriptor>();
        for (int i = 0; i < ((MethodMetadataEncoding)ImageSingletons.lookup(MethodMetadataEncoding.class)).getIndexEncoding().length / 4; ++i) {
            Class<?> declaringClass;
            int dataOffset = MethodMetadataDecoderImpl.getOffset(i);
            if (dataOffset == -1) continue;
            dataReader.setByteIndex((long)dataOffset);
            if (SubstrateOptions.ConfigureReflectionMetadata.getValue().booleanValue()) {
                MethodMetadataDecoderImpl.decodeArray(dataReader, Executable.class, () -> MethodMetadataDecoderImpl.decodeReflectionMethod(dataReader, codeInfo, null));
                MethodMetadataDecoderImpl.decodeArray(dataReader, MethodMetadataDecoder.MethodDescriptor.class, () -> MethodMetadataDecoderImpl.decodeSimpleMethod(dataReader, codeInfo, null));
            }
            if ((declaringClass = MethodMetadataDecoderImpl.decodeType(dataReader, codeInfo)) == null) continue;
            allMethods.addAll(Arrays.asList(MethodMetadataDecoderImpl.decodeArray(dataReader, MethodMetadataDecoder.MethodDescriptor.class, () -> MethodMetadataDecoderImpl.decodeSimpleMethod(dataReader, codeInfo, declaringClass))));
        }
        return allMethods.toArray(new MethodMetadataDecoder.MethodDescriptor[0]);
    }

    @Override
    public long getMetadataByteLength() {
        MethodMetadataEncoding encoding = (MethodMetadataEncoding)ImageSingletons.lookup(MethodMetadataEncoding.class);
        return encoding.getMethodsEncoding().length + encoding.getIndexEncoding().length;
    }

    private static int getOffset(int typeID) {
        MethodMetadataEncoding encoding = (MethodMetadataEncoding)ImageSingletons.lookup(MethodMetadataEncoding.class);
        byte[] index = encoding.getIndexEncoding();
        UnsafeArrayTypeReader indexReader = UnsafeArrayTypeReader.create((byte[])index, (long)(4 * typeID), (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        return indexReader.getS4();
    }

    private static Executable decodeReflectionMethod(UnsafeArrayTypeReader buf, CodeInfo info, Class<?> declaringClass) {
        Target_java_lang_reflect_Executable executable;
        ReflectParameterDescriptor[] reflectParameters;
        String name = MethodMetadataDecoderImpl.decodeName(buf, info);
        Class[] parameterTypes = MethodMetadataDecoderImpl.decodeArray(buf, Class.class, () -> MethodMetadataDecoderImpl.decodeType(buf, info));
        int modifiers = buf.getUVInt();
        Class<?> returnType = MethodMetadataDecoderImpl.decodeType(buf, info);
        Class[] exceptionTypes = MethodMetadataDecoderImpl.decodeArray(buf, Class.class, () -> MethodMetadataDecoderImpl.decodeType(buf, info));
        String signature = MethodMetadataDecoderImpl.decodeName(buf, info);
        byte[] annotations = MethodMetadataDecoderImpl.decodeByteArray(buf);
        byte[] parameterAnnotations = MethodMetadataDecoderImpl.decodeByteArray(buf);
        byte[] typeAnnotations = MethodMetadataDecoderImpl.decodeByteArray(buf);
        boolean hasRealParameterData = buf.getU1() == 1;
        ReflectParameterDescriptor[] reflectParameterDescriptorArray = reflectParameters = hasRealParameterData ? MethodMetadataDecoderImpl.decodeArray(buf, ReflectParameterDescriptor.class, () -> MethodMetadataDecoderImpl.decodeReflectParameter(buf, info)) : null;
        if (name.equals("<init>")) {
            assert (returnType == Void.TYPE);
            Target_java_lang_reflect_Constructor constructor = new Target_java_lang_reflect_Constructor();
            constructor.constructor(declaringClass, parameterTypes, exceptionTypes, modifiers, -1, signature, annotations, parameterAnnotations);
            executable = SubstrateUtil.cast(constructor, Target_java_lang_reflect_Executable.class);
        } else {
            Target_java_lang_reflect_Method method = new Target_java_lang_reflect_Method();
            method.constructor(declaringClass, name, parameterTypes, returnType, exceptionTypes, modifiers, -1, signature, annotations, parameterAnnotations, null);
            executable = SubstrateUtil.cast(method, Target_java_lang_reflect_Executable.class);
        }
        if (MethodMetadataDecoderImpl.hasQueriedMethods()) {
            executable.hasRealParameterData = hasRealParameterData;
            if (hasRealParameterData) {
                MethodMetadataDecoderImpl.fillReflectParameters(executable, reflectParameters);
            }
            executable.typeAnnotations = typeAnnotations;
        }
        return SubstrateUtil.cast(executable, Executable.class);
    }

    private static void fillReflectParameters(Target_java_lang_reflect_Executable executable, ReflectParameterDescriptor[] reflectParameters) {
        executable.parameters = new Target_java_lang_reflect_Parameter[reflectParameters.length];
        for (int i = 0; i < reflectParameters.length; ++i) {
            executable.parameters[i] = new Target_java_lang_reflect_Parameter();
            executable.parameters[i].constructor(reflectParameters[i].getName(), reflectParameters[i].getModifiers(), executable, i);
        }
    }

    private static MethodMetadataDecoder.MethodDescriptor decodeSimpleMethod(UnsafeArrayTypeReader buf, CodeInfo info, Class<?> declaringClass) {
        String name = MethodMetadataDecoderImpl.decodeName(buf, info);
        Class[] paramTypes = MethodMetadataDecoderImpl.decodeArray(buf, Class.class, () -> MethodMetadataDecoderImpl.decodeType(buf, info));
        return new MethodMetadataDecoder.MethodDescriptor(declaringClass, name, paramTypes);
    }

    private static Class<?> decodeType(UnsafeArrayTypeReader buf, CodeInfo info) {
        int classIndex = buf.getSVInt();
        if (classIndex == -1) {
            return null;
        }
        return NonmovableArrays.getObject(CodeInfoAccess.getFrameInfoSourceClasses(info), classIndex);
    }

    private static String decodeName(UnsafeArrayTypeReader buf, CodeInfo info) {
        int nameIndex = buf.getSVInt();
        String name = NonmovableArrays.getObject(CodeInfoAccess.getFrameInfoSourceMethodNames(info), nameIndex);
        return name == null ? null : name.intern();
    }

    private static <T> T[] decodeArray(UnsafeArrayTypeReader buf, Class<T> elementType, Supplier<T> elementDecoder) {
        int length = buf.getUVInt();
        Object[] result = (Object[])Array.newInstance(elementType, length);
        for (int i = 0; i < length; ++i) {
            result[i] = elementDecoder.get();
        }
        return result;
    }

    private static byte[] decodeByteArray(UnsafeArrayTypeReader buf) {
        int length = buf.getUVInt();
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (byte)buf.getS1();
        }
        return result;
    }

    private static ReflectParameterDescriptor decodeReflectParameter(UnsafeArrayTypeReader buf, CodeInfo info) {
        String name = MethodMetadataDecoderImpl.decodeName(buf, info);
        int modifiers = buf.getS4();
        return new ReflectParameterDescriptor(name, modifiers);
    }

    public static class ReflectParameterDescriptor {
        private final String name;
        private final int modifiers;

        public ReflectParameterDescriptor(String name, int modifiers) {
            this.name = name;
            this.modifiers = modifiers;
        }

        public String getName() {
            return this.name;
        }

        public int getModifiers() {
            return this.modifiers;
        }
    }
}

