/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.graal;

import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.graal.BarrierSnippetCounters;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.option.HostedOptionKey;
import java.util.Map;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.BreakpointNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.FixedValueAnchorNode;
import org.graalvm.compiler.nodes.gc.SerialArrayRangeWriteBarrier;
import org.graalvm.compiler.nodes.gc.SerialWriteBarrier;
import org.graalvm.compiler.nodes.gc.WriteBarrier;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.UnsignedWord;

public class BarrierSnippets
extends SubstrateTemplates
implements Snippets {
    public static final LocationIdentity CARD_REMEMBERED_SET_LOCATION = NamedLocationIdentity.mutable((String)"CardRememberedSet");

    @Fold
    static BarrierSnippetCounters counters() {
        return (BarrierSnippetCounters)ImageSingletons.lookup(BarrierSnippetCounters.class);
    }

    BarrierSnippets(OptionValues options, Providers providers) {
        super(options, providers);
    }

    public void registerLowerings(Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        PostWriteBarrierLowering lowering = new PostWriteBarrierLowering();
        lowerings.put(SerialWriteBarrier.class, lowering);
        lowerings.put(SerialArrayRangeWriteBarrier.class, lowering);
    }

    @Snippet
    public static void postWriteBarrierSnippet(Object object, @Snippet.ConstantParameter boolean alwaysAlignedChunk, @Snippet.ConstantParameter boolean verifyOnly) {
        boolean unaligned;
        boolean needsBarrier;
        BarrierSnippets.counters().postWriteBarrier.inc();
        Object fixedObject = FixedValueAnchorNode.getObject((Object)object);
        UnsignedWord objectHeader = ObjectHeaderImpl.readHeaderFromObject(fixedObject);
        if (Options.VerifyWriteBarriers.getValue().booleanValue() && alwaysAlignedChunk && (ObjectHeaderImpl.isUnalignedHeader(objectHeader) || object == null || object.getClass().isArray())) {
            BreakpointNode.breakpoint();
        }
        if (BranchProbabilityNode.probability((double)0.9, (!(needsBarrier = RememberedSet.get().hasRememberedSet(objectHeader)) ? 1 : 0) != 0)) {
            return;
        }
        if (!alwaysAlignedChunk && BranchProbabilityNode.probability((double)0.4, (boolean)(unaligned = ObjectHeaderImpl.isUnalignedHeader(objectHeader)))) {
            BarrierSnippets.counters().postWriteBarrierUnaligned.inc();
            RememberedSet.get().dirtyCardForUnalignedObject(fixedObject, verifyOnly);
            return;
        }
        BarrierSnippets.counters().postWriteBarrierAligned.inc();
        RememberedSet.get().dirtyCardForAlignedObject(fixedObject, verifyOnly);
    }

    public static final class TestingBackDoor {
        private TestingBackDoor() {
        }

        public static long getPostWriteBarrierCount() {
            return BarrierSnippets.counters().postWriteBarrier.getValue();
        }

        public static long getPostWriteBarrierAlignedCount() {
            return BarrierSnippets.counters().postWriteBarrierAligned.getValue();
        }

        public static long getPostWriteBarrierUnalignedCount() {
            return BarrierSnippets.counters().postWriteBarrierUnaligned.getValue();
        }
    }

    private class PostWriteBarrierLowering
    implements NodeLoweringProvider<WriteBarrier> {
        private final SnippetTemplate.SnippetInfo postWriteBarrierSnippet;

        private PostWriteBarrierLowering() {
            this.postWriteBarrierSnippet = BarrierSnippets.this.snippet(BarrierSnippets.class, "postWriteBarrierSnippet", new LocationIdentity[]{CARD_REMEMBERED_SET_LOCATION});
        }

        @Override
        public void lower(WriteBarrier barrier, LoweringTool tool) {
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.postWriteBarrierSnippet, barrier.graph().getGuardsStage(), tool.getLoweringStage());
            OffsetAddressNode address = (OffsetAddressNode)barrier.getAddress();
            ResolvedJavaType baseType = StampTool.typeOrNull((ValueNode)address.getBase());
            boolean alwaysAlignedChunk = baseType != null && !baseType.isArray() && !baseType.isJavaLangObject() && !baseType.isInterface();
            args.add("object", (Object)address.getBase());
            args.addConst("alwaysAlignedChunk", (Object)alwaysAlignedChunk);
            args.addConst("verifyOnly", (Object)this.getVerifyOnly(barrier));
            BarrierSnippets.this.template((ValueNode)barrier, args).instantiate(BarrierSnippets.this.providers.getMetaAccess(), (FixedNode)barrier, SnippetTemplate.DEFAULT_REPLACER, args);
        }

        private boolean getVerifyOnly(WriteBarrier barrier) {
            if (barrier instanceof SerialWriteBarrier) {
                return ((SerialWriteBarrier)barrier).getVerifyOnly();
            }
            return false;
        }
    }

    public static class Options {
        @Option(help={"Instrument write barriers with counters"})
        public static final HostedOptionKey<Boolean> CountWriteBarriers = new HostedOptionKey<Boolean>(false);
        @Option(help={"Verify write barriers"})
        public static final HostedOptionKey<Boolean> VerifyWriteBarriers = new HostedOptionKey<Boolean>(false);
    }
}

