/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.ReferenceMapIndex;
import com.oracle.svm.core.heap.StoredContinuationImpl;
import com.oracle.svm.core.thread.JavaContinuations;
import com.oracle.svm.core.util.NonmovableByteArrayReader;
import com.oracle.svm.core.util.TypedMemoryReader;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class InstanceReferenceMapDecoder {
    @AlwaysInline(value="de-virtualize calls to ObjectReferenceVisitor")
    public static boolean walkOffsetsFromPointer(Pointer baseAddress, NonmovableArray<Byte> referenceMapEncoding, long referenceMapIndex, ObjectReferenceVisitor visitor, Object holderObject) {
        assert (ReferenceMapIndex.denotesValidReferenceMap(referenceMapIndex));
        assert (referenceMapEncoding.isNonNull());
        if (JavaContinuations.useLoom() && referenceMapIndex == -2L) {
            return StoredContinuationImpl.walkStoredContinuationFromPointer(baseAddress, visitor, holderObject);
        }
        Pointer position = NonmovableByteArrayReader.pointerTo(referenceMapEncoding, referenceMapIndex);
        int entryCount = TypedMemoryReader.getS4(position);
        position = position.add(4);
        int referenceSize = ConfigurationValues.getObjectLayout().getReferenceSize();
        boolean compressed = ReferenceAccess.singleton().haveCompressedReferences();
        assert (entryCount >= 0);
        UnsignedWord sizeOfEntries = WordFactory.unsigned((int)8).multiply(entryCount);
        Pointer end = position.add(sizeOfEntries);
        while (position.belowThan((UnsignedWord)end)) {
            int offset = TypedMemoryReader.getS4(position);
            position = position.add(4);
            long count = TypedMemoryReader.getU4(position);
            position = position.add(4);
            Pointer objRef = baseAddress.add(offset);
            int c = 0;
            while ((long)c < count) {
                boolean visitResult = visitor.visitObjectReferenceInline(objRef, 0, compressed, holderObject);
                if (!visitResult) {
                    return false;
                }
                objRef = objRef.add(referenceSize);
                ++c;
            }
        }
        return true;
    }
}

