/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.annotate.AutomaticFeature;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class Log4ShellFeature
implements Feature {
    private static final String log4jClassName = "org.apache.logging.log4j.Logger";
    private static final String log4jVulnerableErrorMessage = "Warning: A vulnerable version of log4j has been detected. Please update to log4j version 2.17.1 or later.\nVulnerable Method(s):";
    private static final String log4jUnknownVersion = "Warning: The log4j library has been detected, but the version is unavailable. Due to Log4Shell, please ensure log4j is at version 2.17.1 or later.";
    private static final String[] targetMethodNames = new String[]{"debug", "error", "fatal", "info", "log", "trace", "warn"};

    private static void warn(String warning) {
        System.err.println(warning);
    }

    private static Optional<String> getPomVersion(Class<?> log4jClass) {
        ProtectionDomain pd = log4jClass.getProtectionDomain();
        CodeSource cs = pd.getCodeSource();
        if (cs == null) {
            return Optional.empty();
        }
        URL location = cs.getLocation();
        if (location == null) {
            return Optional.empty();
        }
        try {
            ClassLoader nullClassLoader = null;
            FileSystem jarFileSystem = FileSystems.newFileSystem(Paths.get(location.toURI()), nullClassLoader);
            Stream<Path> files = Files.walk(jarFileSystem.getPath("/META-INF", new String[0]), new FileVisitOption[0]);
            return files.filter(file -> file.endsWith("pom.properties")).map(file -> {
                Properties properties = new Properties();
                try {
                    InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);
                    if (inputStream != null) {
                        properties.load(inputStream);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return properties;
            }).filter(properties -> {
                String groupId = properties.getProperty("groupId");
                if (groupId == null) {
                    return false;
                }
                String artifactId = properties.getProperty("artifactId");
                if (artifactId == null) {
                    return false;
                }
                return groupId.equals("org.apache.logging.log4j") && artifactId.equals("log4j-core");
            }).map(properties -> properties.getProperty("version")).findFirst();
        }
        catch (IOException iOException) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return Optional.empty();
    }

    private static boolean vulnerableLog4jOne(String[] components) {
        String minor = components[1];
        return minor.equals("2");
    }

    private static boolean vulnerableLog4jTwo(String[] components) {
        String minor = components[1];
        if (minor.charAt(0) == '0') {
            return true;
        }
        try {
            int minorVersion = Integer.valueOf(minor);
            if (minorVersion <= 16) {
                return true;
            }
            if (components.length == 3) {
                int patchVersion = Integer.valueOf(components[2]);
                if (minorVersion == 17 && patchVersion == 0) {
                    return true;
                }
            }
        }
        catch (NumberFormatException ex) {
            Log4ShellFeature.warn(log4jUnknownVersion);
        }
        return false;
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        try {
            Optional<String> pomVersion;
            Class log4jClass = access.findClassByName(log4jClassName);
            if (log4jClass == null) {
                return;
            }
            Package log4jPackage = log4jClass.getPackage();
            String version = log4jPackage.getImplementationVersion();
            if (version == null && (pomVersion = Log4ShellFeature.getPomVersion(log4jClass)).isPresent()) {
                version = pomVersion.get();
            }
            if (version == null) {
                Log4ShellFeature.warn(log4jUnknownVersion);
                return;
            }
            String[] components = version.split("\\.");
            if (components.length < 2) {
                Log4ShellFeature.warn(log4jUnknownVersion);
                return;
            }
            HashSet<String> vulnerableMethods = new HashSet<String>();
            if (components[0].equals("1") && Log4ShellFeature.vulnerableLog4jOne(components) || components[0].equals("2") && Log4ShellFeature.vulnerableLog4jTwo(components)) {
                HashSet<String> targetMethods = new HashSet<String>(Arrays.asList(targetMethodNames));
                for (Method method : log4jClass.getMethods()) {
                    String methodName = method.getName();
                    if (!targetMethods.contains(methodName) || !access.isReachable((Executable)method) && access.reachableMethodOverrides((Executable)method).size() <= 0) continue;
                    vulnerableMethods.add(method.getDeclaringClass().getName() + "." + method.getName());
                }
            }
            if (vulnerableMethods.size() == 0) {
                return;
            }
            String renderedErrorMessage = log4jVulnerableErrorMessage;
            for (String method : vulnerableMethods) {
                renderedErrorMessage = renderedErrorMessage + "\n" + method;
            }
            Log4ShellFeature.warn(renderedErrorMessage);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

