/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.code.FactoryMethodHolder;
import com.oracle.svm.hosted.code.FactoryMethod;
import com.oracle.svm.hosted.code.SimpleSignature;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.AbstractNewObjectNode;
import org.graalvm.compiler.nodes.java.NewInstanceNode;
import org.graalvm.nativeimage.ImageSingletons;

public class FactoryMethodSupport {
    private final Map<AnalysisMethod, FactoryMethod> factoryMethods = new ConcurrentHashMap<AnalysisMethod, FactoryMethod>();

    public static FactoryMethodSupport singleton() {
        return (FactoryMethodSupport)ImageSingletons.lookup(FactoryMethodSupport.class);
    }

    public ResolvedJavaMethod lookup(UniverseMetaAccess metaAccess, ResolvedJavaMethod constructor) {
        AnalysisMetaAccess aMetaAccess;
        HostedUniverse hUniverse;
        if (metaAccess instanceof HostedMetaAccess) {
            hUniverse = (HostedUniverse)metaAccess.getUniverse();
            aMetaAccess = (AnalysisMetaAccess)metaAccess.getWrapped();
        } else {
            hUniverse = null;
            aMetaAccess = (AnalysisMetaAccess)metaAccess;
        }
        AnalysisUniverse aUniverse = (AnalysisUniverse)aMetaAccess.getUniverse();
        MetaAccessProvider unwrappedMetaAccess = aMetaAccess.getWrapped();
        AnalysisMethod aConstructor = constructor instanceof HostedMethod ? ((HostedMethod)constructor).getWrapped() : (AnalysisMethod)constructor;
        FactoryMethod factoryMethod = this.factoryMethods.computeIfAbsent(aConstructor, key -> {
            ResolvedJavaMethod unwrappedConstructor = aConstructor.getWrapped();
            ResolvedJavaType declaringClass = unwrappedMetaAccess.lookupJavaType(FactoryMethodHolder.class);
            SimpleSignature signature = new SimpleSignature(unwrappedConstructor.toParameterTypes(), (JavaType)unwrappedConstructor.getDeclaringClass());
            ConstantPool constantPool = unwrappedConstructor.getConstantPool();
            return new FactoryMethod(unwrappedConstructor, declaringClass, (Signature)signature, constantPool);
        });
        AnalysisMethod aFactoryMethod = aUniverse.lookup((JavaMethod)factoryMethod);
        if (hUniverse != null) {
            return hUniverse.lookup((JavaMethod)aFactoryMethod);
        }
        return aFactoryMethod;
    }

    protected boolean inlineConstructor(ResolvedJavaMethod constructor) {
        return false;
    }

    protected AbstractNewObjectNode createNewInstance(HostedGraphKit kit, ResolvedJavaType type, boolean fillContents) {
        return (AbstractNewObjectNode)kit.append((ValueNode)new NewInstanceNode(type, fillContents));
    }
}

