/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni.access;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.util.ImageHeapMap;
import com.oracle.svm.jni.access.JNIAccessibleClass;
import com.oracle.svm.jni.access.JNIAccessibleField;
import com.oracle.svm.jni.access.JNIAccessibleMethod;
import com.oracle.svm.jni.access.JNIAccessibleMethodDescriptor;
import com.oracle.svm.jni.access.JNINativeLinkage;
import com.oracle.svm.jni.nativeapi.JNIFieldId;
import com.oracle.svm.jni.nativeapi.JNIMethodId;
import java.io.PrintStream;
import java.util.Map;
import java.util.function.Function;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class JNIReflectionDictionary {
    private final EconomicMap<String, JNIAccessibleClass> classesByName = ImageHeapMap.create();
    private final EconomicMap<Class<?>, JNIAccessibleClass> classesByClassObject = ImageHeapMap.create();
    private final EconomicMap<JNINativeLinkage, JNINativeLinkage> nativeLinkages = ImageHeapMap.create();

    static void initialize() {
        ImageSingletons.add(JNIReflectionDictionary.class, (Object)new JNIReflectionDictionary());
    }

    public static JNIReflectionDictionary singleton() {
        return (JNIReflectionDictionary)ImageSingletons.lookup(JNIReflectionDictionary.class);
    }

    private JNIReflectionDictionary() {
    }

    private void dump(boolean condition, String label) {
        if (SubstrateOptions.JNIVerboseLookupErrors.getValue().booleanValue() && condition) {
            PrintStream ps = Log.logStream();
            ps.println(label);
            ps.println(" classesByName:");
            MapCursor nameCursor = this.classesByName.getEntries();
            while (nameCursor.advance()) {
                ps.print("  ");
                ps.println((String)nameCursor.getKey());
                JNIAccessibleClass clazz = (JNIAccessibleClass)nameCursor.getValue();
                ps.println("   methods:");
                MapCursor<JNIAccessibleMethodDescriptor, JNIAccessibleMethod> methodsCursor = clazz.getMethodsByDescriptor();
                while (methodsCursor.advance()) {
                    ps.print("      ");
                    ps.println(((JNIAccessibleMethodDescriptor)methodsCursor.getKey()).getNameAndSignature());
                }
                ps.println("   fields:");
                MapCursor<String, JNIAccessibleField> fieldsCursor = clazz.getFieldsByName();
                while (fieldsCursor.advance()) {
                    ps.print("      ");
                    ps.println((String)fieldsCursor.getKey());
                }
            }
            ps.println(" classesByClassObject:");
            MapCursor cursor = this.classesByClassObject.getEntries();
            while (cursor.advance()) {
                ps.print("  ");
                ps.println(cursor.getKey());
            }
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    JNIAccessibleClass addClassIfAbsent(Class<?> classObj, Function<Class<?>, JNIAccessibleClass> mappingFunction) {
        if (!this.classesByClassObject.containsKey(classObj)) {
            JNIAccessibleClass instance = mappingFunction.apply(classObj);
            this.classesByClassObject.put(classObj, (Object)instance);
            this.classesByName.put((Object)instance.getInternalName(), (Object)instance);
        }
        return (JNIAccessibleClass)this.classesByClassObject.get(classObj);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    void addLinkages(Map<JNINativeLinkage, JNINativeLinkage> linkages) {
        this.nativeLinkages.putAll(EconomicMap.wrapMap(linkages));
    }

    public Iterable<JNIAccessibleClass> getClasses() {
        return this.classesByClassObject.getValues();
    }

    public Class<?> getClassObjectByName(String name) {
        JNIAccessibleClass clazz = (JNIAccessibleClass)this.classesByName.get((Object)name);
        this.dump(clazz == null, "getClassObjectByName");
        return clazz != null ? clazz.getClassObject() : null;
    }

    public JNINativeLinkage getLinkage(String declaringClass, String name, String descriptor) {
        JNINativeLinkage key = new JNINativeLinkage(declaringClass, name, descriptor);
        return (JNINativeLinkage)this.nativeLinkages.get((Object)key);
    }

    public void unsetEntryPoints(String declaringClass) {
        for (JNINativeLinkage linkage : this.nativeLinkages.getKeys()) {
            if (!declaringClass.equals(linkage.getDeclaringClassName())) continue;
            linkage.unsetEntryPoint();
        }
    }

    private JNIAccessibleMethod findMethod(Class<?> clazz, JNIAccessibleMethodDescriptor descriptor, String dumpLabel) {
        JNIAccessibleMethod method = this.getDeclaredMethod(clazz, descriptor, dumpLabel);
        if (descriptor.isConstructor() || descriptor.isClassInitializer()) {
            return method;
        }
        if (method == null && clazz.getSuperclass() != null) {
            method = this.findMethod(clazz.getSuperclass(), descriptor, null);
        }
        if (method == null) {
            method = this.findSuperinterfaceMethod(clazz, descriptor);
        }
        return method;
    }

    private JNIAccessibleMethod findSuperinterfaceMethod(Class<?> clazz, JNIAccessibleMethodDescriptor descriptor) {
        for (Class<?> parent : clazz.getInterfaces()) {
            JNIAccessibleMethod method = this.getDeclaredMethod(parent, descriptor, null);
            if (method == null) {
                method = this.findSuperinterfaceMethod(parent, descriptor);
            }
            if (method == null || !method.isPublic() || method.isStatic()) continue;
            return method;
        }
        return null;
    }

    public JNIMethodId getDeclaredMethodID(Class<?> classObject, JNIAccessibleMethodDescriptor descriptor, boolean isStatic) {
        JNIAccessibleMethod method = this.getDeclaredMethod(classObject, descriptor, "getDeclaredMethodID");
        boolean match = method != null && method.isStatic() == isStatic;
        return JNIReflectionDictionary.toMethodID(match ? method : null);
    }

    private JNIAccessibleMethod getDeclaredMethod(Class<?> classObject, JNIAccessibleMethodDescriptor descriptor, String dumpLabel) {
        JNIAccessibleClass clazz = (JNIAccessibleClass)this.classesByClassObject.get(classObject);
        this.dump(clazz == null && dumpLabel != null, dumpLabel);
        JNIAccessibleMethod method = null;
        if (clazz != null) {
            method = clazz.getMethod(descriptor);
        }
        return method;
    }

    public JNIMethodId getMethodID(Class<?> classObject, String name, String signature, boolean isStatic) {
        JNIAccessibleMethod method = this.findMethod(classObject, new JNIAccessibleMethodDescriptor(name, signature), "getMethodID");
        boolean match = method != null && method.isStatic() == isStatic && method.isDiscoverableIn(classObject);
        return JNIReflectionDictionary.toMethodID(match ? method : null);
    }

    private static JNIMethodId toMethodID(JNIAccessibleMethod method) {
        SignedWord value = (SignedWord)WordFactory.zero();
        if (method != null) {
            value = Word.objectToUntrackedPointer((Object)method);
            if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
                value = value.subtract((SignedWord)Isolates.getHeapBase(CurrentIsolate.getIsolate()));
            }
        }
        return (JNIMethodId)value;
    }

    public static JNIAccessibleMethod getMethodByID(JNIMethodId method) {
        Object obj = null;
        if (method.notEqual((ComparableWord)WordFactory.zero())) {
            Pointer p = (Pointer)method;
            if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
                p = p.add((UnsignedWord)Isolates.getHeapBase(CurrentIsolate.getIsolate()));
            }
            obj = p.toObject();
        }
        return (JNIAccessibleMethod)obj;
    }

    private JNIAccessibleField getDeclaredField(Class<?> classObject, String name, boolean isStatic, String dumpLabel) {
        JNIAccessibleField field;
        JNIAccessibleClass clazz = (JNIAccessibleClass)this.classesByClassObject.get(classObject);
        this.dump(clazz == null && dumpLabel != null, dumpLabel);
        if (clazz != null && (field = clazz.getField(name)) != null && field.isStatic() == isStatic) {
            return field;
        }
        return null;
    }

    public JNIFieldId getDeclaredFieldID(Class<?> classObject, String name, boolean isStatic) {
        JNIAccessibleField field = this.getDeclaredField(classObject, name, isStatic, "getDeclaredFieldID");
        return field != null ? field.getId() : (JNIFieldId)WordFactory.nullPointer();
    }

    private JNIAccessibleField findField(Class<?> clazz, String name, boolean isStatic, String dumpLabel) {
        JNIAccessibleField field = this.getDeclaredField(clazz, name, isStatic, dumpLabel);
        if (field == null && isStatic) {
            field = this.findSuperinterfaceField(clazz, name);
        }
        if (field == null && clazz.getSuperclass() != null) {
            field = this.findField(clazz.getSuperclass(), name, isStatic, null);
        }
        return field;
    }

    private JNIAccessibleField findSuperinterfaceField(Class<?> clazz, String name) {
        for (Class<?> parent : clazz.getInterfaces()) {
            JNIAccessibleField field = this.getDeclaredField(parent, name, true, null);
            if (field == null) {
                field = this.findSuperinterfaceField(parent, name);
            }
            if (field == null) continue;
            return field;
        }
        return null;
    }

    public JNIFieldId getFieldID(Class<?> clazz, String name, boolean isStatic) {
        JNIAccessibleField field = this.findField(clazz, name, isStatic, "getFieldID");
        return field != null && field.isDiscoverableIn(clazz) ? field.getId() : (JNIFieldId)WordFactory.nullPointer();
    }

    public String getFieldNameByID(Class<?> classObject, JNIFieldId id) {
        JNIAccessibleClass clazz = (JNIAccessibleClass)this.classesByClassObject.get(classObject);
        if (clazz != null) {
            MapCursor<String, JNIAccessibleField> fieldsCursor = clazz.getFieldsByName();
            while (fieldsCursor.advance()) {
                JNIAccessibleField field = (JNIAccessibleField)fieldsCursor.getValue();
                if (!id.equal((ComparableWord)field.getId())) continue;
                return (String)fieldsCursor.getKey();
            }
        }
        return null;
    }

    public static JNIAccessibleMethodDescriptor getMethodDescriptor(JNIAccessibleMethod method) {
        if (method != null) {
            JNIAccessibleClass clazz = method.getDeclaringClass();
            MapCursor<JNIAccessibleMethodDescriptor, JNIAccessibleMethod> methodsCursor = clazz.getMethodsByDescriptor();
            while (methodsCursor.advance()) {
                if (methodsCursor.getValue() != method) continue;
                return (JNIAccessibleMethodDescriptor)methodsCursor.getKey();
            }
        }
        return null;
    }
}

