/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.methodhandles;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.invoke.Target_java_lang_invoke_MemberName;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.methodhandles.MethodHandleIntrinsicImpl;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import sun.invoke.util.VerifyAccess;

final class Util_java_lang_invoke_MethodHandleNatives {
    private static Method verifyAccess;

    Util_java_lang_invoke_MethodHandleNatives() {
    }

    static Method lookupMethod(Class<?> declaringClazz, String name, Class<?>[] parameterTypes) throws NoSuchMethodException {
        return Util_java_lang_invoke_MethodHandleNatives.lookupMethod(declaringClazz, name, parameterTypes, null);
    }

    private static Method lookupMethod(Class<?> declaringClazz, String name, Class<?>[] parameterTypes, NoSuchMethodException originalException) throws NoSuchMethodException {
        try {
            return declaringClazz.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            NoSuchMethodException newOriginalException;
            Class<?> superClass = declaringClazz.getSuperclass();
            NoSuchMethodException noSuchMethodException = newOriginalException = originalException == null ? e : originalException;
            if (superClass == null) {
                throw newOriginalException;
            }
            return Util_java_lang_invoke_MethodHandleNatives.lookupMethod(superClass, name, parameterTypes, newOriginalException);
        }
    }

    static Field lookupField(Class<?> declaringClazz, String name) throws NoSuchFieldException {
        return Util_java_lang_invoke_MethodHandleNatives.lookupField(declaringClazz, name, null);
    }

    private static Field lookupField(Class<?> declaringClazz, String name, NoSuchFieldException originalException) throws NoSuchFieldException {
        try {
            return declaringClazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            NoSuchFieldException newOriginalException;
            Class<?> superClass = declaringClazz.getSuperclass();
            NoSuchFieldException noSuchFieldException = newOriginalException = originalException == null ? e : originalException;
            if (superClass == null) {
                throw newOriginalException;
            }
            return Util_java_lang_invoke_MethodHandleNatives.lookupField(superClass, name, newOriginalException);
        }
    }

    public static Target_java_lang_invoke_MemberName resolve(Target_java_lang_invoke_MemberName self, Class<?> caller, boolean speculativeResolve) throws LinkageError, ClassNotFoundException {
        if (self.reflectAccess != null) {
            return self;
        }
        Class<?> declaringClass = self.getDeclaringClass();
        if (declaringClass == null) {
            return null;
        }
        self.intrinsic = MethodHandleIntrinsicImpl.resolve(self);
        if (self.intrinsic != null) {
            self.flags |= ((MethodHandleIntrinsicImpl)self.intrinsic).variant.flags;
            return self;
        }
        try {
            if (self.isMethod()) {
                Class<?>[] parameterTypes = self.getMethodType().parameterArray();
                Method method = Util_java_lang_invoke_MethodHandleNatives.lookupMethod(declaringClass, self.name, parameterTypes);
                if (method.getReturnType() != self.getMethodType().returnType()) {
                    throw new NoSuchMethodException(SubstrateUtil.cast(declaringClass, DynamicHub.class).methodToString(self.name, parameterTypes));
                }
                self.reflectAccess = method;
                self.flags |= method.getModifiers();
            } else if (self.isConstructor()) {
                Constructor<?> constructor;
                self.reflectAccess = constructor = declaringClass.getDeclaredConstructor(self.getMethodType().parameterArray());
                self.flags |= constructor.getModifiers();
            } else if (self.isField()) {
                Field field = Util_java_lang_invoke_MethodHandleNatives.lookupField(declaringClass, self.name);
                if (field.getType() != self.getFieldType()) {
                    throw new NoSuchFieldException(declaringClass.getName() + "." + self.name);
                }
                self.reflectAccess = field;
                self.flags |= field.getModifiers();
            }
            return self;
        }
        catch (NoSuchMethodException e) {
            if (speculativeResolve) {
                return null;
            }
            throw new NoSuchMethodError(e.getMessage());
        }
        catch (NoSuchFieldException e) {
            if (speculativeResolve) {
                return null;
            }
            throw new NoSuchFieldError(e.getMessage());
        }
    }

    static boolean verifyAccess(Class<?> refc, Class<?> defc, int mods, Class<?> lookupClass, int allowedModes) {
        assert (JavaVersionUtil.JAVA_SPEC >= 17);
        if (verifyAccess == null) {
            try {
                verifyAccess = VerifyAccess.class.getDeclaredMethod("isMemberAccessible", Class.class, Class.class, Integer.TYPE, Class.class, Class.class, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                throw VMError.shouldNotReachHere();
            }
        }
        try {
            return (Boolean)verifyAccess.invoke(null, refc, defc, mods, lookupClass, null, allowedModes);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new GraalError((Throwable)e);
        }
    }
}

