/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.word.BarrieredAccess;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class JavaMemoryUtil {
    public static void copy(Object from, UnsignedWord fromOffset, Object to, UnsignedWord toOffset, UnsignedWord size) {
        if (from != to || fromOffset.aboveThan(toOffset)) {
            JavaMemoryUtil.copyForward(from, fromOffset, to, toOffset, size);
        } else if (fromOffset.notEqual(toOffset)) {
            JavaMemoryUtil.copyBackward(from, fromOffset, to, toOffset, size);
        }
    }

    @Uninterruptible(reason="Objects must not move")
    public static void copyForward(Object from, UnsignedWord fromOffset, Object to, UnsignedWord toOffset, UnsignedWord size) {
        Word fromPtr = Word.objectToUntrackedPointer((Object)from).add(fromOffset);
        Word toPtr = Word.objectToUntrackedPointer((Object)to).add(toOffset);
        JavaMemoryUtil.copyForward((Pointer)fromPtr, (Pointer)toPtr, size);
    }

    @Uninterruptible(reason="Objects must not move")
    public static void copyBackward(Object from, UnsignedWord fromOffset, Object to, UnsignedWord toOffset, UnsignedWord size) {
        Word fromPtr = Word.objectToUntrackedPointer((Object)from).add(fromOffset);
        Word toPtr = Word.objectToUntrackedPointer((Object)to).add(toOffset);
        JavaMemoryUtil.copyBackward((Pointer)fromPtr, (Pointer)toPtr, size);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void copy(Pointer from, Pointer to, UnsignedWord size) {
        if (from.aboveThan((UnsignedWord)to)) {
            JavaMemoryUtil.copyForward(from, to, size);
        } else if (from.belowThan((UnsignedWord)to)) {
            JavaMemoryUtil.copyBackward(from, to, size);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void copyForward(Pointer from, Pointer to, UnsignedWord size) {
        UnsignedWord diffBits = from.xor((UnsignedWord)to);
        UnsignedWord alignBits = diffBits.not().and(diffBits.subtract(1)).and(7);
        UnsignedWord alignment = alignBits.add(1);
        if (alignment.equal(1)) {
            UnsignedWord offset = (UnsignedWord)WordFactory.zero();
            while (offset.belowThan(size)) {
                to.writeByte((WordBase)offset, from.readByte((WordBase)offset));
                offset = offset.add(1);
            }
            return;
        }
        Pointer lowerSize = from.add(alignBits).and(alignBits.not()).subtract((UnsignedWord)from).and(alignBits);
        if (size.belowThan((UnsignedWord)lowerSize)) {
            lowerSize = size.and((UnsignedWord)lowerSize);
        }
        JavaMemoryUtil.copyUnalignedLower(from, to, (UnsignedWord)lowerSize);
        Pointer offset = lowerSize;
        UnsignedWord alignedSize = size.subtract((UnsignedWord)lowerSize).and(alignBits.not());
        if (alignment.equal(8)) {
            UnmanagedMemoryUtil.copyLongsForward(from.add((UnsignedWord)offset), to.add((UnsignedWord)offset), alignedSize);
            offset = offset.add(alignedSize);
        } else {
            UnsignedWord alignedEndOffset = offset.add(alignedSize);
            if (alignment.equal(4)) {
                while (offset.belowThan(alignedEndOffset)) {
                    to.writeInt((WordBase)offset, from.readInt((WordBase)offset));
                    offset = offset.add(4);
                }
            } else {
                assert (alignment.equal(2));
                while (offset.belowThan(alignedEndOffset)) {
                    to.writeShort((WordBase)offset, from.readShort((WordBase)offset));
                    offset = offset.add(2);
                }
            }
        }
        UnsignedWord upperSize = size.subtract((UnsignedWord)offset);
        JavaMemoryUtil.copyUnalignedUpper(from.add((UnsignedWord)offset), to.add((UnsignedWord)offset), upperSize);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void copyUnalignedLower(Pointer from, Pointer to, UnsignedWord length) {
        UnsignedWord offset = (UnsignedWord)WordFactory.zero();
        if (length.and(1).notEqual(0)) {
            to.writeByte((WordBase)offset, from.readByte((WordBase)offset));
            offset = offset.add(1);
        }
        if (length.and(2).notEqual(0)) {
            to.writeShort((WordBase)offset, from.readShort((WordBase)offset));
            offset = offset.add(2);
        }
        if (length.and(4).notEqual(0)) {
            to.writeInt((WordBase)offset, from.readInt((WordBase)offset));
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void copyUnalignedUpper(Pointer from, Pointer to, UnsignedWord length) {
        UnsignedWord offset = (UnsignedWord)WordFactory.zero();
        if (length.and(4).notEqual(0)) {
            to.writeInt((WordBase)offset, from.readInt((WordBase)offset));
            offset = offset.add(4);
        }
        if (length.and(2).notEqual(0)) {
            to.writeShort((WordBase)offset, from.readShort((WordBase)offset));
            offset = offset.add(2);
        }
        if (length.and(1).notEqual(0)) {
            to.writeByte((WordBase)offset, from.readByte((WordBase)offset));
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void copyBackward(Pointer from, Pointer to, UnsignedWord size) {
        UnsignedWord diffBits = from.xor((UnsignedWord)to);
        UnsignedWord alignBits = diffBits.not().and(diffBits.subtract(1)).and(7);
        UnsignedWord alignment = alignBits.add(1);
        if (alignment.equal(1)) {
            UnsignedWord offset = size;
            while (offset.aboveThan(0)) {
                offset = offset.subtract(1);
                to.writeByte((WordBase)offset, from.readByte((WordBase)offset));
            }
            return;
        }
        Pointer upperSize = from.add(size).and(alignBits);
        if (size.belowThan((UnsignedWord)upperSize)) {
            upperSize = size.and((UnsignedWord)upperSize);
        }
        UnsignedWord offset = size.subtract((UnsignedWord)upperSize);
        JavaMemoryUtil.copyUnalignedUpper(from.add(offset), to.add(offset), (UnsignedWord)upperSize);
        UnsignedWord alignedSize = offset.and(alignBits.not());
        if (alignment.equal(8)) {
            offset = offset.subtract(alignedSize);
            UnmanagedMemoryUtil.copyLongsBackward(from.add(offset), to.add(offset), alignedSize);
        } else if (alignment.equal(4)) {
            while (offset.aboveOrEqual(4)) {
                offset = offset.subtract(4);
                to.writeInt((WordBase)offset, from.readInt((WordBase)offset));
            }
        } else {
            assert (alignment.equal(2));
            while (offset.aboveOrEqual(2)) {
                offset = offset.subtract(2);
                to.writeShort((WordBase)offset, from.readShort((WordBase)offset));
            }
        }
        JavaMemoryUtil.copyUnalignedLower(from, to, offset);
    }

    public static void unsafeCopyMemory(Object srcBase, long srcOffset, Object destBase, long destOffset, long bytes) {
        if (srcBase != null || destBase != null) {
            JavaMemoryUtil.copyOnHeap(srcBase, WordFactory.unsigned((long)srcOffset), destBase, WordFactory.unsigned((long)destOffset), WordFactory.unsigned((long)bytes));
        } else {
            UnmanagedMemoryUtil.copy((Pointer)WordFactory.pointer((long)srcOffset), (Pointer)WordFactory.pointer((long)destOffset), WordFactory.unsigned((long)bytes));
        }
    }

    @Uninterruptible(reason="Memory is on the heap, copying must not be interrupted.")
    private static void copyOnHeap(Object srcBase, UnsignedWord srcOffset, Object destBase, UnsignedWord destOffset, UnsignedWord size) {
        Word fromPtr = Word.objectToUntrackedPointer((Object)srcBase).add(srcOffset);
        Word toPtr = Word.objectToUntrackedPointer((Object)destBase).add(destOffset);
        UnmanagedMemoryUtil.copy((Pointer)fromPtr, (Pointer)toPtr, size);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void fill(Pointer to, UnsignedWord size, byte value) {
        long v = (long)value & 0xFFL;
        v = v << 8 | v;
        v = v << 16 | v;
        v = v << 32 | v;
        UnsignedWord alignMask = WordFactory.unsigned((int)7);
        UnsignedWord lowerSize = WordFactory.unsigned((int)8).subtract((UnsignedWord)to).and(alignMask);
        if (lowerSize.aboveThan(0)) {
            if (size.belowThan(lowerSize)) {
                lowerSize = size.and(lowerSize);
            }
            JavaMemoryUtil.fillUnalignedLower(to, v, lowerSize);
        }
        UnsignedWord offset = lowerSize;
        UnsignedWord alignedSize = size.subtract(offset).and(alignMask.not());
        UnmanagedMemoryUtil.fillLongs(to.add(offset), alignedSize, v);
        offset = offset.add(alignedSize);
        UnsignedWord upperSize = size.subtract(offset);
        if (upperSize.aboveThan(0)) {
            JavaMemoryUtil.fillUnalignedUpper(to.add(offset), v, upperSize);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void fillUnalignedLower(Pointer to, long value, UnsignedWord length) {
        UnsignedWord offset = (UnsignedWord)WordFactory.zero();
        if (length.and(1).notEqual(0)) {
            to.writeByte((WordBase)offset, (byte)value);
            offset = offset.add(1);
        }
        if (length.and(2).notEqual(0)) {
            to.writeShort((WordBase)offset, (short)value);
            offset = offset.add(2);
        }
        if (length.and(4).notEqual(0)) {
            to.writeInt((WordBase)offset, (int)value);
            offset = offset.add(4);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void fillUnalignedUpper(Pointer to, long value, UnsignedWord upperSize) {
        UnsignedWord offset = (UnsignedWord)WordFactory.zero();
        if (upperSize.and(4).notEqual(0)) {
            to.writeInt((WordBase)offset, (int)value);
            offset = offset.add(4);
        }
        if (upperSize.and(2).notEqual(0)) {
            to.writeShort((WordBase)offset, (short)value);
            offset = offset.add(2);
        }
        if (upperSize.and(1).notEqual(0)) {
            to.writeByte((WordBase)offset, (byte)value);
            offset = offset.add(1);
        }
    }

    public static void unsafeSetMemory(Object destBase, long destOffset, long bytes, byte bvalue) {
        if (destBase != null) {
            JavaMemoryUtil.fillOnHeap(destBase, destOffset, bytes, bvalue);
        } else {
            JavaMemoryUtil.fill((Pointer)WordFactory.pointer((long)destOffset), WordFactory.unsigned((long)bytes), bvalue);
        }
    }

    @Uninterruptible(reason="Accessed memory is on the heap, code must not be interrupted.")
    private static void fillOnHeap(Object destBase, long destOffset, long bytes, byte bvalue) {
        Word fromPtr = Word.objectToUntrackedPointer((Object)destBase).add((Word)WordFactory.unsigned((long)destOffset));
        JavaMemoryUtil.fill((Pointer)fromPtr, WordFactory.unsigned((long)bytes), bvalue);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void copySwap(Pointer from, Pointer to, UnsignedWord size, UnsignedWord elementSize) {
        assert (from.isNonNull()) : "address must not be NULL";
        assert (to.isNonNull()) : "address must not be NULL";
        assert (size.unsignedRemainder(elementSize).equal(0)) : "byte count must be multiple of element size";
        if (elementSize.equal(2)) {
            JavaMemoryUtil.copySwap2(from, to, size);
        } else if (elementSize.equal(4)) {
            JavaMemoryUtil.copySwap4(from, to, size);
        } else if (elementSize.equal(8)) {
            JavaMemoryUtil.copySwap8(from, to, size);
        } else {
            throw VMError.shouldNotReachHere("incorrect element size");
        }
    }

    @Uninterruptible(reason="Accessed memory is on the heap, code must not be interrupted.")
    private static void copySwapOnHeap(Object srcBase, long srcOffset, Object destBase, long destOffset, long bytes, long elemSize) {
        Word fromPtr = Word.objectToUntrackedPointer((Object)srcBase).add((Word)WordFactory.unsigned((long)srcOffset));
        Word toPtr = Word.objectToUntrackedPointer((Object)destBase).add((Word)WordFactory.unsigned((long)destOffset));
        JavaMemoryUtil.copySwap((Pointer)fromPtr, (Pointer)toPtr, WordFactory.unsigned((long)bytes), WordFactory.unsigned((long)elemSize));
    }

    public static void unsafeCopySwapMemory(Object srcBase, long srcOffset, Object destBase, long destOffset, long bytes, long elemSize) {
        if (srcBase != null || destBase != null) {
            JavaMemoryUtil.copySwapOnHeap(srcBase, srcOffset, destBase, destOffset, bytes, elemSize);
        } else {
            JavaMemoryUtil.copySwap((Pointer)WordFactory.unsigned((long)srcOffset), (Pointer)WordFactory.unsigned((long)destOffset), WordFactory.unsigned((long)bytes), WordFactory.unsigned((long)elemSize));
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void copySwap2(Pointer from, Pointer to, UnsignedWord size) {
        block3: {
            block2: {
                if (!from.aboveThan((UnsignedWord)to)) break block2;
                UnsignedWord offset = (UnsignedWord)WordFactory.zero();
                while (offset.belowThan(size)) {
                    to.writeShort((WordBase)offset, Short.reverseBytes(from.readShort((WordBase)offset)));
                    offset = offset.add(2);
                }
                break block3;
            }
            if (!from.belowThan((UnsignedWord)to)) break block3;
            UnsignedWord offset = size;
            while (offset.aboveThan(0)) {
                to.writeShort((WordBase)offset.subtract(2), Short.reverseBytes(from.readShort((WordBase)offset.subtract(2))));
                offset = offset.subtract(2);
            }
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void copySwap4(Pointer from, Pointer to, UnsignedWord size) {
        block3: {
            block2: {
                if (!from.aboveThan((UnsignedWord)to)) break block2;
                UnsignedWord offset = (UnsignedWord)WordFactory.zero();
                while (offset.belowThan(size)) {
                    to.writeInt((WordBase)offset, Integer.reverseBytes(from.readInt((WordBase)offset)));
                    offset = offset.add(4);
                }
                break block3;
            }
            if (!from.belowThan((UnsignedWord)to)) break block3;
            UnsignedWord offset = size;
            while (offset.aboveThan(0)) {
                to.writeInt((WordBase)offset.subtract(4), Integer.reverseBytes(from.readInt((WordBase)offset.subtract(4))));
                offset = offset.subtract(4);
            }
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void copySwap8(Pointer from, Pointer to, UnsignedWord size) {
        block3: {
            block2: {
                if (!from.aboveThan((UnsignedWord)to)) break block2;
                UnsignedWord offset = (UnsignedWord)WordFactory.zero();
                while (offset.belowThan(size)) {
                    to.writeLong((WordBase)offset, Long.reverseBytes(from.readLong((WordBase)offset)));
                    offset = offset.add(8);
                }
                break block3;
            }
            if (!from.belowThan((UnsignedWord)to)) break block3;
            UnsignedWord offset = size;
            while (offset.aboveThan(0)) {
                to.writeLong((WordBase)offset.subtract(8), Long.reverseBytes(from.readLong((WordBase)offset.subtract(8))));
                offset = offset.subtract(8);
            }
        }
    }

    public static void copyObjectArrayForward(Object fromArray, int fromIndex, Object toArray, int toIndex, int length, int layoutEncoding) {
        assert (length >= 0);
        UnsignedWord fromOffset = LayoutEncoding.getArrayElementOffset(layoutEncoding, fromIndex);
        UnsignedWord toOffset = LayoutEncoding.getArrayElementOffset(layoutEncoding, toIndex);
        UnsignedWord count = WordFactory.unsigned((int)length);
        JavaMemoryUtil.copyReferencesForward(fromArray, fromOffset, toArray, toOffset, count);
    }

    public static void copyObjectArrayBackward(Object fromArray, int fromIndex, Object toArray, int toIndex, int length, int layoutEncoding) {
        assert (length >= 0);
        UnsignedWord fromOffset = LayoutEncoding.getArrayElementOffset(layoutEncoding, fromIndex);
        UnsignedWord toOffset = LayoutEncoding.getArrayElementOffset(layoutEncoding, toIndex);
        UnsignedWord count = WordFactory.unsigned((int)length);
        JavaMemoryUtil.copyReferencesBackward(fromArray, fromOffset, toArray, toOffset, count);
    }

    public static void copyReferencesForward(Object from, UnsignedWord fromOffset, Object to, UnsignedWord toOffset, UnsignedWord length) {
        int elementSize = ConfigurationValues.getObjectLayout().getReferenceSize();
        UnsignedWord size = length.multiply(elementSize);
        UnsignedWord copied = (UnsignedWord)WordFactory.zero();
        while (copied.belowThan(size)) {
            BarrieredAccess.writeObject((Object)to, (WordBase)toOffset.add(copied), (Object)BarrieredAccess.readObject((Object)from, (WordBase)fromOffset.add(copied)));
            copied = copied.add(elementSize);
        }
    }

    public static void copyReferencesBackward(Object from, UnsignedWord fromOffset, Object to, UnsignedWord toOffset, UnsignedWord length) {
        int elementSize = ConfigurationValues.getObjectLayout().getReferenceSize();
        UnsignedWord remaining = length.multiply(elementSize);
        while (remaining.aboveThan(0)) {
            remaining = remaining.subtract(elementSize);
            BarrieredAccess.writeObject((Object)to, (WordBase)toOffset.add(remaining), (Object)BarrieredAccess.readObject((Object)from, (WordBase)fromOffset.add(remaining)));
        }
    }

    public static void copyObjectArrayForwardWithStoreCheck(Object fromArray, int fromIndex, Object toArray, int toIndex, int length) {
        Object[] from = (Object[])fromArray;
        Object[] to = (Object[])toArray;
        for (int i = 0; i < length; ++i) {
            to[toIndex + i] = from[fromIndex + i];
        }
    }

    public static void copyPrimitiveArrayForward(Object fromArray, int fromIndex, Object toArray, int toIndex, int length, int layoutEncoding) {
        assert (length >= 0);
        assert (fromArray != null);
        assert (toArray != null);
        UnsignedWord fromOffset = LayoutEncoding.getArrayElementOffset(layoutEncoding, fromIndex);
        UnsignedWord toOffset = LayoutEncoding.getArrayElementOffset(layoutEncoding, toIndex);
        UnsignedWord elementSize = WordFactory.unsigned((int)LayoutEncoding.getArrayIndexScale(layoutEncoding));
        UnsignedWord size = elementSize.multiply(length);
        JavaMemoryUtil.copyPrimitiveArrayForward(fromArray, fromOffset, toArray, toOffset, size);
    }

    @Uninterruptible(reason="Arrays must not move")
    private static void copyPrimitiveArrayForward(Object fromArray, UnsignedWord fromOffset, Object toArray, UnsignedWord toOffset, UnsignedWord size) {
        Word fromPtr = Word.objectToUntrackedPointer((Object)fromArray).add(fromOffset);
        Word toPtr = Word.objectToUntrackedPointer((Object)toArray).add(toOffset);
        JavaMemoryUtil.copyPrimitiveArrayForward((Pointer)fromPtr, (Pointer)toPtr, size);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void copyPrimitiveArrayForward(Pointer fromPtr, Pointer toPtr, UnsignedWord size) {
        UnmanagedMemoryUtil.copyForward(fromPtr, toPtr, size);
    }

    public static void copyPrimitiveArrayBackward(Object fromArray, int fromIndex, Object toArray, int toIndex, int length, int layoutEncoding) {
        assert (length >= 0);
        assert (fromArray != null);
        assert (toArray != null);
        UnsignedWord fromOffset = LayoutEncoding.getArrayElementOffset(layoutEncoding, fromIndex);
        UnsignedWord toOffset = LayoutEncoding.getArrayElementOffset(layoutEncoding, toIndex);
        UnsignedWord elementSize = WordFactory.unsigned((int)LayoutEncoding.getArrayIndexScale(layoutEncoding));
        UnsignedWord size = elementSize.multiply(length);
        JavaMemoryUtil.copyPrimitiveArrayBackward(fromArray, fromOffset, toArray, toOffset, size);
    }

    @Uninterruptible(reason="Arrays must not move")
    private static void copyPrimitiveArrayBackward(Object fromArray, UnsignedWord fromOffset, Object toArray, UnsignedWord toOffset, UnsignedWord size) {
        Word fromPtr = Word.objectToUntrackedPointer((Object)fromArray).add(fromOffset);
        Word toPtr = Word.objectToUntrackedPointer((Object)toArray).add(toOffset);
        JavaMemoryUtil.copyPrimitiveArrayBackward((Pointer)fromPtr, (Pointer)toPtr, size);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void copyPrimitiveArrayBackward(Pointer fromPtr, Pointer toPtr, UnsignedWord size) {
        UnmanagedMemoryUtil.copyBackward(fromPtr, toPtr, size);
    }

    private JavaMemoryUtil() {
    }
}

