/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.snippets;

import com.oracle.svm.core.SubstrateDiagnostics;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.code.FactoryMethodMarker;
import com.oracle.svm.core.jdk.InternalVMMethod;
import com.oracle.svm.core.snippets.ExceptionUnwind;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalInt;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.GenericSignatureFormatError;
import org.graalvm.word.LocationIdentity;

@InternalVMMethod
@FactoryMethodMarker
public class ImplicitExceptions {
    public static final String NO_STACK_MSG = "[no exception stack trace available because exception is thrown from code that must be allocation free]";
    public static final NullPointerException CACHED_NULL_POINTER_EXCEPTION = new NullPointerException("[no exception stack trace available because exception is thrown from code that must be allocation free]");
    public static final ArrayIndexOutOfBoundsException CACHED_OUT_OF_BOUNDS_EXCEPTION = new ArrayIndexOutOfBoundsException("[no exception stack trace available because exception is thrown from code that must be allocation free]");
    public static final ClassCastException CACHED_CLASS_CAST_EXCEPTION = new ClassCastException("[no exception stack trace available because exception is thrown from code that must be allocation free]");
    public static final ArrayStoreException CACHED_ARRAY_STORE_EXCEPTION = new ArrayStoreException("[no exception stack trace available because exception is thrown from code that must be allocation free]");
    public static final IllegalArgumentException CACHED_ILLEGAL_ARGUMENT_EXCEPTION = new IllegalArgumentException("[no exception stack trace available because exception is thrown from code that must be allocation free]");
    public static final NegativeArraySizeException CACHED_NEGATIVE_ARRAY_SIZE_EXCEPTION = new NegativeArraySizeException("[no exception stack trace available because exception is thrown from code that must be allocation free]");
    public static final ArithmeticException CACHED_ARITHMETIC_EXCEPTION = new ArithmeticException("[no exception stack trace available because exception is thrown from code that must be allocation free]");
    public static final AssertionError CACHED_ASSERTION_ERROR = new AssertionError((Object)"[no exception stack trace available because exception is thrown from code that must be allocation free]");
    public static final StackOverflowError CACHED_STACK_OVERFLOW_ERROR = new StackOverflowError("[no exception stack trace available because exception is thrown from code that must be allocation free]");
    public static final SnippetRuntime.SubstrateForeignCallDescriptor CREATE_NULL_POINTER_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "createNullPointerException", false, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor CREATE_OUT_OF_BOUNDS_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "createOutOfBoundsException", false, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor CREATE_INTRINSIC_OUT_OF_BOUNDS_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "createIntrinsicOutOfBoundsException", false, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor CREATE_CLASS_CAST_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "createClassCastException", false, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor CREATE_ARRAY_STORE_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "createArrayStoreException", false, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor CREATE_ILLEGAL_ARGUMENT_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "createIllegalArgumentException", false, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor CREATE_NEGATIVE_ARRAY_SIZE_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "createNegativeArraySizeException", false, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor CREATE_DIVISION_BY_ZERO_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "createDivisionByZeroException", false, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor CREATE_ASSERTION_ERROR_NULLARY = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "createAssertionErrorNullary", false, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor CREATE_ASSERTION_ERROR_OBJECT = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "createAssertionErrorObject", false, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_NEW_NULL_POINTER_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwNewNullPointerException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_NEW_INTRINSIC_OUT_OF_BOUNDS_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwNewIntrinsicOutOfBoundsException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_NEW_OUT_OF_BOUNDS_EXCEPTION_WITH_ARGS = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwNewOutOfBoundsExceptionWithArgs", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_NEW_CLASS_CAST_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwNewClassCastException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_NEW_CLASS_CAST_EXCEPTION_WITH_ARGS = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwNewClassCastExceptionWithArgs", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_NEW_ARRAY_STORE_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwNewArrayStoreException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_NEW_ARRAY_STORE_EXCEPTION_WITH_ARGS = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwNewArrayStoreExceptionWithArgs", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_NEW_ILLEGAL_ARGUMENT_EXCEPTION_WITH_ARGS = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwNewIllegalArgumentExceptionWithArgs", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_NEW_NEGATIVE_ARRAY_SIZE_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwNewNegativeArraySizeException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_NEW_ARITHMETIC_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwNewArithmeticException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_NEW_DIVISION_BY_ZERO_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwNewDivisionByZeroException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_NEW_ASSERTION_ERROR_NULLARY = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwNewAssertionErrorNullary", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_NEW_ASSERTION_ERROR_OBJECT = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwNewAssertionErrorObject", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor GET_CACHED_NULL_POINTER_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "getCachedNullPointerException", false, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor GET_CACHED_OUT_OF_BOUNDS_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "getCachedOutOfBoundsException", false, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor GET_CACHED_CLASS_CAST_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "getCachedClassCastException", false, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor GET_CACHED_ARRAY_STORE_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "getCachedArrayStoreException", false, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor GET_CACHED_ILLEGAL_ARGUMENT_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "getCachedIllegalArgumentException", false, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor GET_CACHED_NEGATIVE_ARRAY_SIZE_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "getCachedNegativeArraySizeException", false, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor GET_CACHED_ARITHMETIC_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "getCachedArithmeticException", false, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor GET_CACHED_ASSERTION_ERROR = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "getCachedAssertionError", false, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_CACHED_NULL_POINTER_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwCachedNullPointerException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_CACHED_OUT_OF_BOUNDS_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwCachedOutOfBoundsException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_CACHED_CLASS_CAST_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwCachedClassCastException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_CACHED_ARRAY_STORE_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwCachedArrayStoreException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_CACHED_ILLEGAL_ARGUMENT_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwCachedIllegalArgumentException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_CACHED_NEGATIVE_ARRAY_SIZE_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwCachedNegativeArraySizeException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_CACHED_ARITHMETIC_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwCachedArithmeticException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_CACHED_ASSERTION_ERROR = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwCachedAssertionError", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{CREATE_NULL_POINTER_EXCEPTION, CREATE_OUT_OF_BOUNDS_EXCEPTION, CREATE_INTRINSIC_OUT_OF_BOUNDS_EXCEPTION, CREATE_CLASS_CAST_EXCEPTION, CREATE_ARRAY_STORE_EXCEPTION, CREATE_ILLEGAL_ARGUMENT_EXCEPTION, CREATE_NEGATIVE_ARRAY_SIZE_EXCEPTION, CREATE_DIVISION_BY_ZERO_EXCEPTION, CREATE_ASSERTION_ERROR_NULLARY, CREATE_ASSERTION_ERROR_OBJECT, THROW_NEW_NULL_POINTER_EXCEPTION, THROW_NEW_INTRINSIC_OUT_OF_BOUNDS_EXCEPTION, THROW_NEW_CLASS_CAST_EXCEPTION, THROW_NEW_ARRAY_STORE_EXCEPTION, THROW_NEW_ARITHMETIC_EXCEPTION, THROW_NEW_OUT_OF_BOUNDS_EXCEPTION_WITH_ARGS, THROW_NEW_CLASS_CAST_EXCEPTION_WITH_ARGS, THROW_NEW_ARRAY_STORE_EXCEPTION_WITH_ARGS, THROW_NEW_ILLEGAL_ARGUMENT_EXCEPTION_WITH_ARGS, THROW_NEW_NEGATIVE_ARRAY_SIZE_EXCEPTION, THROW_NEW_DIVISION_BY_ZERO_EXCEPTION, THROW_NEW_ASSERTION_ERROR_NULLARY, THROW_NEW_ASSERTION_ERROR_OBJECT, GET_CACHED_NULL_POINTER_EXCEPTION, GET_CACHED_OUT_OF_BOUNDS_EXCEPTION, GET_CACHED_CLASS_CAST_EXCEPTION, GET_CACHED_ARRAY_STORE_EXCEPTION, GET_CACHED_ILLEGAL_ARGUMENT_EXCEPTION, GET_CACHED_NEGATIVE_ARRAY_SIZE_EXCEPTION, GET_CACHED_ARITHMETIC_EXCEPTION, GET_CACHED_ASSERTION_ERROR, THROW_CACHED_NULL_POINTER_EXCEPTION, THROW_CACHED_OUT_OF_BOUNDS_EXCEPTION, THROW_CACHED_CLASS_CAST_EXCEPTION, THROW_CACHED_ARRAY_STORE_EXCEPTION, THROW_CACHED_ILLEGAL_ARGUMENT_EXCEPTION, THROW_CACHED_NEGATIVE_ARRAY_SIZE_EXCEPTION, THROW_CACHED_ARITHMETIC_EXCEPTION, THROW_CACHED_ASSERTION_ERROR};
    private static final FastThreadLocalInt implicitExceptionsAreFatal = FastThreadLocalFactory.createInt("ImplicitExceptions.implicitExceptionsAreFatal");

    public static void activateImplicitExceptionsAreFatal() {
        implicitExceptionsAreFatal.set(implicitExceptionsAreFatal.get() + 1);
    }

    public static void deactivateImplicitExceptionsAreFatal() {
        implicitExceptionsAreFatal.set(implicitExceptionsAreFatal.get() - 1);
    }

    private static void vmErrorIfImplicitExceptionsAreFatal() {
        if ((implicitExceptionsAreFatal.get() > 0 || ExceptionUnwind.exceptionsAreFatal()) && !SubstrateDiagnostics.isFatalErrorHandlingThread()) {
            throw VMError.shouldNotReachHere("Implicit exception thrown in code where such exceptions are fatal errors");
        }
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static NullPointerException createNullPointerException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        return new NullPointerException();
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static ArrayIndexOutOfBoundsException createIntrinsicOutOfBoundsException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        return new ArrayIndexOutOfBoundsException();
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static ArrayIndexOutOfBoundsException createOutOfBoundsException(int index, int length) {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        return new ArrayIndexOutOfBoundsException("Index " + index + " out of bounds for length " + length);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static ClassCastException createClassCastException(Object object, Class<?> expectedClass) {
        assert (object != null) : "null can be cast to any type, so it cannot show up as a source of a ClassCastException";
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        return new ClassCastException(object.getClass().getTypeName() + " cannot be cast to " + expectedClass.getTypeName());
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static ArrayStoreException createArrayStoreException(Object value) {
        assert (value != null) : "null can be stored into any array, so it cannot show up as a source of an ArrayStoreException";
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        return new ArrayStoreException(value.getClass().getTypeName());
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static IllegalArgumentException createIllegalArgumentException(String message) {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        return new IllegalArgumentException(message);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static NegativeArraySizeException createNegativeArraySizeException(int length) {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        return new NegativeArraySizeException(String.valueOf(length));
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static ArithmeticException createDivisionByZeroException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        return new ArithmeticException("/ by zero");
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static AssertionError createAssertionErrorNullary() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        return new AssertionError();
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static AssertionError createAssertionErrorObject(Object detailMessage) {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        return new AssertionError(detailMessage);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void throwNewNullPointerException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw new NullPointerException();
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void throwNewIntrinsicOutOfBoundsException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw new ArrayIndexOutOfBoundsException();
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void throwNewOutOfBoundsExceptionWithArgs(int index, int length) {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw new ArrayIndexOutOfBoundsException("Index " + index + " out of bounds for length " + length);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void throwNewClassCastException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw new ClassCastException();
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void throwNewClassCastExceptionWithArgs(Object object, Class<?> expectedClass) {
        assert (object != null) : "null can be cast to any type, so it cannot show up as a source of a ClassCastException";
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw new ClassCastException(object.getClass().getTypeName() + " cannot be cast to " + expectedClass.getTypeName());
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void throwNewArrayStoreException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw new ArrayStoreException();
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void throwNewArrayStoreExceptionWithArgs(Object value) {
        assert (value != null) : "null can be stored into any array, so it cannot show up as a source of an ArrayStoreException";
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw new ArrayStoreException(value.getClass().getTypeName());
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void throwNewIllegalArgumentExceptionWithArgs(String message) {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw new IllegalArgumentException(message);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void throwNewNegativeArraySizeException(int length) {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw new NegativeArraySizeException(String.valueOf(length));
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void throwNewArithmeticException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw new ArithmeticException();
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void throwNewDivisionByZeroException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw new ArithmeticException("/ by zero");
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void throwNewAssertionErrorNullary() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw new AssertionError();
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void throwNewAssertionErrorObject(Object detailMessage) {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw new AssertionError(detailMessage);
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an implicit exception in code that must not allocate.")
    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static NullPointerException getCachedNullPointerException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        return CACHED_NULL_POINTER_EXCEPTION;
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an implicit exception in code that must not allocate.")
    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static ArrayIndexOutOfBoundsException getCachedOutOfBoundsException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        return CACHED_OUT_OF_BOUNDS_EXCEPTION;
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an implicit exception in code that must not allocate.")
    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static ClassCastException getCachedClassCastException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        return CACHED_CLASS_CAST_EXCEPTION;
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an implicit exception in code that must not allocate.")
    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static ArrayStoreException getCachedArrayStoreException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        return CACHED_ARRAY_STORE_EXCEPTION;
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an implicit exception in code that must not allocate.")
    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static IllegalArgumentException getCachedIllegalArgumentException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        return CACHED_ILLEGAL_ARGUMENT_EXCEPTION;
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an implicit exception in code that must not allocate.")
    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static NegativeArraySizeException getCachedNegativeArraySizeException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        return CACHED_NEGATIVE_ARRAY_SIZE_EXCEPTION;
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an implicit exception in code that must not allocate.")
    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static ArithmeticException getCachedArithmeticException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        return CACHED_ARITHMETIC_EXCEPTION;
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an implicit exception in code that must not allocate.")
    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static AssertionError getCachedAssertionError() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        return CACHED_ASSERTION_ERROR;
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an implicit exception in code that must not allocate.")
    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void throwCachedNullPointerException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw CACHED_NULL_POINTER_EXCEPTION;
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an implicit exception in code that must not allocate.")
    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void throwCachedOutOfBoundsException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw CACHED_OUT_OF_BOUNDS_EXCEPTION;
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an implicit exception in code that must not allocate.")
    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void throwCachedClassCastException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw CACHED_CLASS_CAST_EXCEPTION;
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an implicit exception in code that must not allocate.")
    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void throwCachedArrayStoreException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw CACHED_ARRAY_STORE_EXCEPTION;
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an implicit exception in code that must not allocate.")
    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void throwCachedIllegalArgumentException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw CACHED_ILLEGAL_ARGUMENT_EXCEPTION;
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an implicit exception in code that must not allocate.")
    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void throwCachedNegativeArraySizeException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw CACHED_NEGATIVE_ARRAY_SIZE_EXCEPTION;
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an implicit exception in code that must not allocate.")
    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void throwCachedArithmeticException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw CACHED_ARITHMETIC_EXCEPTION;
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an implicit exception in code that must not allocate.")
    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void throwCachedAssertionError() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw CACHED_ASSERTION_ERROR;
    }

    public static void throwClassNotFoundException(String message) throws ClassNotFoundException {
        throw new ClassNotFoundException(message);
    }

    public static void throwNoSuchFieldException(String message) throws NoSuchFieldException {
        throw new NoSuchFieldException(message);
    }

    public static void throwNoSuchMethodException(String message) throws NoSuchMethodException {
        throw new NoSuchMethodException(message);
    }

    public static void throwLinkageError(String message) throws LinkageError {
        throw new LinkageError(message);
    }

    public static void throwClassCircularityError(String message) throws ClassCircularityError {
        throw new ClassCircularityError(message);
    }

    public static void throwIncompatibleClassChangeError(String message) throws IncompatibleClassChangeError {
        throw new IncompatibleClassChangeError(message);
    }

    public static void throwNoSuchFieldError(String message) throws NoSuchFieldError {
        throw new NoSuchFieldError(message);
    }

    public static void throwInstantiationError(String message) throws InstantiationError {
        throw new InstantiationError(message);
    }

    public static void throwNoSuchMethodError(String message) throws NoSuchMethodError {
        throw new NoSuchMethodError(message);
    }

    public static void throwIllegalAccessError(String message) throws IllegalAccessError {
        throw new IllegalAccessError(message);
    }

    public static void throwAbstractMethodError(String message) throws AbstractMethodError {
        throw new AbstractMethodError(message);
    }

    public static void throwBootstrapMethodError(String message) throws BootstrapMethodError {
        throw new BootstrapMethodError(message);
    }

    public static void throwClassFormatError(String message) throws ClassFormatError {
        throw new ClassFormatError(message);
    }

    public static void throwGenericSignatureFormatError(String message) throws GenericSignatureFormatError {
        throw new GenericSignatureFormatError(message);
    }

    public static void throwUnsupportedClassVersionError(String message) throws UnsupportedClassVersionError {
        throw new UnsupportedClassVersionError(message);
    }

    public static void throwUnsatisfiedLinkError(String message) throws UnsatisfiedLinkError {
        throw new UnsatisfiedLinkError(message);
    }

    public static void throwNoClassDefFoundError(String message) throws NoClassDefFoundError {
        throw new NoClassDefFoundError(message);
    }

    public static void throwExceptionInInitializerError(String message) throws ExceptionInInitializerError {
        throw new ExceptionInInitializerError(message);
    }

    public static void throwVerifyError(String message) throws VerifyError {
        throw new VerifyError(message);
    }

    public static void throwVerifyError() throws VerifyError {
        throw new VerifyError();
    }
}

