/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.ClassLoaderSupport;
import com.oracle.svm.core.util.ClasspathUtils;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.NativeImageClassLoaderSupport;
import com.oracle.svm.hosted.NativeImageSystemClassLoader;
import com.oracle.svm.util.ModuleSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ClassLoaderSupportImpl
extends ClassLoaderSupport {
    private final NativeImageClassLoaderSupport classLoaderSupport;
    private final ClassLoader imageClassLoader;
    private final Map<String, Set<Module>> packageToModules;

    ClassLoaderSupportImpl(NativeImageClassLoaderSupport classLoaderSupport) {
        this.classLoaderSupport = classLoaderSupport;
        this.imageClassLoader = classLoaderSupport.getClassLoader();
        this.packageToModules = new HashMap<String, Set<Module>>();
        this.buildPackageToModulesMap(classLoaderSupport);
    }

    @Override
    protected boolean isNativeImageClassLoaderImpl(ClassLoader loader) {
        return loader == this.imageClassLoader || loader instanceof NativeImageSystemClassLoader;
    }

    @Override
    public void collectResources(ClassLoaderSupport.ResourceCollector resourceCollector) {
        NativeImageClassLoaderSupport.allLayers(this.classLoaderSupport.moduleLayerForImageBuild).stream().flatMap(moduleLayer -> moduleLayer.configuration().modules().stream()).forEach(resolvedModule -> ClassLoaderSupportImpl.collectResourceFromModule(resourceCollector, resolvedModule));
        for (Path classpathFile : this.classLoaderSupport.classpath()) {
            try {
                if (Files.isDirectory(classpathFile, new LinkOption[0])) {
                    ClassLoaderSupportImpl.scanDirectory(classpathFile, resourceCollector, this.classLoaderSupport);
                    continue;
                }
                if (!ClasspathUtils.isJar(classpathFile)) continue;
                ClassLoaderSupportImpl.scanJar(classpathFile, resourceCollector);
            }
            catch (IOException ex) {
                throw UserError.abort("Unable to handle classpath element '%s'. Make sure that all classpath entries are either directories or valid jar files.", classpathFile);
            }
        }
    }

    private static void collectResourceFromModule(ClassLoaderSupport.ResourceCollector resourceCollector, ResolvedModule resolvedModule) {
        ModuleReference moduleReference = resolvedModule.reference();
        try (ModuleReader moduleReader = moduleReference.open();){
            String moduleName = resolvedModule.name();
            List foundResources = moduleReader.list().filter(resourceName -> resourceCollector.isIncluded(moduleName, (String)resourceName)).collect(Collectors.toList());
            for (String resName : foundResources) {
                Optional<InputStream> content = moduleReader.open(resName);
                if (content.isEmpty()) continue;
                InputStream is = content.get();
                try {
                    resourceCollector.addResource(moduleName, resName, is, false);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (IOException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    private static void scanDirectory(Path root, ClassLoaderSupport.ResourceCollector collector, NativeImageClassLoaderSupport support) throws IOException {
        HashMap<String, List> matchedDirectoryResources = new HashMap<String, List>();
        HashSet<String> allEntries = new HashSet<String>();
        ArrayDeque<Path> queue = new ArrayDeque<Path>();
        queue.push(root);
        while (!queue.isEmpty()) {
            String relativeFilePath;
            Path entry = (Path)queue.pop();
            if (entry != root) {
                relativeFilePath = root.relativize(entry).toString().replace(File.separatorChar, '/');
                allEntries.add(relativeFilePath);
            } else {
                relativeFilePath = "";
            }
            if (Files.isDirectory(entry, new LinkOption[0])) {
                if (collector.isIncluded(null, relativeFilePath)) {
                    matchedDirectoryResources.put(relativeFilePath, new ArrayList());
                }
                Stream<Path> pathStream = Files.list(entry);
                try {
                    Stream<Path> filtered = pathStream;
                    if (support.excludeDirectoriesRoot.equals(entry)) {
                        filtered = filtered.filter(Predicate.not(support.excludeDirectories::contains));
                    }
                    filtered.forEach(queue::push);
                    continue;
                }
                finally {
                    if (pathStream != null) {
                        pathStream.close();
                    }
                    continue;
                }
            }
            if (!collector.isIncluded(null, relativeFilePath)) continue;
            InputStream is = Files.newInputStream(entry, new OpenOption[0]);
            try {
                collector.addResource(null, relativeFilePath, is, false);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        for (String entry : allEntries) {
            int last = entry.lastIndexOf(47);
            String key = last == -1 ? "" : entry.substring(0, last);
            List dirContent = (List)matchedDirectoryResources.get(key);
            if (dirContent == null || dirContent.contains(entry)) continue;
            dirContent.add(entry.substring(last + 1));
        }
        matchedDirectoryResources.forEach((dir, content) -> {
            content.sort(Comparator.naturalOrder());
            collector.addDirectoryResource(null, (String)dir, String.join((CharSequence)System.lineSeparator(), content), false);
        });
    }

    private static void scanJar(Path jarPath, ClassLoaderSupport.ResourceCollector collector) throws IOException {
        try (JarFile jf = new JarFile(jarPath.toFile());){
            Enumeration<JarEntry> entries = jf.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    String dirName = entry.getName().substring(0, entry.getName().length() - 1);
                    if (!collector.isIncluded(null, dirName)) continue;
                    collector.addDirectoryResource(null, dirName, "", true);
                    continue;
                }
                if (!collector.isIncluded(null, entry.getName())) continue;
                InputStream is = jf.getInputStream(entry);
                try {
                    collector.addResource(null, entry.getName(), is, true);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
    }

    @Override
    public List<ResourceBundle> getResourceBundle(String bundleSpec, Locale locale) {
        String bundleName;
        String moduleName;
        String[] specParts = bundleSpec.split(":", 2);
        if (specParts.length > 1) {
            moduleName = specParts[0];
            bundleName = specParts[1];
        } else {
            moduleName = null;
            bundleName = specParts[0];
        }
        String packageName = ClassLoaderSupportImpl.packageName(bundleName);
        Set modules = moduleName != null ? this.classLoaderSupport.findModule(moduleName).stream().collect(Collectors.toSet()) : this.packageToModules.getOrDefault(packageName, Collections.emptySet());
        if (modules.isEmpty()) {
            return Collections.singletonList(ResourceBundle.getBundle(bundleName, locale, this.imageClassLoader));
        }
        ArrayList<ResourceBundle> resourceBundles = new ArrayList<ResourceBundle>();
        for (Module module : modules) {
            ModuleSupport.exportAndOpenPackageToClass((String)module.getName(), (String)packageName, (boolean)false, ClassLoaderSupportImpl.class);
            resourceBundles.add(ResourceBundle.getBundle(bundleName, locale, module));
        }
        return resourceBundles;
    }

    private static String packageName(String bundleName) {
        int classSep = bundleName.replace('/', '.').lastIndexOf(46);
        if (classSep == -1) {
            return "";
        }
        return bundleName.substring(0, classSep);
    }

    private void buildPackageToModulesMap(NativeImageClassLoaderSupport cls) {
        for (ModuleLayer layer : NativeImageClassLoaderSupport.allLayers(cls.moduleLayerForImageBuild)) {
            for (Module module : layer.modules()) {
                for (String packageName : module.getDescriptor().packages()) {
                    this.addToPackageNameModules(module, packageName);
                }
            }
        }
    }

    private void addToPackageNameModules(Module moduleName, String packageName) {
        Set<Module> prevValue = this.packageToModules.get(packageName);
        if (prevValue == null) {
            this.packageToModules.put(packageName, Collections.singleton(moduleName));
        } else if (prevValue.size() == 1) {
            HashSet<Module> newValue = new HashSet<Module>();
            newValue.add(prevValue.iterator().next());
            newValue.add(moduleName);
            this.packageToModules.put(packageName, newValue);
        } else if (prevValue.size() > 1) {
            prevValue.add(moduleName);
        }
    }
}

