/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.c.function.CEntryPointSetup;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.image.NativeImage;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.c.function.CEntryPoint;

public final class CEntryPointData {
    public static final String DEFAULT_NAME = "";
    public static final Class<? extends Function<String, String>> DEFAULT_NAME_TRANSFORMATION = CEntryPointOptions.DefaultNameTransformation.class;
    public static final CEntryPoint.Builtin DEFAULT_BUILTIN = CEntryPoint.Builtin.NO_BUILTIN;
    public static final Class<?> DEFAULT_PROLOGUE = CEntryPointOptions.AutomaticPrologue.class;
    public static final Class<?> DEFAULT_PROLOGUE_BAILOUT = CEntryPointOptions.AutomaticPrologueBailout.class;
    public static final Class<?> DEFAULT_EPILOGUE = CEntryPointSetup.LeaveEpilogue.class;
    public static final Class<?> DEFAULT_EXCEPTION_HANDLER = CEntryPoint.FatalExceptionHandler.class;
    private String symbolName;
    private final Supplier<String> symbolNameSupplier;
    private final String providedName;
    private final String documentation;
    private final CEntryPoint.Builtin builtin;
    private final Class<?> prologue;
    private final Class<?> prologueBailout;
    private final Class<?> epilogue;
    private final Class<?> exceptionHandler;
    private final CEntryPointOptions.Publish publishAs;

    public static CEntryPointData create(ResolvedJavaMethod method) {
        return CEntryPointData.create((CEntryPoint)method.getAnnotation(CEntryPoint.class), (CEntryPointOptions)method.getAnnotation(CEntryPointOptions.class), () -> NativeImage.globalSymbolNameForMethod(method));
    }

    public static CEntryPointData create(ResolvedJavaMethod method, String name, Class<? extends Function<String, String>> nameTransformation, String documentation, Class<?> prologue, Class<?> prologueBailout, Class<?> epilogue, Class<?> exceptionHandler, CEntryPointOptions.Publish publishAs) {
        return CEntryPointData.create(name, () -> NativeImage.globalSymbolNameForMethod(method), nameTransformation, documentation, CEntryPoint.Builtin.NO_BUILTIN, prologue, prologueBailout, epilogue, exceptionHandler, publishAs);
    }

    public static CEntryPointData create(Method method) {
        return CEntryPointData.create(method, DEFAULT_NAME);
    }

    public static CEntryPointData create(Method method, String name) {
        assert (method.getAnnotation(CEntryPoint.class).name().isEmpty() || name.isEmpty());
        return CEntryPointData.create(method.getAnnotation(CEntryPoint.class), method.getAnnotation(CEntryPointOptions.class), () -> !name.isEmpty() ? name : NativeImage.globalSymbolNameForMethod(method));
    }

    public static CEntryPointData create(Method method, String name, Class<? extends Function<String, String>> nameTransformation, String documentation, Class<?> prologue, Class<?> prologueBailout, Class<?> epilogue, Class<?> exceptionHandler, CEntryPointOptions.Publish publishAs) {
        return CEntryPointData.create(name, () -> NativeImage.globalSymbolNameForMethod(method), nameTransformation, documentation, CEntryPoint.Builtin.NO_BUILTIN, prologue, prologueBailout, epilogue, exceptionHandler, publishAs);
    }

    public static CEntryPointData createCustomUnpublished() {
        CEntryPointData unpublished = new CEntryPointData(null, DEFAULT_NAME, DEFAULT_NAME, CEntryPoint.Builtin.NO_BUILTIN, CEntryPointOptions.NoPrologue.class, null, CEntryPointOptions.NoEpilogue.class, DEFAULT_EXCEPTION_HANDLER, CEntryPointOptions.Publish.NotPublished);
        unpublished.symbolName = DEFAULT_NAME;
        return unpublished;
    }

    private static CEntryPointData create(CEntryPoint annotation, CEntryPointOptions options, Supplier<String> alternativeNameSupplier) {
        String annotatedName = annotation.name();
        Class<? extends Function<String, String>> nameTransformation = DEFAULT_NAME_TRANSFORMATION;
        String documentation = String.join((CharSequence)System.lineSeparator(), annotation.documentation());
        CEntryPoint.Builtin builtin = annotation.builtin();
        Class<Object> prologue = DEFAULT_PROLOGUE;
        Class<Object> prologueBailout = DEFAULT_PROLOGUE_BAILOUT;
        Class<Object> epilogue = DEFAULT_EPILOGUE;
        Class exceptionHandler = annotation.exceptionHandler();
        CEntryPointOptions.Publish publishAs = CEntryPointOptions.Publish.SymbolAndHeader;
        if (options != null) {
            nameTransformation = options.nameTransformation();
            prologue = options.prologue();
            prologueBailout = options.prologueBailout();
            epilogue = options.epilogue();
            publishAs = options.publishAs();
        }
        return CEntryPointData.create(annotatedName, alternativeNameSupplier, nameTransformation, documentation, builtin, prologue, prologueBailout, epilogue, exceptionHandler, publishAs);
    }

    private static CEntryPointData create(String providedName, Supplier<String> alternativeNameSupplier, Class<? extends Function<String, String>> nameTransformation, String documentation, CEntryPoint.Builtin builtin, Class<?> prologue, Class<?> prologueBailout, Class<?> epilogue, Class<?> exceptionHandler, CEntryPointOptions.Publish publishAs) {
        Supplier<String> symbolNameSupplier = () -> {
            String symbolName;
            String string = symbolName = !providedName.isEmpty() ? providedName : (String)alternativeNameSupplier.get();
            if (nameTransformation != null) {
                try {
                    Function instance = (Function)nameTransformation.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    symbolName = (String)instance.apply(symbolName);
                }
                catch (Exception e) {
                    throw VMError.shouldNotReachHere(e);
                }
            }
            return symbolName;
        };
        return new CEntryPointData(symbolNameSupplier, providedName, documentation, builtin, prologue, prologueBailout, epilogue, exceptionHandler, publishAs);
    }

    private CEntryPointData(Supplier<String> symbolNameSupplier, String providedName, String documentation, CEntryPoint.Builtin builtin, Class<?> prologue, Class<?> prologueBailout, Class<?> epilogue, Class<?> exceptionHandler, CEntryPointOptions.Publish publishAs) {
        this.symbolNameSupplier = symbolNameSupplier;
        this.providedName = providedName;
        this.documentation = documentation;
        this.builtin = builtin;
        this.prologue = prologue;
        this.prologueBailout = prologueBailout;
        this.epilogue = epilogue;
        this.exceptionHandler = exceptionHandler;
        this.publishAs = publishAs;
    }

    public CEntryPointData copyWithPublishAs(CEntryPointOptions.Publish customPublishAs) {
        return new CEntryPointData(this.symbolNameSupplier, this.providedName, this.documentation, this.builtin, this.prologue, this.prologueBailout, this.epilogue, this.exceptionHandler, customPublishAs);
    }

    public String getSymbolName() {
        if (this.symbolName == null) {
            this.symbolName = this.symbolNameSupplier.get();
            assert (this.symbolName != null);
        }
        return this.symbolName;
    }

    public String getProvidedName() {
        return this.providedName;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public CEntryPoint.Builtin getBuiltin() {
        return this.builtin;
    }

    public Class<?> getPrologue() {
        return this.prologue;
    }

    public Class<?> getPrologueBailout() {
        return this.prologueBailout;
    }

    public Class<?> getEpilogue() {
        return this.epilogue;
    }

    public Class<?> getExceptionHandler() {
        return this.exceptionHandler;
    }

    public CEntryPointOptions.Publish getPublishAs() {
        return this.publishAs;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CEntryPointData) {
            CEntryPointData other = (CEntryPointData)obj;
            return Objects.equals(this.getSymbolName(), other.getSymbolName()) && Objects.equals(this.providedName, other.providedName) && Objects.equals(this.documentation, other.documentation) && Objects.equals(this.builtin, other.builtin) && Objects.equals(this.prologue, other.prologue) && Objects.equals(this.epilogue, other.epilogue) && Objects.equals(this.exceptionHandler, other.exceptionHandler) && this.publishAs == other.publishAs;
        }
        return false;
    }

    public int hashCode() {
        int h = Objects.hashCode(this.getSymbolName());
        h = h * 31 + Objects.hashCode(this.providedName);
        h = h * 31 + Objects.hashCode(this.documentation);
        h = h * 31 + Objects.hashCode(this.builtin);
        h = h * 31 + Objects.hashCode(this.prologue);
        h = h * 31 + Objects.hashCode(this.epilogue);
        h = h * 31 + Objects.hashCode(this.exceptionHandler);
        h = h * 31 + this.publishAs.hashCode();
        return h;
    }
}

