/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.code.ImageCodeInfo;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.GraalConfiguration;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.code.SubstrateMetaAccessExtensionProvider;
import com.oracle.svm.core.graal.code.SubstratePlatformConfigurationProvider;
import com.oracle.svm.core.graal.code.SubstrateRegisterConfigFactory;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.meta.SubstrateLoweringProvider;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import com.oracle.svm.core.graal.meta.SubstrateSnippetReflectionProvider;
import com.oracle.svm.core.graal.meta.SubstrateStampProvider;
import com.oracle.svm.core.graal.word.SubstrateWordTypes;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.stack.JavaFrameAnchor;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.AccessorInfo;
import com.oracle.svm.hosted.c.info.StructFieldInfo;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.config.HybridLayout;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.thread.VMThreadMTFeature;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.util.EnumMap;
import java.util.function.Function;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.core.common.spi.MetaAccessExtensionProvider;
import org.graalvm.compiler.nodes.gc.BarrierSet;
import org.graalvm.compiler.nodes.spi.LoopsDataProvider;
import org.graalvm.compiler.nodes.spi.LoweringProvider;
import org.graalvm.compiler.nodes.spi.PlatformConfigurationProvider;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.nodes.spi.StampProvider;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.word.WordTypes;
import org.graalvm.nativeimage.ImageSingletons;

public abstract class SharedRuntimeConfigurationBuilder {
    protected final OptionValues options;
    protected final SVMHost hostVM;
    protected final MetaAccessProvider metaAccess;
    protected RuntimeConfiguration runtimeConfig;
    protected WordTypes wordTypes;
    protected final Function<Providers, SubstrateBackend> backendProvider;
    protected final NativeLibraries nativeLibraries;
    protected final ClassInitializationSupport classInitializationSupport;
    protected final LoopsDataProvider originalLoopsDataProvider;

    public SharedRuntimeConfigurationBuilder(OptionValues options, SVMHost hostVM, MetaAccessProvider metaAccess, Function<Providers, SubstrateBackend> backendProvider, NativeLibraries nativeLibraries, ClassInitializationSupport classInitializationSupport, LoopsDataProvider originalLoopsDataProvider) {
        this.options = options;
        this.hostVM = hostVM;
        this.metaAccess = metaAccess;
        this.backendProvider = backendProvider;
        this.nativeLibraries = nativeLibraries;
        this.classInitializationSupport = classInitializationSupport;
        this.originalLoopsDataProvider = originalLoopsDataProvider;
    }

    public SharedRuntimeConfigurationBuilder build() {
        EnumMap<SubstrateRegisterConfig.ConfigKind, RegisterConfig> registerConfigs = new EnumMap<SubstrateRegisterConfig.ConfigKind, RegisterConfig>(SubstrateRegisterConfig.ConfigKind.class);
        for (SubstrateRegisterConfig.ConfigKind config : SubstrateRegisterConfig.ConfigKind.values()) {
            registerConfigs.put(config, ((SubstrateRegisterConfigFactory)ImageSingletons.lookup(SubstrateRegisterConfigFactory.class)).newRegisterFactory(config, this.metaAccess, ConfigurationValues.getTarget(), SubstrateOptions.PreserveFramePointer.getValue()));
        }
        this.wordTypes = new SubstrateWordTypes(this.metaAccess, FrameAccess.getWordKind());
        Providers p = this.createProviders(null, null, null, null, null, null, null, null, null, null, null);
        StampProvider stampProvider = this.createStampProvider(p);
        p = this.createProviders(null, null, null, null, null, null, stampProvider, null, null, null, null);
        ConstantReflectionProvider constantReflection = this.createConstantReflectionProvider(p);
        p = this.createProviders(null, constantReflection, null, null, null, null, stampProvider, null, null, null, null);
        ConstantFieldProvider constantFieldProvider = this.createConstantFieldProvider(p);
        SnippetReflectionProvider snippetReflection = this.createSnippetReflectionProvider();
        ForeignCallsProvider foreignCalls = this.createForeignCallsProvider((RegisterConfig)registerConfigs.get((Object)SubstrateRegisterConfig.ConfigKind.NORMAL));
        p = this.createProviders(null, constantReflection, constantFieldProvider, foreignCalls, null, null, stampProvider, snippetReflection, null, null, null);
        BarrierSet barrierSet = ((Heap)ImageSingletons.lookup(Heap.class)).createBarrierSet(this.metaAccess);
        SubstratePlatformConfigurationProvider platformConfig = new SubstratePlatformConfigurationProvider(barrierSet);
        SubstrateMetaAccessExtensionProvider metaAccessExtensionProvider = new SubstrateMetaAccessExtensionProvider();
        p = this.createProviders(null, constantReflection, constantFieldProvider, foreignCalls, null, null, stampProvider, snippetReflection, platformConfig, metaAccessExtensionProvider, null);
        LoweringProvider lowerer = this.createLoweringProvider(p);
        p = this.createProviders(null, constantReflection, constantFieldProvider, foreignCalls, lowerer, null, stampProvider, snippetReflection, platformConfig, metaAccessExtensionProvider, null);
        Replacements replacements = this.createReplacements(p, snippetReflection);
        p = this.createProviders(null, constantReflection, constantFieldProvider, foreignCalls, lowerer, replacements, stampProvider, snippetReflection, platformConfig, metaAccessExtensionProvider, null);
        LoopsDataProvider loopsDataProvider = this.originalLoopsDataProvider;
        p = this.createProviders(null, constantReflection, constantFieldProvider, foreignCalls, lowerer, replacements, stampProvider, snippetReflection, platformConfig, metaAccessExtensionProvider, loopsDataProvider);
        EnumMap<SubstrateRegisterConfig.ConfigKind, SubstrateBackend> backends = new EnumMap<SubstrateRegisterConfig.ConfigKind, SubstrateBackend>(SubstrateRegisterConfig.ConfigKind.class);
        for (SubstrateRegisterConfig.ConfigKind config : SubstrateRegisterConfig.ConfigKind.values()) {
            CodeCacheProvider codeCacheProvider = this.createCodeCacheProvider((RegisterConfig)registerConfigs.get((Object)config));
            Providers newProviders = this.createProviders(codeCacheProvider, constantReflection, constantFieldProvider, foreignCalls, lowerer, replacements, stampProvider, snippetReflection, platformConfig, metaAccessExtensionProvider, loopsDataProvider);
            backends.put(config, GraalConfiguration.runtimeInstance().createBackend(newProviders));
        }
        this.runtimeConfig = new RuntimeConfiguration(p, snippetReflection, backends, this.wordTypes);
        return this;
    }

    public WordTypes getWordTypes() {
        return this.wordTypes;
    }

    protected Providers createProviders(CodeCacheProvider codeCache, ConstantReflectionProvider constantReflection, ConstantFieldProvider constantFieldProvider, ForeignCallsProvider foreignCalls, LoweringProvider lowerer, Replacements replacements, StampProvider stampProvider, SnippetReflectionProvider snippetReflection, PlatformConfigurationProvider platformConfigurationProvider, MetaAccessExtensionProvider metaAccessExtensionProvider, LoopsDataProvider loopsDataProvider) {
        return new Providers(this.metaAccess, codeCache, constantReflection, constantFieldProvider, foreignCalls, lowerer, replacements, stampProvider, platformConfigurationProvider, metaAccessExtensionProvider, snippetReflection, this.wordTypes, loopsDataProvider);
    }

    public RuntimeConfiguration getRuntimeConfig() {
        return this.runtimeConfig;
    }

    protected StampProvider createStampProvider(Providers p) {
        return new SubstrateStampProvider(p.getMetaAccess());
    }

    protected abstract ConstantReflectionProvider createConstantReflectionProvider(Providers var1);

    protected abstract ConstantFieldProvider createConstantFieldProvider(Providers var1);

    protected SnippetReflectionProvider createSnippetReflectionProvider() {
        return new SubstrateSnippetReflectionProvider(this.getWordTypes());
    }

    protected ForeignCallsProvider createForeignCallsProvider(RegisterConfig registerConfig) {
        return new SubstrateForeignCallsProvider(this.metaAccess, registerConfig);
    }

    protected LoweringProvider createLoweringProvider(Providers p) {
        return SubstrateLoweringProvider.createForRuntime(p.getMetaAccess(), p.getForeignCalls(), p.getPlatformConfigurationProvider(), p.getMetaAccessExtensionProvider());
    }

    protected abstract Replacements createReplacements(Providers var1, SnippetReflectionProvider var2);

    protected abstract CodeCacheProvider createCodeCacheProvider(RegisterConfig var1);

    public void updateLazyState(HostedMetaAccess hMetaAccess) {
        HybridLayout<DynamicHub> hubLayout = new HybridLayout<DynamicHub>(DynamicHub.class, ConfigurationValues.getObjectLayout(), hMetaAccess);
        int vtableBaseOffset = hubLayout.getArrayBaseOffset();
        int vtableEntrySize = ConfigurationValues.getObjectLayout().sizeInBytes(hubLayout.getArrayElementStorageKind());
        int typeIDSlotsOffset = HybridLayout.getTypeIDSlotsFieldOffset(ConfigurationValues.getObjectLayout());
        int componentHubOffset = hMetaAccess.lookupJavaField(ReflectionUtil.lookupField(DynamicHub.class, (String)"componentType")).getLocation();
        int javaFrameAnchorLastSPOffset = this.findStructOffset(JavaFrameAnchor.class, "getLastJavaSP");
        int javaFrameAnchorLastIPOffset = this.findStructOffset(JavaFrameAnchor.class, "getLastJavaIP");
        int vmThreadStatusOffset = -1;
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            vmThreadStatusOffset = ((VMThreadMTFeature)ImageSingletons.lookup(VMThreadMTFeature.class)).offsetOf(VMThreads.StatusSupport.statusTL);
        }
        int imageCodeInfoCodeStartOffset = hMetaAccess.lookupJavaField(ReflectionUtil.lookupField(ImageCodeInfo.class, (String)"codeStart")).getLocation();
        this.runtimeConfig.setLazyState(vtableBaseOffset, vtableEntrySize, typeIDSlotsOffset, componentHubOffset, javaFrameAnchorLastSPOffset, javaFrameAnchorLastIPOffset, vmThreadStatusOffset, imageCodeInfoCodeStartOffset);
    }

    private int findStructOffset(Class<?> clazz, String accessorName) {
        try {
            AccessorInfo accessorInfo = (AccessorInfo)this.nativeLibraries.findElementInfo((AnnotatedElement)this.metaAccess.lookupJavaMethod((Executable)clazz.getDeclaredMethod(accessorName, new Class[0])));
            StructFieldInfo structFieldInfo = (StructFieldInfo)accessorInfo.getParent();
            return structFieldInfo.getOffsetInfo().getProperty();
        }
        catch (ReflectiveOperationException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }
}

