/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.serialize.hosted;

import com.oracle.svm.core.jdk.RecordSupport;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ConditionalConfigurationRegistry;
import com.oracle.svm.hosted.ConfigurationTypeResolver;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.reflect.serialize.SerializationRegistry;
import com.oracle.svm.reflect.serialize.SerializationSupport;
import com.oracle.svm.reflect.serialize.hosted.SerializationDenyRegistry;
import com.oracle.svm.reflect.serialize.hosted.SerializationFeature;
import com.oracle.svm.util.ReflectionUtil;
import java.io.Externalizable;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import jdk.internal.reflect.ReflectionFactory;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeSerializationSupport;

final class SerializationBuilder
extends ConditionalConfigurationRegistry
implements RuntimeSerializationSupport {
    private static final Method getConstructorAccessorMethod = ReflectionUtil.lookupMethod(Constructor.class, (String)"getConstructorAccessor", (Class[])new Class[0]);
    private static final Method getExternalizableConstructorMethod = ReflectionUtil.lookupMethod(ObjectStreamClass.class, (String)"getExternalizableConstructor", (Class[])new Class[]{Class.class});
    private final Constructor<?> stubConstructor;
    private final Field descField;
    private final Method getDataLayoutMethod;
    private final SerializationSupport serializationSupport;
    private final SerializationDenyRegistry denyRegistry;
    private final ConfigurationTypeResolver typeResolver;
    private final FeatureImpl.DuringSetupAccessImpl access;
    private boolean sealed;

    SerializationBuilder(SerializationDenyRegistry serializationDenyRegistry, FeatureImpl.DuringSetupAccessImpl access, ConfigurationTypeResolver typeResolver) {
        this.access = access;
        Class<?> classDataSlotClazz = access.findClassByName("java.io.ObjectStreamClass$ClassDataSlot");
        this.descField = ReflectionUtil.lookupField(classDataSlotClazz, (String)"desc");
        this.getDataLayoutMethod = ReflectionUtil.lookupMethod(ObjectStreamClass.class, (String)"getClassDataLayout", (Class[])new Class[0]);
        this.stubConstructor = SerializationBuilder.newConstructorForSerialization(SerializationSupport.StubForAbstractClass.class, null);
        this.denyRegistry = serializationDenyRegistry;
        this.typeResolver = typeResolver;
        this.serializationSupport = new SerializationSupport(this.stubConstructor);
        ImageSingletons.add(SerializationRegistry.class, (Object)this.serializationSupport);
    }

    private void abortIfSealed() {
        UserError.guarantee(!this.sealed, "Too late to add classes for serialization. Registration must happen in a Feature before the analysis has finished.", new Object[0]);
    }

    public void registerIncludingAssociatedClasses(ConfigurationCondition condition, Class<?> clazz) {
        this.registerIncludingAssociatedClasses(condition, clazz, new HashSet());
    }

    private void registerIncludingAssociatedClasses(ConfigurationCondition condition, Class<?> clazz, Set<Class<?>> alreadyVisited) {
        if (alreadyVisited.contains(clazz)) {
            return;
        }
        alreadyVisited.add(clazz);
        String targetClassName = clazz.getName();
        if (clazz.isPrimitive()) {
            Class boxedType = JavaKind.fromJavaClass(clazz).toBoxedJavaClass();
            this.registerIncludingAssociatedClasses(condition, boxedType, alreadyVisited);
            return;
        }
        if (!Serializable.class.isAssignableFrom(clazz)) {
            SerializationFeature.warn("Class " + targetClassName + " does not implement java.io.Serializable and was not registered for object serialization.\n");
            return;
        }
        if (this.access.findSubclasses(clazz).size() > 1) {
            SerializationFeature.warn("Class " + targetClassName + " has subclasses. No classes were registered for object serialization.\n");
            return;
        }
        try {
            clazz.getDeclaredMethod("writeObject", ObjectOutputStream.class);
            SerializationFeature.warn("Class " + targetClassName + " implements its own writeObject method for object serialization. Any serialization types it uses need to be explicitly registered.\n");
            return;
        }
        catch (NoSuchMethodException boxedType) {
            this.register(condition, clazz);
            if (clazz.isArray()) {
                this.registerIncludingAssociatedClasses(condition, clazz.getComponentType(), alreadyVisited);
                return;
            }
            ObjectStreamClass osc = ObjectStreamClass.lookup(clazz);
            try {
                for (Object o : (Object[])this.getDataLayoutMethod.invoke((Object)osc, new Object[0])) {
                    ObjectStreamClass desc = (ObjectStreamClass)this.descField.get(o);
                    if (desc.equals(osc)) continue;
                    this.registerIncludingAssociatedClasses(condition, desc.forClass(), alreadyVisited);
                }
            }
            catch (ReflectiveOperationException e) {
                VMError.shouldNotReachHere("Cannot register serialization classes due to", e);
            }
            for (ObjectStreamField field : osc.getFields()) {
                this.registerIncludingAssociatedClasses(condition, field.getType(), alreadyVisited);
            }
            return;
        }
    }

    public void register(ConfigurationCondition condition, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            this.registerWithTargetConstructorClass(condition, clazz, null);
        }
    }

    public void registerLambdaCapturingClass(ConfigurationCondition condition, String lambdaCapturingClassName) {
        Class<?> serializationTargetClass = this.typeResolver.resolveType(lambdaCapturingClassName);
        this.registerConditionalConfiguration(condition, () -> {
            SerializationFeature.capturingClasses.add(serializationTargetClass);
            RuntimeReflection.register((Class[])new Class[]{serializationTargetClass});
        });
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((boolean)true, serializationTargetClass, (String)"$deserializeLambda$", (Class[])new Class[]{SerializedLambda.class})});
    }

    public void registerWithTargetConstructorClass(ConfigurationCondition condition, String targetClassName, String customTargetConstructorClassName) {
        this.abortIfSealed();
        Class<?> conditionClass = this.typeResolver.resolveType(condition.getTypeName());
        if (conditionClass == null) {
            return;
        }
        Class<?> serializationTargetClass = this.typeResolver.resolveType(targetClassName);
        UserError.guarantee(serializationTargetClass != null, "Cannot find serialization target class %s. The missing of this class can't be ignored even if --allow-incomplete-classpath is set. Please make sure it is in the classpath", targetClassName);
        if (customTargetConstructorClassName != null) {
            Class<?> customTargetConstructorClass = this.typeResolver.resolveType(customTargetConstructorClassName);
            UserError.guarantee(customTargetConstructorClass != null, "Cannot find targetConstructorClass %s. The missing of this class can't be ignored even if --allow-incomplete-classpath is set. Please make sure it is in the classpath", customTargetConstructorClass);
            this.registerWithTargetConstructorClass(condition, serializationTargetClass, customTargetConstructorClass);
        } else {
            this.registerWithTargetConstructorClass(condition, serializationTargetClass, null);
        }
    }

    public void registerWithTargetConstructorClass(ConfigurationCondition condition, Class<?> serializationTargetClass, Class<?> customTargetConstructorClass) {
        this.abortIfSealed();
        if (!Serializable.class.isAssignableFrom(serializationTargetClass)) {
            SerializationFeature.println("Warning: Could not register " + serializationTargetClass.getName() + " for serialization as it does not implement Serializable.");
        } else if (this.denyRegistry.isAllowed(serializationTargetClass)) {
            if (customTargetConstructorClass != null) {
                UserError.guarantee(customTargetConstructorClass.isAssignableFrom(serializationTargetClass), "The given targetConstructorClass %s is not a subclass of the serialization target class %s.", customTargetConstructorClass, serializationTargetClass);
            }
            this.registerConditionalConfiguration(condition, () -> {
                Class<?> targetConstructor = this.addConstructorAccessor(serializationTargetClass, customTargetConstructorClass);
                SerializationBuilder.addReflections(serializationTargetClass, targetConstructor);
            });
        }
    }

    public void afterAnalysis() {
        this.sealed = true;
    }

    private static void addReflections(Class<?> serializationTargetClass, Class<?> targetConstructorClass) {
        RecordSupport recordSupport;
        if (targetConstructorClass != null) {
            RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupConstructor(targetConstructorClass, (Class[])new Class[0])});
        }
        if (Externalizable.class.isAssignableFrom(serializationTargetClass)) {
            RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupConstructor(serializationTargetClass, (Class[])null)});
        }
        if ((recordSupport = RecordSupport.singleton()).isRecord(serializationTargetClass)) {
            RuntimeReflection.register((Executable[])new Executable[]{recordSupport.getCanonicalRecordConstructor(serializationTargetClass)});
            RuntimeReflection.register((Executable[])recordSupport.getRecordComponentAccessorMethods(serializationTargetClass));
        }
        RuntimeReflection.register((Class[])new Class[]{serializationTargetClass});
        RuntimeReflection.register((Executable[])serializationTargetClass.getDeclaredConstructors());
        SerializationBuilder.registerMethods(serializationTargetClass);
        SerializationBuilder.registerFields(serializationTargetClass);
    }

    private static void registerMethods(Class<?> serializationTargetClass) {
        RuntimeReflection.register((Executable[])serializationTargetClass.getDeclaredMethods());
        Method computeDefaultSUID = ReflectionUtil.lookupMethod(ObjectStreamClass.class, (String)"computeDefaultSUID", (Class[])new Class[]{Class.class});
        RuntimeReflection.register((Executable[])new Executable[]{computeDefaultSUID});
    }

    private static void registerFields(Class<?> serializationTargetClass) {
        RuntimeReflection.register((Field[])serializationTargetClass.getDeclaredFields());
    }

    private static Constructor<?> newConstructorForSerialization(Class<?> serializationTargetClass, Constructor<?> customConstructorToCall) {
        if (customConstructorToCall == null) {
            return ReflectionFactory.getReflectionFactory().newConstructorForSerialization(serializationTargetClass);
        }
        return ReflectionFactory.getReflectionFactory().newConstructorForSerialization(serializationTargetClass, customConstructorToCall);
    }

    private static Object getConstructorAccessor(Constructor<?> constructor) {
        try {
            return getConstructorAccessorMethod.invoke(constructor, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    private static Constructor<?> getExternalizableConstructor(Class<?> serializationTargetClass) {
        try {
            return (Constructor)getExternalizableConstructorMethod.invoke(null, serializationTargetClass);
        }
        catch (ReflectiveOperationException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    Class<?> addConstructorAccessor(Class<?> serializationTargetClass, Class<?> customTargetConstructorClass) {
        Class<?> targetConstructorClass;
        Constructor<?> targetConstructor;
        if (serializationTargetClass.isArray() || Enum.class.isAssignableFrom(serializationTargetClass)) {
            return null;
        }
        if (Externalizable.class.isAssignableFrom(serializationTargetClass)) {
            try {
                Constructor<?> externalizableConstructor = SerializationBuilder.getExternalizableConstructor(serializationTargetClass);
                return externalizableConstructor.getDeclaringClass();
            }
            catch (Exception e) {
                throw VMError.shouldNotReachHere(e);
            }
        }
        if (Modifier.isAbstract(serializationTargetClass.getModifiers())) {
            targetConstructor = this.stubConstructor;
            targetConstructorClass = targetConstructor.getDeclaringClass();
        } else {
            if (customTargetConstructorClass == serializationTargetClass) {
                return customTargetConstructorClass;
            }
            Constructor<?> customConstructorToCall = null;
            if (customTargetConstructorClass != null) {
                try {
                    customConstructorToCall = customTargetConstructorClass.getDeclaredConstructor(new Class[0]);
                }
                catch (NoSuchMethodException ex) {
                    UserError.abort("The given targetConstructorClass %s does not declare a parameterless constructor.", customTargetConstructorClass.getTypeName());
                }
            }
            if ((targetConstructor = SerializationBuilder.newConstructorForSerialization(serializationTargetClass, customConstructorToCall)) == null) {
                targetConstructor = SerializationBuilder.newConstructorForSerialization(Object.class, customConstructorToCall);
            }
        }
        targetConstructorClass = targetConstructor.getDeclaringClass();
        this.serializationSupport.addConstructorAccessor(serializationTargetClass, targetConstructorClass, SerializationBuilder.getConstructorAccessor(targetConstructor));
        return targetConstructorClass;
    }
}

