/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.graal;

import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.gc.SerialWriteBarrier;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;

@NodeInfo(cycles=NodeCycles.CYCLES_8, size=NodeSize.SIZE_4)
public final class ForcedSerialPostWriteBarrier
extends FixedWithNextNode
implements Lowerable {
    public static final NodeClass<ForcedSerialPostWriteBarrier> TYPE = NodeClass.create(ForcedSerialPostWriteBarrier.class);
    @Node.Input(value=InputType.Association)
    AddressNode address;
    private final boolean precise;

    public ForcedSerialPostWriteBarrier(ValueNode address, boolean precise) {
        super(TYPE, StampFactory.forVoid());
        this.address = (AddressNode)address;
        this.precise = precise;
    }

    public void lower(LoweringTool tool) {
        if (this.graph().getGuardsStage().areFrameStatesAtDeopts()) {
            SerialWriteBarrier barrier = (SerialWriteBarrier)this.graph().add((Node)new SerialWriteBarrier(this.address, this.precise));
            this.graph().replaceFixedWithFixed((FixedWithNextNode)this, (FixedWithNextNode)barrier);
            tool.getLowerer().lower((Node)barrier, tool);
        }
    }

    @Node.NodeIntrinsic
    public static native void force(AddressNode.Address var0, @Node.ConstantNodeParameter boolean var1);
}

