/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.IsolateArgumentParser;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.heap.ReferenceHandlerThread;
import com.oracle.svm.core.heap.ReferenceInternals;
import com.oracle.svm.core.heap.Target_java_lang_ref_Cleaner;
import com.oracle.svm.core.heap.Target_java_lang_ref_Cleaner_Cleanable;
import com.oracle.svm.core.heap.Target_jdk_internal_ref_CleanerFactory;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.util.VMError;
import java.lang.ref.Reference;

public final class ReferenceHandler {
    public static boolean useDedicatedThread() {
        if (ReferenceHandlerThread.isSupported()) {
            int useReferenceHandlerThread = IsolateArgumentParser.getOptionIndex(SubstrateOptions.ConcealedOptions.UseReferenceHandlerThread);
            int automaticReferenceHandling = IsolateArgumentParser.getOptionIndex(SubstrateOptions.ConcealedOptions.AutomaticReferenceHandling);
            return IsolateArgumentParser.getBooleanOptionValue(useReferenceHandlerThread) && IsolateArgumentParser.getBooleanOptionValue(automaticReferenceHandling);
        }
        return false;
    }

    public static boolean useRegularJavaThread() {
        int useReferenceHandlerThread = IsolateArgumentParser.getOptionIndex(SubstrateOptions.ConcealedOptions.UseReferenceHandlerThread);
        int automaticReferenceHandling = IsolateArgumentParser.getOptionIndex(SubstrateOptions.ConcealedOptions.AutomaticReferenceHandling);
        return (!ReferenceHandlerThread.isSupported() || !IsolateArgumentParser.getBooleanOptionValue(useReferenceHandlerThread)) && IsolateArgumentParser.getBooleanOptionValue(automaticReferenceHandling);
    }

    public static boolean isExecutedManually() {
        int automaticReferenceHandling = IsolateArgumentParser.getOptionIndex(SubstrateOptions.ConcealedOptions.AutomaticReferenceHandling);
        return !IsolateArgumentParser.getBooleanOptionValue(automaticReferenceHandling);
    }

    public static void processPendingReferencesInRegularThread() {
        assert (!ReferenceHandler.useDedicatedThread());
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        try {
            ReferenceInternals.processPendingReferences();
            ReferenceHandler.processCleaners();
        }
        catch (Throwable t) {
            VMError.shouldNotReachHere("Reference processing and cleaners must handle all potential exceptions", t);
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    static void processCleaners() {
        Target_java_lang_ref_Cleaner commonCleaner = Target_jdk_internal_ref_CleanerFactory.cleaner();
        Reference<Object> ref = commonCleaner.impl.queue.poll();
        while (ref != null) {
            try {
                Target_java_lang_ref_Cleaner_Cleanable cl = SubstrateUtil.cast(ref, Target_java_lang_ref_Cleaner_Cleanable.class);
                cl.clean();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ref = commonCleaner.impl.queue.poll();
        }
    }

    private ReferenceHandler() {
    }
}

