/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.Target_java_util_logging_LogManager_Cleaner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.LogManager;

@TargetClass(value=LogManager.class)
final class Target_java_util_logging_LogManager {
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.NewInstance, declClass=AtomicBoolean.class)
    private AtomicBoolean addedShutdownHook = new AtomicBoolean();
    @Alias
    static LogManager manager;

    Target_java_util_logging_LogManager() {
    }

    @Alias
    native void ensureLogManagerInitialized();

    @Substitute
    public static LogManager getLogManager() {
        if (manager == null) {
            return manager;
        }
        Target_java_util_logging_LogManager managerAlias = SubstrateUtil.cast(manager, Target_java_util_logging_LogManager.class);
        managerAlias.ensureLogManagerInitialized();
        if (!managerAlias.addedShutdownHook.getAndSet(true)) {
            try {
                Runtime.getRuntime().addShutdownHook(SubstrateUtil.cast(new Target_java_util_logging_LogManager_Cleaner(managerAlias), Thread.class));
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return manager;
    }
}

