/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.events;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.jfr.JfrEvent;
import com.oracle.svm.core.jfr.JfrNativeEventWriter;
import com.oracle.svm.core.jfr.JfrNativeEventWriterData;
import com.oracle.svm.core.jfr.JfrNativeEventWriterDataAccess;
import com.oracle.svm.core.jfr.JfrThreadState;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.thread.PlatformThreads;
import java.util.concurrent.TimeUnit;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.Threading;
import org.graalvm.nativeimage.impl.ThreadingSupport;

public final class ExecutionSampleEvent {
    private static long intervalMillis;
    private static final ExecutionSampleEventCallback CALLBACK;

    @Uninterruptible(reason="Called from uninterruptible code.", calleeMustBe=false)
    public static void tryToRegisterExecutionSampleEventCallback() {
        if (SubstrateJVM.get().isEnabled(JfrEvent.ExecutionSample) && intervalMillis > 0L) {
            ((ThreadingSupport)ImageSingletons.lookup(ThreadingSupport.class)).registerRecurringCallback(intervalMillis, TimeUnit.MILLISECONDS, (Threading.RecurringCallback)CALLBACK);
        }
    }

    public static void setSamplingInterval(long intervalMillis) {
        ExecutionSampleEvent.intervalMillis = intervalMillis;
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    public static void writeExecutionSample(IsolateThread isolateThread, Thread.State threadState) {
        SubstrateJVM svm = SubstrateJVM.get();
        if (SubstrateJVM.isRecording() && svm.isEnabled(JfrEvent.ExecutionSample)) {
            JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
            JfrNativeEventWriterDataAccess.initializeThreadLocalNativeBuffer(data);
            JfrNativeEventWriter.beginEventWrite(data, false);
            JfrNativeEventWriter.putLong(data, JfrEvent.ExecutionSample.getId());
            JfrNativeEventWriter.putLong(data, JfrTicks.elapsedTicks());
            JfrNativeEventWriter.putThread(data, isolateThread);
            JfrNativeEventWriter.putLong(data, svm.getStackTraceId(JfrEvent.ExecutionSample.getId(), 0));
            JfrNativeEventWriter.putLong(data, JfrThreadState.getId(threadState));
            JfrNativeEventWriter.endEventWrite(data, false);
        }
    }

    static {
        CALLBACK = new ExecutionSampleEventCallback();
    }

    private static final class ExecutionSampleEventCallback
    implements Threading.RecurringCallback {
        private ExecutionSampleEventCallback() {
        }

        public void run(Threading.RecurringCallbackAccess access) {
            IsolateThread isolateThread = CurrentIsolate.getCurrentThread();
            Thread javaThread = PlatformThreads.fromVMThread(isolateThread);
            ExecutionSampleEvent.writeExecutionSample(isolateThread, javaThread.getState());
        }
    }
}

