/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.jdk.StackTraceUtils;
import com.oracle.svm.core.jdk.Target_jdk_internal_misc_VM;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.thread.LoomSupport;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.Target_java_lang_Thread;
import com.oracle.svm.core.thread.Target_java_lang_ThreadGroup;
import com.oracle.svm.core.thread.Target_java_lang_ThreadLocal;
import com.oracle.svm.core.thread.VirtualThreads;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;

public final class JavaThreads {
    static final AtomicLong threadSeqNumber = new AtomicLong();
    static final AtomicInteger threadInitNumber = new AtomicInteger();

    private JavaThreads() {
    }

    @SuppressFBWarnings(value={"BC"}, justification="Cast for @TargetClass")
    static Thread fromTarget(Target_java_lang_Thread thread) {
        return (Thread)Thread.class.cast(thread);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @SuppressFBWarnings(value={"BC"}, justification="Cast for @TargetClass")
    static Target_java_lang_Thread toTarget(Thread thread) {
        return (Target_java_lang_Thread)Target_java_lang_Thread.class.cast(thread);
    }

    public static int getThreadStatus(Thread thread) {
        return LoomSupport.CompatibilityUtil.getThreadStatus(JavaThreads.toTarget(thread));
    }

    public static void setThreadStatus(Thread thread, int threadStatus) {
        LoomSupport.CompatibilityUtil.setThreadStatus(JavaThreads.toTarget(thread), threadStatus);
    }

    static Thread.State getThreadState(Thread thread) {
        return Target_jdk_internal_misc_VM.toThreadState(JavaThreads.getThreadStatus(thread));
    }

    static boolean isInterrupted(Thread thread) {
        return JavaThreads.getInterruptedFlag(thread);
    }

    private static boolean getInterruptedFlag(Thread thread) {
        if (JavaVersionUtil.JAVA_SPEC >= 17) {
            return JavaThreads.toTarget((Thread)thread).interruptedJDK17OrLater;
        }
        return JavaThreads.toTarget((Thread)thread).interruptedJDK11OrEarlier;
    }

    static boolean getAndClearInterrupt(Thread thread) {
        if (JavaThreads.supportsVirtual() && JavaThreads.isVirtual(thread)) {
            return VirtualThreads.singleton().getAndClearInterrupt(thread);
        }
        return JavaThreads.getAndClearInterruptedFlag(thread);
    }

    static boolean getAndClearInterruptedFlag(Thread thread) {
        boolean oldValue = JavaThreads.isInterrupted(thread);
        if (oldValue) {
            JavaThreads.writeInterruptedFlag(thread, false);
        }
        return oldValue;
    }

    static void writeInterruptedFlag(Thread thread, boolean value) {
        if (JavaVersionUtil.JAVA_SPEC >= 17) {
            JavaThreads.toTarget((Thread)thread).interruptedJDK17OrLater = value;
        } else {
            JavaThreads.toTarget((Thread)thread).interruptedJDK11OrEarlier = value;
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getParentThreadId(Thread thread) {
        return JavaThreads.toTarget((Thread)thread).parentThreadId;
    }

    @Fold
    static boolean supportsVirtual() {
        return VirtualThreads.isSupported();
    }

    static boolean isVirtual(Thread thread) {
        return JavaThreads.supportsVirtual() && VirtualThreads.singleton().isVirtual(thread);
    }

    private static boolean isVirtualDisallowLoom(Thread thread) {
        if (LoomSupport.isEnabled()) {
            assert (!JavaThreads.isVirtual(thread)) : "should not see Loom virtual thread objects here";
            return false;
        }
        return JavaThreads.isVirtual(thread);
    }

    @SuppressFBWarnings(value={"BC"}, justification="Cast for @TargetClass")
    static Target_java_lang_ThreadGroup toTarget(ThreadGroup threadGroup) {
        return (Target_java_lang_ThreadGroup)Target_java_lang_ThreadGroup.class.cast(threadGroup);
    }

    static void join(Thread thread, long millis) throws InterruptedException {
        if (millis < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (JavaThreads.supportsVirtual() && JavaThreads.isVirtual(thread)) {
            VirtualThreads.singleton().join(thread, millis);
        } else {
            PlatformThreads.join(thread, millis);
        }
    }

    static void yieldCurrent() {
        if (JavaThreads.supportsVirtual() && JavaThreads.isVirtualDisallowLoom(Thread.currentThread())) {
            VirtualThreads.singleton().yield();
        } else {
            PlatformThreads.singleton().yieldCurrent();
        }
    }

    @NeverInline(value="Starting a stack walk in the caller frame")
    static StackTraceElement[] getStackTrace(Thread thread) {
        if (thread == Thread.currentThread()) {
            return StackTraceUtils.getStackTrace(false, KnownIntrinsics.readCallerStackPointer());
        }
        if (JavaThreads.isVirtual(thread)) {
            return Target_java_lang_Thread.EMPTY_STACK_TRACE;
        }
        return PlatformThreads.getStackTrace(thread);
    }

    public static void dispatchUncaughtException(Thread thread, Throwable throwable) {
        Thread.UncaughtExceptionHandler handler = thread.getUncaughtExceptionHandler();
        if (handler == null) {
            handler = Thread.getDefaultUncaughtExceptionHandler();
        }
        if (handler != null) {
            try {
                handler.uncaughtException(thread, throwable);
            }
            catch (Throwable throwable2) {}
        } else {
            System.err.print("Exception in thread \"" + Thread.currentThread().getName() + "\" ");
            throwable.printStackTrace();
        }
    }

    static void initializeNewThread(Target_java_lang_Thread tjlt, ThreadGroup groupArg, Runnable target, String name, long stackSize, AccessControlContext acc, boolean inheritThreadLocals) {
        boolean daemon;
        int priority;
        ThreadGroup group;
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        tjlt.name = name;
        Thread parent = PlatformThreads.currentThread.get();
        ThreadGroup threadGroup = group = groupArg != null ? groupArg : parent.getThreadGroup();
        if (JavaThreads.toTarget(parent) == tjlt) {
            priority = 5;
            daemon = false;
        } else {
            priority = parent.getPriority();
            daemon = parent.isDaemon();
        }
        LoomSupport.CompatibilityUtil.initThreadFields(tjlt, group, target, stackSize, priority, daemon, 0);
        if (!(LoomSupport.isEnabled() || VirtualThreads.isSupported() && VirtualThreads.singleton().isVirtual(JavaThreads.fromTarget(tjlt)))) {
            JavaThreads.toTarget(group).addUnstarted();
        }
        tjlt.contextClassLoader = parent.getContextClassLoader();
        tjlt.inheritedAccessControlContext = acc != null ? acc : AccessController.getContext();
        Target_java_lang_Thread targetParent = SubstrateUtil.cast(parent, Target_java_lang_Thread.class);
        if (inheritThreadLocals && targetParent.inheritableThreadLocals != null) {
            tjlt.inheritableThreadLocals = Target_java_lang_ThreadLocal.createInheritedMap(targetParent.inheritableThreadLocals);
        }
        tjlt.tid = Target_java_lang_Thread.nextThreadID();
    }

    static void sleep(long millis) throws InterruptedException {
        if (JavaThreads.supportsVirtual() && JavaThreads.isVirtualDisallowLoom(Thread.currentThread())) {
            VirtualThreads.singleton().sleepMillis(millis);
        } else {
            PlatformThreads.sleep(millis);
        }
    }

    static boolean isAlive(Thread thread) {
        if (JavaThreads.supportsVirtual() && JavaThreads.isVirtualDisallowLoom(thread)) {
            return VirtualThreads.singleton().isAlive(thread);
        }
        return PlatformThreads.isAlive(thread);
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    public static void setCurrentThreadLockHelper(Object helper) {
        if (JavaThreads.supportsVirtual()) {
            JavaThreads.toTarget((Thread)Thread.currentThread()).lockHelper = helper;
        } else {
            PlatformThreads.lockHelper.set(helper);
        }
    }

    @AlwaysInline(value="Locking fast path.")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Object getCurrentThreadLockHelper() {
        if (JavaThreads.supportsVirtual()) {
            return JavaThreads.toTarget((Thread)Thread.currentThread()).lockHelper;
        }
        return PlatformThreads.lockHelper.get();
    }
}

