/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.PosixSunSecuritySubstitutions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.hosted.FeatureImpl;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import sun.security.provider.NativePRNG;

@AutomaticFeature
@Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
public class NativeSecureRandomFilesCloser
implements Feature {
    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        access.registerReachabilityHandler(this::registerShutdownHook, new Object[]{NativePRNG.class});
    }

    private void registerShutdownHook(Feature.DuringAnalysisAccess a) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        RuntimeSupport.Hook hook = PosixSunSecuritySubstitutions.getTearDownHook();
        RuntimeSupport.getRuntimeSupport().addTearDownHook(hook);
        access.rescanObject(hook);
    }
}

