/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.annotation;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.graal.jdk.SubstrateObjectCloneWithExceptionNode;
import com.oracle.svm.core.jdk.AnnotationSupportConfig;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.analysis.NativeImagePointsToAnalysis;
import com.oracle.svm.hosted.annotation.AnnotationSubstitutionField;
import com.oracle.svm.hosted.annotation.AnnotationSubstitutionMethod;
import com.oracle.svm.hosted.annotation.AnnotationSubstitutionType;
import com.oracle.svm.hosted.annotation.ConstantAnnotationMarkerSubstitutionType;
import com.oracle.svm.hosted.annotation.CustomSubstitution;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.java.FrameStateBuilder;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnwindNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.calc.ObjectEqualsNode;
import org.graalvm.compiler.nodes.calc.XorNode;
import org.graalvm.compiler.nodes.extended.BoxNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.java.ArrayLengthNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.replacements.nodes.MacroNode;
import sun.reflect.annotation.TypeNotPresentExceptionProxy;

public class AnnotationSupport
extends CustomSubstitution<AnnotationSubstitutionType> {
    public static final Class<?> constantAnnotationMarkerInterface = Override.class;
    private final SnippetReflectionProvider snippetReflection;
    private final ResolvedJavaType javaLangReflectProxy;
    private final ResolvedJavaType constantAnnotationMarkerOriginalType;
    private final ResolvedJavaType constantAnnotationMarkerSubstitutionType;
    private static final int ANNOTATION = 8192;

    public AnnotationSupport(MetaAccessProvider metaAccess, SnippetReflectionProvider snippetReflection) {
        super(metaAccess);
        this.snippetReflection = snippetReflection;
        this.javaLangReflectProxy = metaAccess.lookupJavaType(Proxy.class);
        this.constantAnnotationMarkerOriginalType = metaAccess.lookupJavaType(constantAnnotationMarkerInterface);
        this.constantAnnotationMarkerSubstitutionType = new ConstantAnnotationMarkerSubstitutionType(this.constantAnnotationMarkerOriginalType, this);
        AnnotationSupportConfig.initialize();
    }

    private boolean isConstantAnnotationType(ResolvedJavaType type) {
        return type.getInterfaces().length == 2 && AnnotationSupport.isAnnotation(type.getInterfaces()[0]) && type.getInterfaces()[1].equals(this.constantAnnotationMarkerOriginalType) && this.javaLangReflectProxy.isAssignableFrom(type);
    }

    private static boolean isAnnotation(ResolvedJavaType type) {
        return (type.getModifiers() & 0x2000) != 0;
    }

    public ResolvedJavaType lookup(ResolvedJavaType type) {
        if (this.isConstantAnnotationType(type)) {
            return this.getSubstitution(type);
        }
        if (type.equals(this.constantAnnotationMarkerOriginalType)) {
            return this.constantAnnotationMarkerSubstitutionType;
        }
        return type;
    }

    public ResolvedJavaType resolve(ResolvedJavaType type) {
        if (type instanceof AnnotationSubstitutionType) {
            return ((AnnotationSubstitutionType)type).original;
        }
        if (type.equals(this.constantAnnotationMarkerSubstitutionType)) {
            return this.constantAnnotationMarkerOriginalType;
        }
        return type;
    }

    public ResolvedJavaField lookup(ResolvedJavaField field) {
        if (this.isConstantAnnotationType(field.getDeclaringClass())) {
            throw new UnsupportedFeatureException("Field of annotation proxy is not accessible: " + field);
        }
        return field;
    }

    public ResolvedJavaMethod lookup(ResolvedJavaMethod method) {
        if (this.isConstantAnnotationType(method.getDeclaringClass()) && !method.getName().equals("proxyClassLookup")) {
            AnnotationSubstitutionType declaringClass = this.getSubstitution(method.getDeclaringClass());
            AnnotationSubstitutionMethod result = (AnnotationSubstitutionMethod)declaringClass.getSubstitutionMethod(method);
            assert (result != null && result.original.equals(method));
            return result;
        }
        return method;
    }

    public ResolvedJavaMethod resolve(ResolvedJavaMethod method) {
        if (method instanceof AnnotationSubstitutionMethod) {
            return ((AnnotationSubstitutionMethod)method).original;
        }
        return method;
    }

    private synchronized AnnotationSubstitutionType getSubstitution(ResolvedJavaType type) {
        AnnotationSubstitutionType result = (AnnotationSubstitutionType)this.getSubstitutionType(type);
        if (result == null) {
            AnnotationSubstitutionMethod substitutionMethod;
            result = new AnnotationSubstitutionType(this.metaAccess, type);
            for (ResolvedJavaMethod originalMethod : type.getDeclaredMethods()) {
                String methodName = AnnotationSupport.canonicalMethodName(originalMethod);
                if (methodName.equals("proxyClassLookup")) continue;
                if (methodName.equals("equals")) {
                    substitutionMethod = new AnnotationEqualsMethod(originalMethod);
                } else if (methodName.equals("hashCode")) {
                    substitutionMethod = new AnnotationHashCodeMethod(originalMethod);
                } else if (methodName.equals("toString")) {
                    substitutionMethod = new AnnotationToStringMethod(originalMethod);
                } else if (methodName.equals("annotationType")) {
                    substitutionMethod = new AnnotationAnnotationTypeMethod(originalMethod);
                } else {
                    substitutionMethod = new AnnotationAccessorMethod(originalMethod);
                    result.addSubstitutionField(new AnnotationSubstitutionField(result, originalMethod, this.snippetReflection, this.metaAccess));
                }
                result.addSubstitutionMethod(originalMethod, substitutionMethod);
            }
            for (ResolvedJavaMethod originalMethod : type.getDeclaredConstructors()) {
                substitutionMethod = new AnnotationConstructorMethod(originalMethod);
                result.addSubstitutionMethod(originalMethod, substitutionMethod);
            }
            this.typeSubstitutions.put(type, result);
        }
        return result;
    }

    static boolean isClassType(JavaType type, MetaAccessProvider metaAccess) {
        return type.getJavaKind() == JavaKind.Object && (type.equals(metaAccess.lookupJavaType(Class.class)) || type.equals(metaAccess.lookupJavaType(Class[].class)));
    }

    private static ValueNode unpackAttribute(HostedProviders providers, HostedGraphKit kit, ValueNode attribute, ResolvedJavaType attributeType) {
        if (AnnotationSupport.isClassType((JavaType)attributeType, providers.getMetaAccess())) {
            return AnnotationSupport.unpackClassAttribute(providers, kit, attributeType, attribute);
        }
        return attribute;
    }

    private static ValueNode unpackClassAttribute(HostedProviders providers, HostedGraphKit kit, ResolvedJavaType attributeType, ValueNode inputAttribute) {
        ValueNode attribute = inputAttribute;
        ResolvedJavaType exceptionProxyType = providers.getMetaAccess().lookupJavaType(TypeNotPresentExceptionProxy.class);
        TypeReference exceptionProxyTypeRef = TypeReference.createTrusted((Assumptions)kit.getAssumptions(), (ResolvedJavaType)exceptionProxyType);
        LogicNode condition = (LogicNode)kit.append((ValueNode)InstanceOfNode.create((TypeReference)exceptionProxyTypeRef, (ValueNode)attribute));
        kit.startIf(condition, BranchProbabilityNode.SLOW_PATH_PROFILE);
        kit.thenPart();
        PiNode casted = kit.createPiNode(attribute, (Stamp)StampFactory.object((TypeReference)exceptionProxyTypeRef, (boolean)true));
        ResolvedJavaMethod generateExceptionMethod = kit.findMethod(TypeNotPresentExceptionProxy.class, "generateException", false);
        ValueNode exception = kit.createJavaCallWithExceptionAndUnwind(CallTargetNode.InvokeKind.Virtual, generateExceptionMethod, new ValueNode[]{casted});
        kit.append((ValueNode)new UnwindNode(exception));
        kit.elsePart();
        TypeReference resultTypeRef = TypeReference.createTrusted((Assumptions)kit.getAssumptions(), (ResolvedJavaType)attributeType);
        attribute = kit.createPiNode(attribute, (Stamp)StampFactory.object((TypeReference)resultTypeRef, (boolean)true));
        kit.endIf();
        return attribute;
    }

    private static ResolvedJavaType findAnnotationInterfaceType(ResolvedJavaType annotationType) {
        VMError.guarantee(NativeImagePointsToAnalysis.toWrappedType(annotationType) instanceof AnnotationSubstitutionType);
        ResolvedJavaType[] interfaces = annotationType.getInterfaces();
        VMError.guarantee(interfaces.length == 1, "Unexpected number of interfaces for annotation proxy class.");
        return interfaces[0];
    }

    static ResolvedJavaType findAnnotationInterfaceTypeForMarkedAnnotationType(ResolvedJavaType annotationType, MetaAccessProvider metaAccess) {
        ResolvedJavaType[] interfaces = annotationType.getInterfaces();
        VMError.guarantee(interfaces.length == 2, "Unexpected number of interfaces for annotation proxy class.");
        VMError.guarantee(interfaces[1].equals(metaAccess.lookupJavaType(constantAnnotationMarkerInterface)));
        return interfaces[0];
    }

    static Class<?> findAnnotationInterfaceTypeForMarkedAnnotationType(Class<? extends Proxy> clazz) {
        Class<?>[] interfaces = clazz.getInterfaces();
        VMError.guarantee(interfaces.length == 2, "Unexpected number of interfaces for annotation proxy class.");
        VMError.guarantee(interfaces[1].equals(constantAnnotationMarkerInterface));
        return interfaces[0];
    }

    static boolean isAnnotationMarkerInterface(ResolvedJavaType type, MetaAccessProvider metaAccess) {
        return type.equals(metaAccess.lookupJavaType(constantAnnotationMarkerInterface));
    }

    static class AnnotationToStringMethod
    extends AnnotationSubstitutionMethod {
        AnnotationToStringMethod(ResolvedJavaMethod original) {
            super(original);
        }

        public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
            assert (!Modifier.isStatic(method.getModifiers()) && method.getSignature().getParameterCount(false) == 0);
            ResolvedJavaType annotationType = method.getDeclaringClass();
            ResolvedJavaType annotationInterfaceType = AnnotationSupport.findAnnotationInterfaceType(annotationType);
            HostedGraphKit kit = new HostedGraphKit(debug, providers, method);
            StructuredGraph graph = kit.getGraph();
            FrameStateBuilder state = new FrameStateBuilder(null, method, graph);
            state.initializeForMethodStart(null, true, providers.getGraphBuilderPlugins());
            graph.start().setStateAfter(state.create(0, (StateSplit)graph.start()));
            String returnValue = "@" + annotationInterfaceType.toJavaName(true);
            FloatingNode returnConstant = kit.unique((FloatingNode)ConstantNode.forConstant((JavaConstant)SubstrateObjectConstant.forObject(returnValue), (MetaAccessProvider)providers.getMetaAccess()));
            kit.append((ValueNode)new ReturnNode((ValueNode)returnConstant));
            return kit.finalizeGraph();
        }
    }

    static class AnnotationHashCodeMethod
    extends AnnotationSubstitutionMethod {
        AnnotationHashCodeMethod(ResolvedJavaMethod original) {
            super(original);
        }

        public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
            assert (!Modifier.isStatic(method.getModifiers()) && method.getSignature().getParameterCount(false) == 0);
            ResolvedJavaType annotationType = method.getDeclaringClass();
            HostedGraphKit kit = new HostedGraphKit(debug, providers, method);
            StructuredGraph graph = kit.getGraph();
            FrameStateBuilder state = new FrameStateBuilder(null, method, graph);
            state.initializeForMethodStart(null, true, providers.getGraphBuilderPlugins());
            int bci = 0;
            graph.start().setStateAfter(state.create(bci++, (StateSplit)graph.start()));
            ValueNode receiver = state.loadLocal(0, JavaKind.Object);
            ConstantNode result = ConstantNode.forInt((int)0, (StructuredGraph)graph);
            for (Pair<String, ResolvedJavaType> attributePair : CustomSubstitution.findAttributes(annotationType)) {
                InvokeWithExceptionNode attributeHashCode;
                ResolvedJavaMethod m;
                String attribute = (String)attributePair.getLeft();
                ResolvedJavaField ourField = CustomSubstitution.findField(annotationType, attribute);
                ResolvedJavaType attributeType = (ResolvedJavaType)attributePair.getRight();
                ValueNode ourAttribute = kit.append((ValueNode)LoadFieldNode.create(null, (ValueNode)receiver, (ResolvedJavaField)ourField));
                if (attributeType.isPrimitive()) {
                    ResolvedJavaType boxedAttributeType = providers.getMetaAccess().lookupJavaType(attributeType.getJavaKind().toBoxedJavaClass());
                    ourAttribute = kit.append((ValueNode)BoxNode.create((ValueNode)ourAttribute, (ResolvedJavaType)boxedAttributeType, (JavaKind)attributeType.getJavaKind()));
                }
                ourAttribute = AnnotationSupport.unpackAttribute(providers, kit, ourAttribute, attributeType);
                if (attributeType.isArray()) {
                    m = CustomSubstitution.findMethod(providers.getMetaAccess().lookupJavaType(Arrays.class), "hashCode", attributeType);
                    attributeHashCode = kit.createInvokeWithExceptionAndUnwind(m, CallTargetNode.InvokeKind.Static, state, bci++, new ValueNode[]{ourAttribute});
                } else {
                    ourAttribute = kit.maybeCreateExplicitNullCheck(ourAttribute);
                    m = kit.findMethod(Object.class, "hashCode", false);
                    attributeHashCode = kit.createInvokeWithExceptionAndUnwind(m, CallTargetNode.InvokeKind.Virtual, state, bci++, new ValueNode[]{ourAttribute});
                }
                attributeHashCode = kit.unique((FloatingNode)new XorNode((ValueNode)attributeHashCode, (ValueNode)ConstantNode.forInt((int)(127 * attribute.hashCode()), (StructuredGraph)graph)));
                result = kit.unique((FloatingNode)new AddNode((ValueNode)result, (ValueNode)attributeHashCode));
            }
            kit.append((ValueNode)new ReturnNode((ValueNode)result));
            return kit.finalizeGraph();
        }
    }

    static class AnnotationEqualsMethod
    extends AnnotationSubstitutionMethod {
        AnnotationEqualsMethod(ResolvedJavaMethod original) {
            super(original);
        }

        public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
            assert (!Modifier.isStatic(method.getModifiers()) && method.getSignature().getParameterCount(false) == 1);
            ResolvedJavaType annotationType = method.getDeclaringClass();
            ResolvedJavaType annotationInterfaceType = AnnotationSupport.findAnnotationInterfaceType(annotationType);
            HostedGraphKit kit = new HostedGraphKit(debug, providers, method);
            StructuredGraph graph = kit.getGraph();
            FrameStateBuilder state = new FrameStateBuilder(null, method, graph);
            state.initializeForMethodStart(null, true, providers.getGraphBuilderPlugins());
            int bci = 0;
            graph.start().setStateAfter(state.create(bci++, (StateSplit)graph.start()));
            ValueNode receiver = state.loadLocal(0, JavaKind.Object);
            ValueNode other = state.loadLocal(1, JavaKind.Object);
            ConstantNode trueValue = ConstantNode.forBoolean((boolean)true, (StructuredGraph)graph);
            ConstantNode falseValue = ConstantNode.forBoolean((boolean)false, (StructuredGraph)graph);
            kit.startIf((LogicNode)graph.unique((Node)new ObjectEqualsNode(receiver, other)), BranchProbabilityNode.LIKELY_PROFILE);
            kit.thenPart();
            kit.append((ValueNode)new ReturnNode((ValueNode)trueValue));
            kit.endIf();
            TypeReference otherTypeRef = TypeReference.createTrustedWithoutAssumptions((ResolvedJavaType)annotationInterfaceType);
            kit.startIf((LogicNode)graph.unique((Node)InstanceOfNode.create((TypeReference)otherTypeRef, (ValueNode)other)), BranchProbabilityNode.NOT_LIKELY_PROFILE);
            kit.elsePart();
            kit.append((ValueNode)new ReturnNode((ValueNode)falseValue));
            kit.endIf();
            other = kit.append((ValueNode)new PiNode(other, (Stamp)StampFactory.objectNonNull((TypeReference)otherTypeRef)));
            for (Pair<String, ResolvedJavaType> attributePair : CustomSubstitution.findAttributes(annotationType)) {
                InvokeWithExceptionNode attributeEqual;
                ResolvedJavaMethod m;
                String attribute = (String)attributePair.getLeft();
                ResolvedJavaField ourField = CustomSubstitution.findField(annotationType, attribute);
                ResolvedJavaMethod otherMethod = CustomSubstitution.findMethod(annotationInterfaceType, attribute, new ResolvedJavaType[0]);
                ResolvedJavaType attributeType = (ResolvedJavaType)attributePair.getRight();
                InvokeWithExceptionNode otherAttribute = kit.createInvokeWithExceptionAndUnwind(otherMethod, CallTargetNode.InvokeKind.Interface, state, bci++, new ValueNode[]{other});
                ValueNode ourAttribute = kit.append((ValueNode)LoadFieldNode.create(null, (ValueNode)receiver, (ResolvedJavaField)ourField));
                if (attributeType.isPrimitive()) {
                    ResolvedJavaType boxedAttributeType = providers.getMetaAccess().lookupJavaType(attributeType.getJavaKind().toBoxedJavaClass());
                    ourAttribute = kit.append((ValueNode)BoxNode.create((ValueNode)ourAttribute, (ResolvedJavaType)boxedAttributeType, (JavaKind)attributeType.getJavaKind()));
                    otherAttribute = kit.append((ValueNode)BoxNode.create((ValueNode)otherAttribute, (ResolvedJavaType)boxedAttributeType, (JavaKind)attributeType.getJavaKind()));
                }
                ourAttribute = AnnotationSupport.unpackAttribute(providers, kit, ourAttribute, attributeType);
                if (attributeType.isArray()) {
                    m = CustomSubstitution.findMethod(providers.getMetaAccess().lookupJavaType(Arrays.class), "equals", attributeType, attributeType);
                    attributeEqual = kit.createInvokeWithExceptionAndUnwind(m, CallTargetNode.InvokeKind.Static, state, bci++, new ValueNode[]{ourAttribute, otherAttribute});
                } else {
                    m = kit.findMethod(Object.class, "equals", false);
                    ValueNode ourAttributeNonNull = kit.maybeCreateExplicitNullCheck(ourAttribute);
                    attributeEqual = kit.createInvokeWithExceptionAndUnwind(m, CallTargetNode.InvokeKind.Virtual, state, bci++, new ValueNode[]{ourAttributeNonNull, otherAttribute});
                }
                kit.startIf((LogicNode)graph.unique((Node)new IntegerEqualsNode((ValueNode)attributeEqual, (ValueNode)trueValue)), BranchProbabilityNode.LIKELY_PROFILE);
                kit.elsePart();
                kit.append((ValueNode)new ReturnNode((ValueNode)falseValue));
                kit.endIf();
            }
            kit.append((ValueNode)new ReturnNode((ValueNode)trueValue));
            return kit.finalizeGraph();
        }
    }

    static class AnnotationAnnotationTypeMethod
    extends AnnotationSubstitutionMethod {
        AnnotationAnnotationTypeMethod(ResolvedJavaMethod original) {
            super(original);
        }

        public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
            ResolvedJavaType annotationType = method.getDeclaringClass();
            ResolvedJavaType annotationInterfaceType = AnnotationSupport.findAnnotationInterfaceType(annotationType);
            JavaConstant returnValue = providers.getConstantReflection().asJavaClass(annotationInterfaceType);
            HostedGraphKit kit = new HostedGraphKit(debug, providers, method);
            FloatingNode returnConstant = kit.unique((FloatingNode)ConstantNode.forConstant((JavaConstant)returnValue, (MetaAccessProvider)providers.getMetaAccess()));
            kit.append((ValueNode)new ReturnNode((ValueNode)returnConstant));
            return kit.finalizeGraph();
        }
    }

    static class AnnotationAccessorMethod
    extends AnnotationSubstitutionMethod {
        AnnotationAccessorMethod(ResolvedJavaMethod original) {
            super(original);
        }

        public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
            ResolvedJavaType annotationType = method.getDeclaringClass();
            assert (!Modifier.isStatic(method.getModifiers()) && method.getSignature().getParameterCount(false) == 0);
            HostedGraphKit kit = new HostedGraphKit(debug, providers, method);
            StructuredGraph graph = kit.getGraph();
            FrameStateBuilder state = new FrameStateBuilder(null, method, graph);
            state.initializeForMethodStart(null, true, providers.getGraphBuilderPlugins());
            int bci = 0;
            graph.start().setStateAfter(state.create(bci++, (StateSplit)graph.start()));
            ValueNode receiver = state.loadLocal(0, JavaKind.Object);
            ResolvedJavaField field = CustomSubstitution.findField(annotationType, CustomSubstitution.canonicalMethodName(method));
            ValueNode loadField = kit.append((ValueNode)LoadFieldNode.create(null, (ValueNode)receiver, (ResolvedJavaField)field));
            ResolvedJavaType resultType = method.getSignature().getReturnType(null).resolve(null);
            loadField = AnnotationSupport.unpackAttribute(providers, kit, loadField, resultType);
            if (resultType.isArray()) {
                loadField = kit.maybeCreateExplicitNullCheck(loadField);
                ValueNode arrayLength = kit.append((ValueNode)new ArrayLengthNode(loadField));
                kit.startIf((LogicNode)graph.unique((Node)new IntegerEqualsNode(arrayLength, (ValueNode)ConstantNode.forInt((int)0, (StructuredGraph)graph))), BranchProbabilityNode.NOT_LIKELY_PROFILE);
                kit.elsePart();
                ResolvedJavaMethod cloneMethod = kit.findMethod(Object.class, "clone", false);
                JavaType returnType = cloneMethod.getSignature().getReturnType(null);
                StampPair returnStampPair = StampFactory.forDeclaredType(null, (JavaType)returnType, (boolean)false);
                SubstrateObjectCloneWithExceptionNode cloned = kit.appendWithUnwind(new SubstrateObjectCloneWithExceptionNode(MacroNode.MacroParams.of((CallTargetNode.InvokeKind)CallTargetNode.InvokeKind.Virtual, (ResolvedJavaMethod)method, (ResolvedJavaMethod)cloneMethod, (int)bci++, (StampPair)returnStampPair, (ValueNode[])new ValueNode[]{loadField})));
                state.push(returnType.getJavaKind(), (ValueNode)cloned);
                ((StateSplit)cloned).setStateAfter(state.create(bci, (StateSplit)cloned));
                state.pop(returnType.getJavaKind());
                FloatingNode casted = kit.unique((FloatingNode)new PiNode((ValueNode)cloned, resultType, false, false));
                kit.append((ValueNode)new ReturnNode((ValueNode)casted));
                kit.endIf();
            }
            kit.append((ValueNode)new ReturnNode(loadField));
            return kit.finalizeGraph();
        }
    }

    static class AnnotationConstructorMethod
    extends AnnotationSubstitutionMethod {
        AnnotationConstructorMethod(ResolvedJavaMethod original) {
            super(original);
        }

        public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
            HostedGraphKit kit = new HostedGraphKit(debug, providers, method);
            StructuredGraph graph = kit.getGraph();
            graph.addAfterFixed((FixedWithNextNode)graph.start(), (FixedNode)graph.add((Node)new DeoptimizeNode(DeoptimizationAction.None, DeoptimizationReason.UnreachedCode)));
            return graph;
        }
    }
}

