/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.phases.SubstrateIntrinsicGraphBuilder;
import com.oracle.graal.pointsto.util.CompletionExecutor;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AlwaysInlineAllCallees;
import com.oracle.svm.core.annotate.AlwaysInlineSelectCallees;
import com.oracle.svm.core.annotate.DeoptTest;
import com.oracle.svm.core.annotate.NeverInlineTrivial;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Specialize;
import com.oracle.svm.core.annotate.StubCallingConvention;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.code.FrameInfoEncoder;
import com.oracle.svm.core.deopt.DeoptEntryInfopoint;
import com.oracle.svm.core.graal.GraalConfiguration;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallLinkage;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.nodes.DeoptEntryNode;
import com.oracle.svm.core.graal.nodes.DeoptTestNode;
import com.oracle.svm.core.graal.nodes.SubstrateNarrowOopStamp;
import com.oracle.svm.core.graal.phases.DeadStoreRemovalPhase;
import com.oracle.svm.core.graal.phases.OptimizeExceptionPathsPhase;
import com.oracle.svm.core.graal.stackvalue.StackValueNode;
import com.oracle.svm.core.heap.RestrictHeapAccessCallees;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.meta.SubstrateMethodPointerConstant;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureHandler;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.ProgressReporter;
import com.oracle.svm.hosted.code.CompilationInfo;
import com.oracle.svm.hosted.code.CompilationInfoSupport;
import com.oracle.svm.hosted.code.InliningUtilities;
import com.oracle.svm.hosted.code.RestrictHeapAccessAnnotationChecker;
import com.oracle.svm.hosted.code.SharedRuntimeConfigurationBuilder;
import com.oracle.svm.hosted.code.SubstrateHostedCompilationIdentifier;
import com.oracle.svm.hosted.code.UninterruptibleAnnotationChecker;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.phases.DevirtualizeCallsPhase;
import com.oracle.svm.hosted.phases.HostedGraphBuilderPhase;
import com.oracle.svm.hosted.phases.ImageBuildStatisticsCounterPhase;
import com.oracle.svm.hosted.phases.ImplicitAssertionsPhase;
import com.oracle.svm.hosted.phases.StrengthenStampsPhase;
import com.oracle.svm.hosted.substitute.DeletedMethod;
import com.oracle.svm.util.ImageBuildStatistics;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ForkJoinPool;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.code.DebugInfo;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.ConstantReference;
import jdk.vm.ci.code.site.DataPatch;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.code.site.InfopointReason;
import jdk.vm.ci.code.site.Reference;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.VMConstant;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.asm.Assembler;
import org.graalvm.compiler.bytecode.Bytecode;
import org.graalvm.compiler.bytecode.ResolvedJavaMethodBytecode;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.code.DataSection;
import org.graalvm.compiler.core.GraalCompiler;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.Fields;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.spi.CodeGenProviders;
import org.graalvm.compiler.core.common.type.AbstractObjectStamp;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.core.target.Backend;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.lir.RedundantMoveElimination;
import org.graalvm.compiler.lir.alloc.RegisterAllocationPhase;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.asm.CompilationResultBuilderFactory;
import org.graalvm.compiler.lir.asm.DataBuilder;
import org.graalvm.compiler.lir.asm.FrameContext;
import org.graalvm.compiler.lir.framemap.FrameMap;
import org.graalvm.compiler.lir.phases.LIRSuites;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.IndirectCallTargetNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GeneratedFoldInvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.nodes.virtual.CommitAllocationNode;
import org.graalvm.compiler.nodes.virtual.VirtualInstanceNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectState;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.common.BoxNodeOptimizationPhase;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.FixReadsPhase;
import org.graalvm.compiler.phases.common.FloatingReadPhase;
import org.graalvm.compiler.phases.common.inlining.InliningUtil;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.phases.tiers.Suites;
import org.graalvm.compiler.phases.util.GraphOrder;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.nodes.MacroInvokable;
import org.graalvm.compiler.virtual.phases.ea.PartialEscapePhase;
import org.graalvm.compiler.virtual.phases.ea.ReadEliminationPhase;
import org.graalvm.nativeimage.ImageSingletons;

public class CompileQueue {
    protected final HostedUniverse universe;
    private final Boolean deoptimizeAll;
    protected CompletionExecutor executor;
    protected final ConcurrentMap<HostedMethod, CompileTask> compilations;
    protected final RuntimeConfiguration runtimeConfig;
    protected final MetaAccessProvider metaAccess;
    private Suites regularSuites = null;
    private Suites deoptTargetSuites = null;
    private LIRSuites regularLIRSuites = null;
    private LIRSuites deoptTargetLIRSuites = null;
    private final ConcurrentMap<Constant, DataSection.Data> dataCache;
    private SnippetReflectionProvider snippetReflection;
    private final FeatureHandler featureHandler;
    private final OptionValues compileOptions;
    private volatile boolean inliningProgress;
    private final boolean printMethodHistogram = NativeImageOptions.PrintMethodHistogram.getValue();
    private final boolean optionAOTTrivialInline = SubstrateOptions.AOTTrivialInline.getValue();
    private final boolean parseOnce = SubstrateOptions.parseOnce();

    public CompileQueue(DebugContext debug, FeatureHandler featureHandler, HostedUniverse universe, SharedRuntimeConfigurationBuilder runtimeConfigBuilder, Boolean deoptimizeAll, SnippetReflectionProvider snippetReflection, ForkJoinPool executorService) {
        this.universe = universe;
        this.compilations = new ConcurrentHashMap<HostedMethod, CompileTask>();
        this.runtimeConfig = runtimeConfigBuilder.getRuntimeConfig();
        this.metaAccess = runtimeConfigBuilder.metaAccess;
        this.deoptimizeAll = deoptimizeAll;
        this.dataCache = new ConcurrentHashMap<Constant, DataSection.Data>();
        this.executor = new CompletionExecutor((BigBang)universe.getBigBang(), executorService, universe.getBigBang().getHeartbeatCallback());
        this.featureHandler = featureHandler;
        this.snippetReflection = snippetReflection;
        this.compileOptions = this.getCustomizedOptions(debug);
        this.callForReplacements(debug, this.runtimeConfig);
    }

    public static OptimisticOptimizations getOptimisticOpts() {
        return OptimisticOptimizations.ALL.remove(new OptimisticOptimizations.Optimization[]{OptimisticOptimizations.Optimization.UseLoopLimitChecks});
    }

    protected void callForReplacements(DebugContext debug, RuntimeConfiguration runtimeConfig) {
        NativeImageGenerator.registerReplacements(debug, this.featureHandler, runtimeConfig, runtimeConfig.getProviders(), true, true);
    }

    public void finish(DebugContext debug) {
        ProgressReporter reporter = ProgressReporter.singleton();
        try {
            try (Object ac = reporter.printParsing();){
                this.parseAll();
            }
            UninterruptibleAnnotationChecker.checkBeforeCompilation(this.universe.getMethods());
            RestrictHeapAccessAnnotationChecker.check(debug, this.universe, this.universe.getMethods());
            for (HostedMethod method : this.universe.getMethods()) {
                method.wrapped.setAnalyzedGraph(null);
            }
            ac = reporter.printInlining();
            try {
                this.inlineTrivialMethods(debug);
            }
            finally {
                if (ac != null) {
                    ((ProgressReporter.ReporterClosable)ac).close();
                }
            }
            assert (this.suitesNotCreated());
            this.createSuites();
            ac = reporter.printCompiling();
            try {
                this.compileAll();
            }
            finally {
                if (ac != null) {
                    ((ProgressReporter.ReporterClosable)ac).close();
                }
            }
        }
        catch (InterruptedException ie) {
            throw new InterruptImageBuilding();
        }
        if (this.printMethodHistogram) {
            this.printMethodHistogram();
        }
    }

    private boolean suitesNotCreated() {
        return this.regularSuites == null && this.deoptTargetLIRSuites == null && this.regularLIRSuites == null && this.deoptTargetSuites == null;
    }

    private void createSuites() {
        this.regularSuites = NativeImageGenerator.createSuites(this.featureHandler, this.runtimeConfig, this.snippetReflection, true);
        this.modifyRegularSuites(this.regularSuites);
        this.deoptTargetSuites = NativeImageGenerator.createSuites(this.featureHandler, this.runtimeConfig, this.snippetReflection, true);
        this.removeDeoptTargetOptimizations(this.deoptTargetSuites);
        this.regularLIRSuites = NativeImageGenerator.createLIRSuites(this.featureHandler, this.runtimeConfig.getProviders(), true);
        this.deoptTargetLIRSuites = NativeImageGenerator.createLIRSuites(this.featureHandler, this.runtimeConfig.getProviders(), true);
        CompileQueue.removeDeoptTargetOptimizations(this.deoptTargetLIRSuites);
    }

    protected void modifyRegularSuites(Suites suites) {
    }

    protected PhaseSuite<HighTierContext> afterParseCanonicalization() {
        PhaseSuite phaseSuite = new PhaseSuite();
        phaseSuite.appendPhase((BasePhase)new ImplicitAssertionsPhase());
        phaseSuite.appendPhase((BasePhase)new DeadStoreRemovalPhase());
        phaseSuite.appendPhase((BasePhase)new DevirtualizeCallsPhase());
        phaseSuite.appendPhase((BasePhase)CanonicalizerPhase.create());
        phaseSuite.appendPhase((BasePhase)new StrengthenStampsPhase());
        phaseSuite.appendPhase((BasePhase)CanonicalizerPhase.create());
        phaseSuite.appendPhase((BasePhase)new OptimizeExceptionPathsPhase());
        if (((Boolean)ImageBuildStatistics.Options.CollectImageBuildStatistics.getValue(this.universe.hostVM().options())).booleanValue()) {
            phaseSuite.appendPhase((BasePhase)CanonicalizerPhase.create());
            phaseSuite.appendPhase((BasePhase)new ImageBuildStatisticsCounterPhase(ImageBuildStatistics.CheckCountLocation.AFTER_PARSE_CANONICALIZATION));
        }
        return phaseSuite;
    }

    public Map<HostedMethod, CompileTask> getCompilations() {
        return this.compilations;
    }

    public Collection<CompileTask> getCompilationTasks() {
        return this.compilations.values();
    }

    private void printMethodHistogram() {
        long sizeAllMethods = 0L;
        long sizeDeoptMethods = 0L;
        long sizeDeoptMethodsInNonDeopt = 0L;
        long sizeNonDeoptMethods = 0L;
        int numberOfMethods = 0;
        int numberOfNonDeopt = 0;
        int numberOfDeopt = 0;
        long totalNumDeoptEntryPoints = 0L;
        long totalNumDuringCallEntryPoints = 0L;
        System.out.format("Code Size; Nodes Parsing; Nodes Before; Nodes After; Is Trivial; Deopt Target; Code Size; Nodes Parsing; Nodes Before; Nodes After; Deopt Entries; Deopt During Call; Entry Points; Direct Calls; Virtual Calls; Method\n", new Object[0]);
        ArrayList tasks = new ArrayList(this.compilations.values());
        tasks.sort(Comparator.comparing(t2 -> t2.method.format("%H.%n(%p) %r")));
        for (CompileTask task : tasks) {
            HostedMethod method = task.method;
            CompilationResult result = task.result;
            CompilationInfo ci = method.compilationInfo;
            if (ci.isDeoptTarget()) continue;
            ++numberOfMethods;
            sizeAllMethods += (long)result.getTargetCodeSize();
            System.out.format("%8d; %5d; %5d; %5d; %s;", result.getTargetCodeSize(), ci.numNodesAfterParsing, ci.numNodesBeforeCompilation, ci.numNodesAfterCompilation, ci.isTrivialMethod ? "T" : " ");
            int deoptMethodSize = 0;
            if (ci.deoptTarget != null) {
                CompilationInfo dci = ci.deoptTarget.compilationInfo;
                ++numberOfDeopt;
                deoptMethodSize = ((CompileTask)this.compilations.get((Object)ci.deoptTarget)).result.getTargetCodeSize();
                sizeDeoptMethods += (long)deoptMethodSize;
                sizeDeoptMethodsInNonDeopt += (long)result.getTargetCodeSize();
                totalNumDeoptEntryPoints += dci.numDeoptEntryPoints;
                totalNumDuringCallEntryPoints += dci.numDuringCallEntryPoints;
                System.out.format(" D; %6d; %5d; %5d; %5d; %4d; %4d;", deoptMethodSize, dci.numNodesAfterParsing, dci.numNodesBeforeCompilation, dci.numNodesAfterCompilation, dci.numDeoptEntryPoints, dci.numDuringCallEntryPoints);
            } else {
                sizeNonDeoptMethods += (long)result.getTargetCodeSize();
                ++numberOfNonDeopt;
                System.out.format("  ; %6d; %5d; %5d; %5d; %4d; %4d;", 0, 0, 0, 0, 0, 0);
            }
            System.out.format(" %4d; %4d; %4d; %s%n", ci.numEntryPointCalls.get(), ci.numDirectCalls.get(), ci.numVirtualCalls.get(), method.format("%H.%n(%p) %r"));
        }
        System.out.println();
        System.out.println("Size all methods                           ; " + sizeAllMethods);
        System.out.println("Size deopt methods                         ; " + sizeDeoptMethods);
        System.out.println("Size deopt methods in non-deopt mode       ; " + sizeDeoptMethodsInNonDeopt);
        System.out.println("Size non-deopt method                      ; " + sizeNonDeoptMethods);
        System.out.println("Number of methods                          ; " + numberOfMethods);
        System.out.println("Number of non-deopt methods                ; " + numberOfNonDeopt);
        System.out.println("Number of deopt methods                    ; " + numberOfDeopt);
        System.out.println("Number of deopt entry points               ; " + totalNumDeoptEntryPoints);
        System.out.println("Number of deopt during calls entries       ; " + totalNumDuringCallEntryPoints);
    }

    protected void parseAll() throws InterruptedException {
        this.executor.init();
        this.parseDeoptimizationTargetMethods();
        this.parseAheadOfTimeCompiledMethods();
        this.executor.start();
        this.executor.complete();
        this.executor.shutdown();
    }

    private void parseAheadOfTimeCompiledMethods() {
        for (HostedMethod method : this.universe.getMethods()) {
            if (method.isEntryPoint() || CompilationInfoSupport.singleton().isForcedCompilation(method) || method.wrapped.isDirectRootMethod() && method.wrapped.isImplementationInvoked()) {
                this.ensureParsed(method, null, new EntryPointReason());
            }
            if (!method.wrapped.isVirtualRootMethod()) continue;
            for (HostedMethod impl : method.getImplementations()) {
                VMError.guarantee(impl.wrapped.isImplementationInvoked());
                this.ensureParsed(impl, null, new EntryPointReason());
            }
        }
        SubstrateForeignCallsProvider foreignCallsProvider = (SubstrateForeignCallsProvider)this.runtimeConfig.getProviders().getForeignCalls();
        for (SubstrateForeignCallLinkage linkage : foreignCallsProvider.getForeignCalls().values()) {
            HostedMethod method = (HostedMethod)linkage.getDescriptor().findMethod(this.runtimeConfig.getProviders().getMetaAccess());
            if (method.wrapped.isDirectRootMethod() && method.wrapped.isImplementationInvoked()) {
                this.ensureParsed(method, null, new EntryPointReason());
            }
            if (!method.wrapped.isVirtualRootMethod()) continue;
            for (HostedMethod impl : method.getImplementations()) {
                VMError.guarantee(impl.wrapped.isImplementationInvoked());
                this.ensureParsed(impl, null, new EntryPointReason());
            }
        }
    }

    private void parseDeoptimizationTargetMethods() {
        this.universe.getMethods().stream().filter(method -> CompilationInfoSupport.singleton().isDeoptTarget((ResolvedJavaMethod)method)).forEach(method -> this.ensureParsed(this.universe.createDeoptTarget((HostedMethod)method), null, new EntryPointReason()));
        this.universe.getMethods().stream().filter(method -> method.getWrapped().isImplementationInvoked() && this.canDeoptForTesting((HostedMethod)method)).forEach(this::ensureParsedForDeoptTesting);
    }

    private void ensureParsedForDeoptTesting(HostedMethod method) {
        method.compilationInfo.canDeoptForTesting = true;
        this.ensureParsed(this.universe.createDeoptTarget(method), null, new EntryPointReason());
    }

    protected void checkTrivial(HostedMethod method) {
        if (!method.compilationInfo.isTrivialMethod() && method.canBeInlined() && InliningUtilities.isTrivialMethod(method.compilationInfo.getGraph())) {
            method.compilationInfo.setTrivialMethod(true);
        }
    }

    protected void inlineTrivialMethods(DebugContext debug) throws InterruptedException {
        for (HostedMethod method2 : this.universe.getMethods()) {
            try {
                DebugContext.Scope s = debug.scope((Object)"InlineTrivial", (Object)method2.compilationInfo.getGraph(), (Object)method2, (Object)this);
                try {
                    if (method2.compilationInfo.getGraph() == null) continue;
                    this.checkTrivial(method2);
                }
                finally {
                    if (s == null) continue;
                    s.close();
                }
            }
            catch (Throwable e) {
                throw debug.handle(e);
            }
        }
        int round = 0;
        do {
            ProgressReporter.singleton().reportStageProgress();
            this.inliningProgress = false;
            try (Indent ignored = debug.logAndIndent("==== Trivial Inlining  round %d\n", ++round);){
                this.executor.init();
                this.universe.getMethods().stream().filter(method -> method.compilationInfo.getGraph() != null).forEach(method -> this.executor.execute((CompletionExecutor.DebugContextRunnable)new TrivialInlineTask((HostedMethod)method)));
                this.universe.getMethods().stream().map(method -> method.compilationInfo.getDeoptTargetMethod()).filter(Objects::nonNull).forEach(deoptTargetMethod -> this.executor.execute((CompletionExecutor.DebugContextRunnable)new TrivialInlineTask((HostedMethod)deoptTargetMethod)));
                this.executor.start();
                this.executor.complete();
                this.executor.shutdown();
            }
        } while (this.inliningProgress);
    }

    private void doInlineTrivial(DebugContext debug, HostedMethod method) {
        StructuredGraph graph = (StructuredGraph)method.compilationInfo.getGraph().copy(debug);
        try (DebugContext.Scope s = debug.scope((Object)"InlineTrivial", (Object)graph, (Object)method, (Object)this);){
            try (Indent in = debug.logAndIndent("do inline trivial in %s", (Object)method);){
                boolean inlined = false;
                for (Invoke invoke : graph.getInvokes()) {
                    if (invoke instanceof InvokeNode) {
                        throw VMError.shouldNotReachHere("Found InvokeNode without exception edge: invocation of " + invoke.callTarget().targetMethod().format("%H.%n(%p)") + " in " + (graph.method() == null ? graph.toString() : graph.method().format("%H.%n(%p)")));
                    }
                    if (invoke.getInlineControl() != Invoke.InlineControl.Normal) continue;
                    inlined |= this.tryInlineTrivial(graph, invoke, !inlined);
                }
                if (inlined) {
                    Providers providers = this.runtimeConfig.lookupBackend(method).getProviders();
                    CanonicalizerPhase.create().apply(graph, (Object)providers);
                    graph.minimizeSize();
                    method.compilationInfo.setGraph(graph);
                    this.checkTrivial(method);
                    this.inliningProgress = true;
                }
            }
            catch (Throwable ex) {
                GraalError error = ex instanceof GraalError ? (GraalError)ex : new GraalError(ex);
                error.addContext("method: " + method.format("%r %H.%n(%p)"));
                throw error;
            }
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
    }

    private boolean tryInlineTrivial(StructuredGraph graph, Invoke invoke, boolean firstInline) {
        HostedMethod singleCallee;
        if (invoke.getInvokeKind().isDirect() && this.makeInlineDecision(invoke, singleCallee = (HostedMethod)invoke.callTarget().targetMethod()) && InliningUtilities.recursionDepth(invoke, singleCallee) == 0) {
            if (firstInline) {
                graph.getDebug().dump(4, (Object)graph, "Before inlining");
            }
            InliningUtil.inline((Invoke)invoke, (StructuredGraph)singleCallee.compilationInfo.getGraph(), (boolean)true, (ResolvedJavaMethod)singleCallee);
            graph.getDebug().dump(4, (Object)graph, "After inlining %s with trivial callee %s", (Object)invoke, (Object)singleCallee.getQualifiedName());
            return true;
        }
        return false;
    }

    private boolean makeInlineDecision(Invoke invoke, HostedMethod callee) {
        if (!callee.canBeInlined() || callee.getAnnotation(NeverInlineTrivial.class) != null) {
            return false;
        }
        if (callee.shouldBeInlined() || CompileQueue.callerAnnotatedWith(invoke, AlwaysInlineAllCallees.class)) {
            return true;
        }
        if (this.optionAOTTrivialInline && callee.compilationInfo.isTrivialMethod()) {
            return true;
        }
        AlwaysInlineSelectCallees selectCallees = CompileQueue.getCallerAnnotation(invoke, AlwaysInlineSelectCallees.class);
        return selectCallees != null && Arrays.stream(selectCallees.callees()).anyMatch(c -> c.equals(callee.getQualifiedName()));
    }

    private static boolean mustNotAllocateCallee(HostedMethod method) {
        return ((RestrictHeapAccessCallees)ImageSingletons.lookup(RestrictHeapAccessCallees.class)).mustNotAllocate(method);
    }

    private static boolean mustNotAllocate(HostedMethod method) {
        RestrictHeapAccess annotation = method.getAnnotation(RestrictHeapAccess.class);
        return annotation != null && annotation.access() == RestrictHeapAccess.Access.NO_ALLOCATION;
    }

    public static boolean callerAnnotatedWith(Invoke invoke, Class<? extends Annotation> annotationClass) {
        return CompileQueue.getCallerAnnotation(invoke, annotationClass) != null;
    }

    private static <T extends Annotation> T getCallerAnnotation(Invoke invoke, Class<T> annotationClass) {
        for (FrameState state = invoke.stateAfter(); state != null; state = state.outerFrameState()) {
            assert (state.getMethod() != null) : state;
            Annotation annotation = state.getMethod().getAnnotation(annotationClass);
            if (annotation == null) continue;
            return (T)annotation;
        }
        return null;
    }

    protected void compileAll() throws InterruptedException {
        this.executor.init();
        this.scheduleEntryPoints();
        this.executor.start();
        this.executor.complete();
        this.executor.shutdown();
    }

    public void scheduleEntryPoints() {
        for (HostedMethod method : this.universe.getMethods()) {
            HostedMethod deoptTargetMethod;
            if (!this.ignoreEntryPoint(method) && (method.isEntryPoint() || CompilationInfoSupport.singleton().isForcedCompilation(method)) || method.wrapped.isDirectRootMethod() && method.wrapped.isImplementationInvoked()) {
                this.ensureCompiled(method, new EntryPointReason());
            }
            if (method.wrapped.isVirtualRootMethod()) {
                for (HostedMethod impl : method.getImplementations()) {
                    VMError.guarantee(impl.wrapped.isImplementationInvoked());
                    this.ensureCompiled(impl, new EntryPointReason());
                }
            }
            if ((deoptTargetMethod = method.compilationInfo.getDeoptTargetMethod()) == null) continue;
            this.ensureCompiled(deoptTargetMethod, new EntryPointReason());
        }
    }

    protected boolean ignoreEntryPoint(HostedMethod method) {
        return false;
    }

    protected void ensureParsed(HostedMethod method, HostedMethod callerMethod, CompileReason reason) {
        if (!NativeImageOptions.AllowFoldMethods.getValue().booleanValue() && method.getAnnotation(Fold.class) != null && !this.metaAccess.lookupJavaType(GeneratedFoldInvocationPlugin.class).isAssignableFrom((ResolvedJavaType)callerMethod.getDeclaringClass())) {
            throw VMError.shouldNotReachHere("Parsing method annotated with @" + Fold.class.getSimpleName() + ": " + method.format("%H.%n(%p)") + ". Make sure you have used Graal annotation processors on the parent-project of the method's declaring class.");
        }
        if (!method.compilationInfo.inParseQueue.getAndSet(true)) {
            this.executor.execute((CompletionExecutor.DebugContextRunnable)new ParseTask(method, reason));
        }
    }

    protected void doParse(DebugContext debug, ParseTask task) {
        ParseFunction fun = task.method.compilationInfo.getCustomParseFunction();
        if (fun == null) {
            fun = this::defaultParseFunction;
        }
        fun.parse(debug, task.method, task.reason, this.runtimeConfig);
    }

    private StructuredGraph transplantGraph(DebugContext debug, HostedMethod hMethod, CompileReason reason) {
        AnalysisMethod aMethod = hMethod.getWrapped();
        StructuredGraph aGraph = aMethod.getAnalyzedGraph();
        if (aGraph == null) {
            throw VMError.shouldNotReachHere("Method not parsed during static analysis: " + aMethod.format("%r %H.%n(%p)") + ". Reachable from: " + reason);
        }
        aMethod.setAnalyzedGraph(null);
        boolean trackNodeSourcePosition = (Boolean)GraalOptions.TrackNodeSourcePosition.getValue(this.compileOptions);
        StructuredGraph graph = aGraph.copy((ResolvedJavaMethod)this.universe.lookup((JavaMethod)aGraph.method()), this.compileOptions, debug, trackNodeSourcePosition);
        this.transplantEscapeAnalysisState(graph);
        IdentityHashMap<Object, Object> replacements = new IdentityHashMap<Object, Object>();
        for (Node node : graph.getNodes()) {
            NodeClass nodeClass = node.getNodeClass();
            for (int i = 0; i < nodeClass.getData().getCount(); ++i) {
                Object newValue;
                Object oldValue = nodeClass.getData().get((Object)node, i);
                if (oldValue == (newValue = CompileQueue.replaceAnalysisObjects(oldValue, node, replacements, this.universe))) continue;
                nodeClass.getData().putObjectChecked((Object)node, i, newValue);
            }
            if (trackNodeSourcePosition) {
                node.setNodeSourcePosition((NodeSourcePosition)CompileQueue.replaceAnalysisObjects(node.getNodeSourcePosition(), node, replacements, this.universe));
                continue;
            }
            node.clearNodeSourcePosition();
        }
        return graph;
    }

    public static Object replaceAnalysisObjects(Object obj, Node node, IdentityHashMap<Object, Object> replacements, HostedUniverse hUniverse) {
        Object newReplacement;
        if (obj == null) {
            return obj;
        }
        Object existingReplacement = replacements.get(obj);
        if (existingReplacement != null) {
            return existingReplacement;
        }
        if (obj instanceof Node) {
            throw VMError.shouldNotReachHere("Must not replace a Graal graph nodes, only data objects referenced from a node");
        }
        if (obj instanceof AnalysisType) {
            newReplacement = hUniverse.lookup((JavaType)((AnalysisType)obj));
        } else if (obj instanceof AnalysisMethod) {
            newReplacement = hUniverse.lookup((JavaMethod)((AnalysisMethod)obj));
        } else if (obj instanceof AnalysisField) {
            newReplacement = hUniverse.lookup((JavaField)((AnalysisField)obj));
        } else if (obj.getClass() == ObjectStamp.class) {
            ObjectStamp stamp = (ObjectStamp)obj;
            newReplacement = stamp.type() == null ? obj : new ObjectStamp((ResolvedJavaType)CompileQueue.replaceAnalysisObjects(stamp.type(), node, replacements, hUniverse), stamp.isExactType(), stamp.nonNull(), stamp.alwaysNull(), stamp.isAlwaysArray());
        } else if (obj.getClass() == SubstrateNarrowOopStamp.class) {
            SubstrateNarrowOopStamp stamp = (SubstrateNarrowOopStamp)((Object)obj);
            newReplacement = stamp.type() == null ? obj : new SubstrateNarrowOopStamp((ResolvedJavaType)CompileQueue.replaceAnalysisObjects(stamp.type(), node, replacements, hUniverse), stamp.isExactType(), stamp.nonNull(), stamp.alwaysNull(), stamp.isAlwaysArray(), stamp.getEncoding());
        } else if (obj.getClass() == PiNode.PlaceholderStamp.class) {
            assert (((PiNode.PlaceholderStamp)obj).type() == null) : "PlaceholderStamp never references a type";
            newReplacement = obj;
        } else {
            if (obj instanceof AbstractObjectStamp) {
                throw VMError.shouldNotReachHere("missing replacement of a subclass of AbstractObjectStamp: " + obj.getClass().getTypeName());
            }
            if (obj.getClass() == StampPair.class) {
                StampPair pair = (StampPair)obj;
                Stamp trustedStamp = (Stamp)CompileQueue.replaceAnalysisObjects(pair.getTrustedStamp(), node, replacements, hUniverse);
                Stamp uncheckedStamp = (Stamp)CompileQueue.replaceAnalysisObjects(pair.getUncheckedStamp(), node, replacements, hUniverse);
                newReplacement = trustedStamp != pair.getTrustedStamp() || uncheckedStamp != pair.getUncheckedStamp() ? StampPair.create((Stamp)trustedStamp, (Stamp)uncheckedStamp) : pair;
            } else if (obj.getClass() == ResolvedJavaMethodBytecode.class) {
                ResolvedJavaMethodBytecode bc = (ResolvedJavaMethodBytecode)obj;
                newReplacement = new ResolvedJavaMethodBytecode((ResolvedJavaMethod)hUniverse.lookup((JavaMethod)bc.getMethod()), bc.getOrigin());
            } else if (obj instanceof Object[]) {
                Object[] originalArray = (Object[])obj;
                Object[] copyArray = null;
                for (int i = 0; i < originalArray.length; ++i) {
                    Object original = originalArray[i];
                    Object replaced = CompileQueue.replaceAnalysisObjects(original, node, replacements, hUniverse);
                    if (replaced == original) continue;
                    if (copyArray == null) {
                        copyArray = Arrays.copyOf(originalArray, originalArray.length);
                    }
                    copyArray[i] = replaced;
                }
                newReplacement = copyArray != null ? copyArray : originalArray;
            } else if (obj.getClass() == NodeSourcePosition.class) {
                NodeSourcePosition nsp = (NodeSourcePosition)obj;
                NodeSourcePosition replacedCaller = (NodeSourcePosition)CompileQueue.replaceAnalysisObjects(nsp.getCaller(), node, replacements, hUniverse);
                ResolvedJavaMethod replacedMethod = (ResolvedJavaMethod)CompileQueue.replaceAnalysisObjects(nsp.getMethod(), node, replacements, hUniverse);
                newReplacement = new NodeSourcePosition(nsp.getSourceLanguage(), replacedCaller, replacedMethod, nsp.getBCI(), nsp.getMarker());
            } else if (obj.getClass() == BytecodePosition.class) {
                BytecodePosition nsp = (BytecodePosition)obj;
                BytecodePosition replacedCaller = (BytecodePosition)CompileQueue.replaceAnalysisObjects(nsp.getCaller(), node, replacements, hUniverse);
                ResolvedJavaMethod replacedMethod = (ResolvedJavaMethod)CompileQueue.replaceAnalysisObjects(nsp.getMethod(), node, replacements, hUniverse);
                newReplacement = new BytecodePosition(replacedCaller, replacedMethod, nsp.getBCI());
            } else if (obj.getClass() == SubstrateMethodPointerConstant.class) {
                SubstrateMethodPointerConstant methodPointerConstant = (SubstrateMethodPointerConstant)obj;
                MethodPointer methodPointer = methodPointerConstant.pointer();
                ResolvedJavaMethod method = methodPointer.getMethod();
                ResolvedJavaMethod replacedMethod = (ResolvedJavaMethod)CompileQueue.replaceAnalysisObjects(method, node, replacements, hUniverse);
                newReplacement = new SubstrateMethodPointerConstant(new MethodPointer(replacedMethod));
            } else {
                assert (!obj.getClass().getName().toLowerCase().contains("analysis")) : "Object " + obj + " of " + obj.getClass() + " in node " + node;
                assert (!obj.getClass().getName().toLowerCase().contains("pointsto")) : "Object " + obj + " of " + obj.getClass() + " in node " + node;
                newReplacement = obj;
            }
        }
        replacements.put(obj, newReplacement);
        return newReplacement;
    }

    protected void transplantEscapeAnalysisState(StructuredGraph graph) {
        ArrayList<ValueNode> aValues;
        List values;
        for (CommitAllocationNode node : graph.getNodes().filter(CommitAllocationNode.class)) {
            values = node.getValues();
            aValues = new ArrayList<ValueNode>(values);
            values.clear();
            int aObjectStartIndex = 0;
            for (VirtualObjectNode virtualObject : node.getVirtualObjects()) {
                this.transplantVirtualObjectState(virtualObject, aValues, values, aObjectStartIndex);
                aObjectStartIndex += virtualObject.entryCount();
            }
            assert (aValues.size() == aObjectStartIndex);
        }
        for (CommitAllocationNode node : graph.getNodes().filter(VirtualObjectState.class)) {
            values = node.values();
            aValues = new ArrayList(values);
            values.clear();
            this.transplantVirtualObjectState(node.object(), aValues, values, 0);
        }
        for (CommitAllocationNode node : graph.getNodes(VirtualInstanceNode.TYPE)) {
            AnalysisType aType = (AnalysisType)node.type();
            Object[] aFields = node.getFields();
            assert (Arrays.equals(aFields, aType.getInstanceFields(true)));
            HostedField[] hFields = this.universe.lookup((JavaType)aType).getInstanceFields(true);
            Fields nodeClassDataFields = node.getNodeClass().getData();
            for (int i = 0; i < nodeClassDataFields.getCount(); ++i) {
                if (nodeClassDataFields.get((Object)node, i) != aFields) continue;
                nodeClassDataFields.putObjectChecked((Object)node, i, (Object)hFields);
            }
        }
    }

    private void transplantVirtualObjectState(VirtualObjectNode virtualObject, List<ValueNode> aValues, List<ValueNode> hValues, int aObjectStartIndex) {
        AnalysisType aType = (AnalysisType)virtualObject.type();
        if (aType.isArray()) {
            for (int i = 0; i < virtualObject.entryCount(); ++i) {
                hValues.add(aValues.get(aObjectStartIndex + i));
            }
        } else {
            HostedField[] hFields;
            assert (virtualObject.entryCount() == aType.getInstanceFields(true).length);
            for (HostedField hField : hFields = this.universe.lookup((JavaType)aType).getInstanceFields(true)) {
                int aPosition = hField.wrapped.getPosition();
                assert (hField.wrapped.equals(aType.getInstanceFields(true)[aPosition]));
                hValues.add(aValues.get(aObjectStartIndex + aPosition));
            }
        }
    }

    private void defaultParseFunction(DebugContext debug, HostedMethod method, CompileReason reason, RuntimeConfiguration config) {
        StructuredGraph graph;
        if (method.getAnnotation(Node.NodeIntrinsic.class) != null) {
            throw VMError.shouldNotReachHere("Parsing method annotated with @" + Node.NodeIntrinsic.class.getSimpleName() + ": " + method.format("%H.%n(%p)") + ". Make sure you have used Graal annotation processors on the parent-project of the method's declaring class.");
        }
        HostedProviders providers = (HostedProviders)config.lookupBackend(method).getProviders();
        boolean needParsing = false;
        if (this.parseOnce) {
            graph = this.transplantGraph(debug, method, reason);
        } else {
            InvocationPlugin plugin;
            graph = method.buildGraph(debug, method, providers, GraphProvider.Purpose.AOT_COMPILATION);
            if (graph == null && (plugin = providers.getGraphBuilderPlugins().getInvocationPlugins().lookupInvocation((ResolvedJavaMethod)method, debug.getOptions())) != null && !plugin.inlineOnly()) {
                ResolvedJavaMethodBytecode code = new ResolvedJavaMethodBytecode((ResolvedJavaMethod)method);
                graph = new SubstrateIntrinsicGraphBuilder(this.compileOptions, debug, (CoreProviders)providers, (Bytecode)code).buildGraph(plugin);
            }
            if (graph == null && method.isNative() && NativeImageOptions.ReportUnsupportedElementsAtRuntime.getValue().booleanValue()) {
                graph = DeletedMethod.buildGraph(debug, method, providers, DeletedMethod.NATIVE_MESSAGE);
            }
            if (graph == null) {
                needParsing = true;
                graph = new StructuredGraph.Builder(this.compileOptions, debug).method((ResolvedJavaMethod)method).recordInlinedMethods(false).build();
            }
        }
        try (DebugContext.Scope s = debug.scope((Object)"Parsing", (Object)graph, (Object)method, (Object)this);){
            try {
                if (needParsing) {
                    GraphBuilderConfiguration gbConf = this.createHostedGraphBuilderConfiguration(providers, method);
                    new HostedGraphBuilderPhase((CoreProviders)providers, gbConf, CompileQueue.getOptimisticOpts(), null, providers.getWordTypes()).apply(graph);
                } else {
                    graph.setGuardsStage(StructuredGraph.GuardsStage.FIXED_DEOPTS);
                }
                method.compilationInfo.setGraph(graph);
                this.afterParse(method);
                PhaseSuite<HighTierContext> afterParseSuite = this.afterParseCanonicalization();
                afterParseSuite.apply(method.compilationInfo.graph, (Object)new HighTierContext((Providers)providers, afterParseSuite, CompileQueue.getOptimisticOpts()));
                assert (GraphOrder.assertSchedulableGraph((StructuredGraph)method.compilationInfo.getGraph()));
                graph.minimizeSize();
                method.compilationInfo.numNodesAfterParsing = graph.getNodeCount();
                if (!this.parseOnce) {
                    UninterruptibleAnnotationChecker.checkAfterParsing(method, graph);
                }
                for (Invoke invoke : graph.getInvokes()) {
                    if (!this.canBeUsedForInlining(invoke)) {
                        invoke.setUseForInlining(false);
                    }
                    CallTargetNode targetNode = invoke.callTarget();
                    this.ensureParsed(method, reason, targetNode, (HostedMethod)targetNode.targetMethod(), targetNode.invokeKind().isIndirect() || targetNode instanceof IndirectCallTargetNode);
                }
                for (Node n : graph.getNodes()) {
                    if (!(n instanceof MacroInvokable)) continue;
                    MacroInvokable macroNode = (MacroInvokable)n;
                    this.ensureParsed(method, reason, null, (HostedMethod)macroNode.getTargetMethod(), macroNode.getInvokeKind().isIndirect());
                }
            }
            catch (Throwable ex) {
                GraalError error = ex instanceof GraalError ? (GraalError)ex : new GraalError(ex);
                error.addContext("method: " + method.format("%r %H.%n(%p)"));
                throw error;
            }
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
    }

    private void ensureParsed(HostedMethod method, CompileReason reason, CallTargetNode targetNode, HostedMethod invokeTarget, boolean isIndirect) {
        if (isIndirect) {
            for (HostedMethod invokeImplementation : invokeTarget.getImplementations()) {
                CompileQueue.handleSpecialization(method, targetNode, invokeTarget, invokeImplementation);
                this.ensureParsed(invokeImplementation, method, new VirtualCallReason(method, invokeImplementation, reason));
            }
        } else if (invokeTarget.wrapped.isSimplyImplementationInvoked()) {
            CompileQueue.handleSpecialization(method, targetNode, invokeTarget, invokeTarget);
            this.ensureParsed(invokeTarget, method, new DirectCallReason(method, reason));
        }
    }

    protected void afterParse(HostedMethod method) {
    }

    protected OptionValues getCustomizedOptions(DebugContext debug) {
        return debug.getOptions();
    }

    protected GraphBuilderConfiguration createHostedGraphBuilderConfiguration(HostedProviders providers, HostedMethod method) {
        GraphBuilderConfiguration gbConf = GraphBuilderConfiguration.getDefault((GraphBuilderConfiguration.Plugins)providers.getGraphBuilderPlugins()).withBytecodeExceptionMode(GraphBuilderConfiguration.BytecodeExceptionMode.CheckAll);
        if (SubstrateOptions.optimizationLevel() == SubstrateOptions.OptimizationLevel.O0 && !method.isDeoptTarget()) {
            gbConf = gbConf.withRetainLocalVariables(true);
        }
        return gbConf;
    }

    protected boolean containsStackValueNode(HostedMethod method) {
        return this.universe.getBigBang().getHostVM().containsStackValueNode(method.wrapped);
    }

    protected boolean canBeUsedForInlining(Invoke invoke) {
        HostedMethod caller = (HostedMethod)invoke.asNode().graph().method();
        HostedMethod callee = (HostedMethod)invoke.callTarget().targetMethod();
        if (this.canDeoptForTesting(caller) && Modifier.isNative(callee.getModifiers())) {
            return false;
        }
        if (this.canDeoptForTesting(caller) && this.containsStackValueNode(callee)) {
            return false;
        }
        if (caller.compilationInfo.isDeoptTarget()) {
            if (caller.compilationInfo.isDeoptEntry(invoke.bci(), true, false)) {
                return false;
            }
            if (CompilationInfoSupport.singleton().isDeoptInliningExclude(callee)) {
                return false;
            }
        }
        if (callee.getAnnotation(Specialize.class) != null) {
            return false;
        }
        if (CompileQueue.callerAnnotatedWith(invoke, Specialize.class) && callee.getAnnotation(DeoptTest.class) != null) {
            return false;
        }
        if (!Uninterruptible.Utils.inliningAllowed((AnnotatedElement)((Object)caller), (AnnotatedElement)((Object)callee))) {
            return false;
        }
        if (!CompileQueue.mustNotAllocateCallee(caller) && CompileQueue.mustNotAllocate(callee)) {
            return false;
        }
        if (!callee.canBeInlined()) {
            return false;
        }
        return invoke.useForInlining();
    }

    private static void handleSpecialization(HostedMethod method, CallTargetNode targetNode, HostedMethod invokeTarget, HostedMethod invokeImplementation) {
        if (method.getAnnotation(Specialize.class) != null && !method.compilationInfo.isDeoptTarget() && invokeTarget.getAnnotation(DeoptTest.class) != null) {
            if (invokeImplementation.compilationInfo.specializedArguments != null) {
                VMError.shouldNotReachHere("Specialized method " + invokeImplementation.format("%H.%n(%p)") + " can only be called from one place");
            }
            invokeImplementation.compilationInfo.specializedArguments = new ConstantNode[targetNode.arguments().size()];
            int idx = 0;
            for (ValueNode argument : targetNode.arguments()) {
                if (!(argument instanceof ConstantNode)) {
                    VMError.shouldNotReachHere("Argument " + idx + " of specialized method " + invokeImplementation.format("%H.%n(%p)") + " is not constant");
                }
                invokeImplementation.compilationInfo.specializedArguments[idx++] = (ConstantNode)argument;
            }
        }
    }

    protected void ensureCompiled(HostedMethod method, CompileReason reason) {
        CompilationInfo compilationInfo = method.compilationInfo;
        if (this.printMethodHistogram) {
            if (reason instanceof DirectCallReason) {
                compilationInfo.numDirectCalls.incrementAndGet();
            } else if (reason instanceof VirtualCallReason) {
                compilationInfo.numVirtualCalls.incrementAndGet();
            } else if (reason instanceof EntryPointReason) {
                compilationInfo.numEntryPointCalls.incrementAndGet();
            }
        }
        if (compilationInfo.inCompileQueue) {
            return;
        }
        CompileTask task = new CompileTask(method, reason);
        CompileTask oldTask = this.compilations.putIfAbsent(method, task);
        if (oldTask != null) {
            return;
        }
        compilationInfo.inCompileQueue = true;
        if (compilationInfo.specializedArguments != null) {
            StructuredGraph graph = compilationInfo.graph;
            int idx = 0;
            for (ConstantNode argument : compilationInfo.specializedArguments) {
                ParameterNode local;
                if ((local = graph.getParameter(idx++)) == null) continue;
                local.replaceAndDelete((Node)ConstantNode.forConstant((JavaConstant)argument.asJavaConstant(), (MetaAccessProvider)this.runtimeConfig.getProviders().getMetaAccess(), (StructuredGraph)graph));
            }
        }
        this.executor.execute((CompletionExecutor.DebugContextRunnable)task);
        method.setCompiled();
    }

    protected CompilationResult doCompile(DebugContext debug, HostedMethod method, CompilationIdentifier compilationIdentifier, CompileReason reason) {
        CompileFunction fun = method.compilationInfo.getCustomCompileFunction();
        if (fun == null) {
            fun = this::defaultCompileFunction;
        }
        return fun.compile(debug, method, compilationIdentifier, reason, this.runtimeConfig);
    }

    private CompilationResult defaultCompileFunction(DebugContext debug, HostedMethod method, CompilationIdentifier compilationIdentifier, CompileReason reason, RuntimeConfiguration config) {
        CompilationResult compilationResult;
        block20: {
            if (NativeImageOptions.PrintAOTCompilation.getValue().booleanValue()) {
                System.out.println("Compiling " + method.format("%r %H.%n(%p)") + "  [" + reason + "]");
            }
            SubstrateBackend backend = config.lookupBackend(method);
            StructuredGraph graph = method.compilationInfo.graph;
            VMError.guarantee(graph != null, "The following method is reachable during compilation, but was not seen during Bytecode parsing: " + method);
            graph = graph.copyWithIdentifier(compilationIdentifier, debug);
            assert (GraphOrder.assertSchedulableGraph((StructuredGraph)graph));
            DebugContext.Scope s = debug.scope((Object)"Compiling", (Object)graph, (Object)method, (Object)this);
            try {
                if (this.deoptimizeAll.booleanValue() && method.compilationInfo.canDeoptForTesting) {
                    CompileQueue.insertDeoptTests(method, graph);
                }
                method.compilationInfo.numNodesBeforeCompilation = graph.getNodeCount();
                method.compilationInfo.numDeoptEntryPoints = graph.getNodes().filter(DeoptEntryNode.class).count();
                method.compilationInfo.numDuringCallEntryPoints = graph.getNodes(MethodCallTargetNode.TYPE).snapshot().stream().map(CallTargetNode::invoke).filter(invoke -> method.compilationInfo.isDeoptEntry(invoke.bci(), true, false)).count();
                Suites suites = method.compilationInfo.isDeoptTarget() ? this.deoptTargetSuites : this.regularSuites;
                LIRSuites lirSuites = method.compilationInfo.isDeoptTarget() ? this.deoptTargetLIRSuites : this.regularLIRSuites;
                CompilationResult result = backend.newCompilationResult(compilationIdentifier, method.format("%H.%n(%p)"));
                try (Indent indent = debug.logAndIndent("compile %s", (Object)method);){
                    GraalCompiler.compileGraph((StructuredGraph)graph, (ResolvedJavaMethod)method, (Providers)backend.getProviders(), (Backend)backend, null, (OptimisticOptimizations)CompileQueue.getOptimisticOpts(), (ProfilingInfo)method.getProfilingInfo(), (Suites)suites, (LIRSuites)lirSuites, (CompilationResult)result, (CompilationResultBuilderFactory)new HostedCompilationResultBuilderFactory(), (boolean)false);
                }
                method.compilationInfo.numNodesAfterCompilation = graph.getNodeCount();
                if (method.compilationInfo.isDeoptTarget()) assert (CompileQueue.verifyDeoptTarget(method, result));
                this.ensureCalleesCompiled(method, reason, result);
                if (result.getTargetCode().length > result.getTargetCodeSize()) {
                    result.setTargetCode(Arrays.copyOf(result.getTargetCode(), result.getTargetCodeSize()), result.getTargetCodeSize());
                }
                compilationResult = result;
                if (s == null) break block20;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable ex) {
                    GraalError error = ex instanceof GraalError ? (GraalError)ex : new GraalError(ex);
                    error.addContext("method: " + method.format("%r %H.%n(%p)") + "  [" + reason + "]");
                    throw error;
                }
            }
            s.close();
        }
        return compilationResult;
    }

    protected void ensureCalleesCompiled(HostedMethod method, CompileReason reason, CompilationResult result) {
        for (Infopoint infopoint : result.getInfopoints()) {
            if (!(infopoint instanceof Call)) continue;
            Call call = (Call)infopoint;
            HostedMethod callTarget = (HostedMethod)call.target;
            if (call.direct) {
                this.ensureCompiled(callTarget, new DirectCallReason(method, reason));
                continue;
            }
            if (callTarget == null || callTarget.getImplementations() == null) continue;
            for (HostedMethod impl : callTarget.getImplementations()) {
                this.ensureCompiled(impl, new VirtualCallReason(method, callTarget, reason));
            }
        }
        for (DataPatch dataPatch : result.getDataPatches()) {
            VMConstant constant;
            Reference reference = dataPatch.reference;
            if (!(reference instanceof ConstantReference) || !((constant = ((ConstantReference)reference).getConstant()) instanceof SubstrateMethodPointerConstant)) continue;
            MethodPointer pointer = ((SubstrateMethodPointerConstant)constant).pointer();
            ResolvedJavaMethod method1 = pointer.getMethod();
            HostedMethod hMethod = (HostedMethod)method1;
            this.ensureCompiled(hMethod, new MethodPointerConstantReason(method, hMethod, reason));
        }
    }

    protected void removeDeoptTargetOptimizations(Suites suites) {
        GraalConfiguration.hostedInstance().removeDeoptTargetOptimizations(suites);
        PhaseSuite highTier = suites.getHighTier();
        highTier.removePhase(PartialEscapePhase.class);
        highTier.removePhase(ReadEliminationPhase.class);
        highTier.removePhase(BoxNodeOptimizationPhase.class);
        PhaseSuite midTier = suites.getMidTier();
        midTier.removePhase(FloatingReadPhase.class);
        PhaseSuite lowTier = suites.getLowTier();
        ListIterator it = lowTier.findPhase(FixReadsPhase.class);
        if (it != null) {
            FixReadsPhase fixReads = (FixReadsPhase)it.previous();
            it.remove();
            boolean replaceInputsWithConstants = false;
            it.add(new FixReadsPhase(replaceInputsWithConstants, fixReads.getSchedulePhase(), fixReads.getCanonicalizerPhase()));
        }
    }

    private static void removeDeoptTargetOptimizations(LIRSuites lirSuites) {
        ListIterator it = lirSuites.getPostAllocationOptimizationStage().findPhase(RedundantMoveElimination.class);
        if (it != null) {
            it.remove();
        }
        ((RegisterAllocationPhase)lirSuites.getAllocationStage().findPhaseInstance(RegisterAllocationPhase.class)).setNeverSpillConstants(true);
    }

    private static boolean verifyDeoptTarget(HostedMethod method, CompilationResult result) {
        HashMap<Long, BytecodeFrame> encodedBciMap = new HashMap<Long, BytecodeFrame>();
        assert (method.compilationInfo.graph != null) : "Deopt target must have a graph.";
        assert (method.compilationInfo.graph.getNodes(StackValueNode.TYPE).isEmpty()) : "No stack value nodes must be present in deopt target.";
        for (Infopoint infopoint : result.getInfopoints()) {
            long encodedBci;
            BytecodeFrame topFrame;
            DebugInfo debugInfo;
            if (infopoint.debugInfo == null || !(debugInfo = infopoint.debugInfo).hasFrame()) continue;
            BytecodeFrame rootFrame = topFrame = debugInfo.frame();
            while (rootFrame.caller() != null) {
                rootFrame = rootFrame.caller();
            }
            assert (rootFrame.getMethod().equals(method));
            boolean isDeoptEntry = method.compilationInfo.isDeoptEntry(rootFrame.getBCI(), rootFrame.duringCall, rootFrame.rethrowException);
            if (infopoint instanceof DeoptEntryInfopoint) {
                assert (isDeoptEntry);
            } else {
                if (!rootFrame.duringCall || !isDeoptEntry) continue;
                assert (infopoint instanceof Call || CompileQueue.isSingleSteppingInfopoint(infopoint));
            }
            if (encodedBciMap.containsKey(encodedBci = FrameInfoEncoder.encodeBci(rootFrame.getBCI(), rootFrame.duringCall, rootFrame.rethrowException))) assert (((BytecodeFrame)encodedBciMap.get(encodedBci)).equals((Object)rootFrame)) : "duplicate encoded bci " + encodedBci + " in deopt target " + method + " with different debug info:\n\n" + rootFrame + "\n\n" + encodedBciMap.get(encodedBci);
            encodedBciMap.put(encodedBci, rootFrame);
        }
        return true;
    }

    private static boolean isSingleSteppingInfopoint(Infopoint infopoint) {
        return infopoint.reason == InfopointReason.METHOD_START || infopoint.reason == InfopointReason.METHOD_END || infopoint.reason == InfopointReason.BYTECODE_POSITION;
    }

    protected boolean canDeoptForTesting(HostedMethod method) {
        if (method.getName().equals("<clinit>")) {
            return false;
        }
        if (method.getAnnotation(DeoptTest.class) != null) {
            return true;
        }
        if (method.isEntryPoint()) {
            return false;
        }
        if (method.isNative()) {
            return false;
        }
        if (method.wrapped.isIntrinsicMethod()) {
            return false;
        }
        if (Uninterruptible.Utils.isUninterruptible((AnnotatedElement)((Object)method))) {
            return false;
        }
        if (method.getAnnotation(RestrictHeapAccess.class) != null) {
            return false;
        }
        if (StubCallingConvention.Utils.hasStubCallingConvention(method)) {
            return false;
        }
        if (this.containsStackValueNode(method)) {
            return false;
        }
        if (this.deoptimizeAll.booleanValue()) {
            String className = method.getDeclaringClass().getName();
            if (className.contains("/svm/core/code/CodeInfoEncoder") || className.contains("com/oracle/svm/core/thread/JavaThreads") || className.contains("com/oracle/svm/core/thread/PlatformThreads") || className.contains("com/oracle/svm/core/heap/") || className.contains("com/oracle/svm/core/genscavenge/") || className.contains("com/oracle/svm/core/thread/VMOperationControl") || className.contains("debug/internal/DebugValueMap") && method.getName().equals("registerTopLevel")) {
                return false;
            }
            return method.getCode() != null;
        }
        return false;
    }

    private static void insertDeoptTests(HostedMethod method, StructuredGraph graph) {
        for (Node node : graph.getNodes()) {
            if (!(node instanceof FixedWithNextNode) || !(node instanceof StateSplit) || node instanceof InvokeNode || node instanceof ForeignCallNode || node instanceof DeoptTestNode || method.isSynchronized() && node instanceof StartNode) continue;
            FixedWithNextNode fixedWithNext = (FixedWithNextNode)node;
            FixedNode next = fixedWithNext.next();
            DeoptTestNode testNode = (DeoptTestNode)graph.add((Node)new DeoptTestNode());
            fixedWithNext.setNext(null);
            testNode.setNext(next);
            fixedWithNext.setNext((FixedNode)testNode);
            if (((StateSplit)node).hasSideEffect() && ((StateSplit)node).stateAfter() != null) {
                testNode.setStateAfter(((StateSplit)node).stateAfter().duplicateWithVirtualState());
                continue;
            }
            testNode.setStateAfter(GraphUtil.findLastFrameState((FixedNode)((FixedNode)node)).duplicateWithVirtualState());
        }
    }

    public Map<HostedMethod, CompilationResult> getCompilationResults() {
        TreeMap<HostedMethod, CompilationResult> result = new TreeMap<HostedMethod, CompilationResult>();
        for (Map.Entry entry : this.compilations.entrySet()) {
            result.put((HostedMethod)entry.getKey(), ((CompileTask)entry.getValue()).result);
        }
        return result;
    }

    public Suites getRegularSuites() {
        return this.regularSuites;
    }

    class HostedCompilationResultBuilderFactory
    implements CompilationResultBuilderFactory {
        HostedCompilationResultBuilderFactory() {
        }

        public CompilationResultBuilder createBuilder(CodeGenProviders providers, FrameMap frameMap, Assembler asm, DataBuilder dataBuilder, FrameContext frameContext, OptionValues options, DebugContext debug, CompilationResult compilationResult, Register uncompressedNullRegister) {
            return new CompilationResultBuilder(providers, frameMap, asm, dataBuilder, frameContext, options, debug, compilationResult, uncompressedNullRegister, EconomicMap.wrapMap(CompileQueue.this.dataCache));
        }
    }

    public class ParseTask
    implements Task {
        protected final CompileReason reason;
        private final HostedMethod method;
        private final DebugContext.Description description;

        public ParseTask(HostedMethod method, CompileReason reason) {
            this.method = method;
            this.reason = reason;
            this.description = new DebugContext.Description((Object)method, method.getName());
        }

        public void run(DebugContext debug) {
            CompileQueue.this.doParse(debug, this);
        }

        public DebugContext.Description getDescription() {
            return this.description;
        }
    }

    protected class TrivialInlineTask
    implements Task {
        private final HostedMethod method;
        private final DebugContext.Description description;

        TrivialInlineTask(HostedMethod method) {
            this.method = method;
            this.description = new DebugContext.Description((Object)method, method.getName());
        }

        public void run(DebugContext debug) {
            CompileQueue.this.doInlineTrivial(debug, this.method);
        }

        public DebugContext.Description getDescription() {
            return this.description;
        }
    }

    public class CompileTask
    implements Task {
        public final HostedMethod method;
        protected final CompileReason reason;
        public CompilationResult result;
        public final CompilationIdentifier compilationIdentifier;

        public CompileTask(HostedMethod method, CompileReason reason) {
            this.method = method;
            this.reason = reason;
            this.compilationIdentifier = new SubstrateHostedCompilationIdentifier(method);
        }

        public void run(DebugContext debug) {
            if (this.method.compilationInfo.graph != null) {
                this.method.compilationInfo.graph.resetDebug(debug);
            }
            this.result = CompileQueue.this.doCompile(debug, this.method, this.compilationIdentifier, this.reason);
        }

        public DebugContext.Description getDescription() {
            return new DebugContext.Description((Object)this.method, this.compilationIdentifier.toString(CompilationIdentifier.Verbosity.ID));
        }

        public CompileReason getReason() {
            return this.reason;
        }
    }

    private static interface Task
    extends CompletionExecutor.DebugContextRunnable {
        default public DebugContext getDebug(OptionValues options, List<DebugHandlersFactory> factories) {
            return new DebugContext.Builder(options, factories).description(this.getDescription()).build();
        }
    }

    public static class MethodPointerConstantReason
    extends CompileReason {
        private final HostedMethod owner;
        private final HostedMethod callTarget;

        public MethodPointerConstantReason(HostedMethod owner, HostedMethod callTarget, CompileReason prevReason) {
            super(prevReason);
            this.owner = owner;
            this.callTarget = callTarget;
        }

        public String toString() {
            return "Method " + this.callTarget.format("%r %h.%n(%p)") + " is reachable through a method pointer from " + this.owner.format("%r %h.%n(%p)");
        }
    }

    public static class VirtualCallReason
    extends CompileReason {
        private final HostedMethod caller;
        private final HostedMethod callTarget;

        public VirtualCallReason(HostedMethod caller, HostedMethod callTarget, CompileReason prevReason) {
            super(prevReason);
            this.caller = caller;
            this.callTarget = callTarget;
        }

        public String toString() {
            return "Virtual call from " + this.caller.format("%r %h.%n(%p)") + ", callTarget " + this.callTarget.format("%r %h.%n(%p)");
        }
    }

    public static class DirectCallReason
    extends CompileReason {
        private final HostedMethod caller;

        public DirectCallReason(HostedMethod caller, CompileReason prevReason) {
            super(prevReason);
            this.caller = caller;
        }

        public String toString() {
            return "Direct call from " + this.caller.format("%r %h.%n(%p)");
        }
    }

    public static class EntryPointReason
    extends CompileReason {
        public EntryPointReason() {
            super(null);
        }

        public String toString() {
            return "entry point";
        }
    }

    public static abstract class CompileReason {
        private final CompileReason prevReason;

        public CompileReason(CompileReason prevReason) {
            this.prevReason = prevReason;
        }
    }

    public static interface CompileFunction {
        public CompilationResult compile(DebugContext var1, HostedMethod var2, CompilationIdentifier var3, CompileReason var4, RuntimeConfiguration var5);
    }

    public static interface ParseFunction {
        public void parse(DebugContext var1, HostedMethod var2, CompileReason var3, RuntimeConfiguration var4);
    }
}

