/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.serialize.hosted;

import com.oracle.svm.hosted.ConfigurationTypeResolver;
import com.oracle.svm.reflect.serialize.hosted.SerializationFeature;
import java.util.HashMap;
import java.util.Map;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeSerializationSupport;

final class SerializationDenyRegistry
implements RuntimeSerializationSupport {
    private final Map<Class<?>, Boolean> deniedClasses = new HashMap();
    private final ConfigurationTypeResolver typeResolver;

    SerializationDenyRegistry(ConfigurationTypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    public void registerIncludingAssociatedClasses(ConfigurationCondition condition, Class<?> clazz) {
        this.register(condition, clazz);
    }

    public void register(ConfigurationCondition condition, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            this.registerWithTargetConstructorClass(condition, clazz, null);
        }
    }

    public void registerWithTargetConstructorClass(ConfigurationCondition condition, String className, String customTargetConstructorClassName) {
        this.registerWithTargetConstructorClass(condition, this.typeResolver.resolveType(className), null);
    }

    public void registerWithTargetConstructorClass(ConfigurationCondition condition, Class<?> clazz, Class<?> customTargetConstructorClazz) {
        if (clazz != null) {
            this.deniedClasses.put(clazz, true);
        }
    }

    public void registerLambdaCapturingClass(ConfigurationCondition condition, String lambdaCapturingClassName) {
        Class<?> lambdaCapturingClass = this.typeResolver.resolveType(lambdaCapturingClassName);
        if (lambdaCapturingClass != null) {
            this.deniedClasses.put(lambdaCapturingClass, true);
        }
    }

    public boolean isAllowed(Class<?> clazz) {
        boolean denied = this.deniedClasses.containsKey(clazz);
        if (denied && this.deniedClasses.get(clazz).booleanValue()) {
            this.deniedClasses.put(clazz, false);
            SerializationFeature.println("Warning: Serialization deny list contains " + clazz.getName() + ". Image will not support serialization/deserialization of this class.");
        }
        return !denied;
    }
}

