/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.serialize.hosted;

import com.oracle.graal.pointsto.phases.NoClassInitializationPlugin;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.configure.ConfigurationFile;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.configure.SerializationConfigurationParser;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ConfigurationTypeResolver;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.config.ConfigurationParserUtils;
import com.oracle.svm.reflect.hosted.ReflectionFeature;
import com.oracle.svm.reflect.serialize.hosted.SerializationBuilder;
import com.oracle.svm.reflect.serialize.hosted.SerializationDenyRegistry;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.graphbuilderconf.ClassInitializationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.replacements.MethodHandlePlugin;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.RuntimeSerializationSupport;

@AutomaticFeature
public class SerializationFeature
implements Feature {
    static final HashSet<Class<?>> capturingClasses = new HashSet();
    private SerializationBuilder serializationBuilder;
    private int loadedConfigurations;

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Collections.singletonList(ReflectionFeature.class);
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        ImageClassLoader imageClassLoader = access.getImageClassLoader();
        ConfigurationTypeResolver typeResolver = new ConfigurationTypeResolver("serialization configuration", imageClassLoader);
        SerializationDenyRegistry serializationDenyRegistry = new SerializationDenyRegistry(typeResolver);
        this.serializationBuilder = new SerializationBuilder(serializationDenyRegistry, access, typeResolver);
        ImageSingletons.add(RuntimeSerializationSupport.class, (Object)this.serializationBuilder);
        SerializationConfigurationParser denyCollectorParser = new SerializationConfigurationParser(serializationDenyRegistry, ConfigurationFiles.Options.StrictConfiguration.getValue());
        ConfigurationParserUtils.parseAndRegisterConfigurations(denyCollectorParser, imageClassLoader, "serialization", ConfigurationFiles.Options.SerializationDenyConfigurationFiles, ConfigurationFiles.Options.SerializationDenyConfigurationResources, ConfigurationFile.SERIALIZATION_DENY.getFileName());
        SerializationConfigurationParser parser = new SerializationConfigurationParser(this.serializationBuilder, ConfigurationFiles.Options.StrictConfiguration.getValue());
        this.loadedConfigurations = ConfigurationParserUtils.parseAndRegisterConfigurations(parser, imageClassLoader, "serialization", ConfigurationFiles.Options.SerializationConfigurationFiles, ConfigurationFiles.Options.SerializationConfigurationResources, ConfigurationFile.SERIALIZATION.getFileName());
    }

    private static GraphBuilderConfiguration buildLambdaParserConfig() {
        GraphBuilderConfiguration.Plugins plugins = new GraphBuilderConfiguration.Plugins(new InvocationPlugins());
        plugins.setClassInitializationPlugin((ClassInitializationPlugin)new NoClassInitializationPlugin());
        plugins.prependNodePlugin((NodePlugin)new MethodHandlePlugin(GraalAccess.getOriginalProviders().getConstantReflection().getMethodHandleAccess(), false));
        return GraphBuilderConfiguration.getDefault((GraphBuilderConfiguration.Plugins)plugins).withEagerResolving(true);
    }

    private static StructuredGraph createMethodGraph(ResolvedJavaMethod method, GraphBuilderPhase lambdaParserPhase, DebugContext debug) {
        StructuredGraph graph = new StructuredGraph.Builder(debug.getOptions(), debug).method(method).recordInlinedMethods(false).build();
        try (DebugContext.Scope ignored = debug.scope((Object)"ParsingToMaterializeLambdas");){
            HighTierContext context = new HighTierContext(GraalAccess.getOriginalProviders(), null, OptimisticOptimizations.NONE);
            lambdaParserPhase.apply(graph, (Object)context);
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
        return graph;
    }

    private static Class<?> getLambdaClassFromMemberField(Constant constant) {
        ResolvedJavaType constantType = GraalAccess.getOriginalProviders().getMetaAccess().lookupJavaType((JavaConstant)constant);
        if (constantType == null) {
            return null;
        }
        ResolvedJavaField[] fields = constantType.getInstanceFields(true);
        ResolvedJavaField targetField = null;
        for (ResolvedJavaField field : fields) {
            if (!field.getName().equals("member")) continue;
            targetField = field;
            break;
        }
        if (targetField == null) {
            return null;
        }
        HotSpotObjectConstant fieldValue = (HotSpotObjectConstant)GraalAccess.getOriginalProviders().getConstantReflection().readFieldValue(targetField, (JavaConstant)constant);
        Member memberField = (Member)GraalAccess.getOriginalProviders().getSnippetReflection().asObject(Member.class, (JavaConstant)fieldValue);
        return memberField.getDeclaringClass();
    }

    private static Class<?> getLambdaClassFromConstantNode(ConstantNode constantNode) {
        Constant constant = constantNode.getValue();
        Class<?> lambdaClass = SerializationFeature.getLambdaClassFromMemberField(constant);
        if (lambdaClass == null) {
            return null;
        }
        return lambdaClass.getName().contains("$$Lambda$") ? lambdaClass : null;
    }

    private static void registerLambdasFromConstantNodesInGraph(StructuredGraph graph) {
        NodeIterable constantNodes = ConstantNode.getConstantNodes((StructuredGraph)graph);
        for (ConstantNode cNode : constantNodes) {
            Class<?> lambdaClass = SerializationFeature.getLambdaClassFromConstantNode(cNode);
            if (lambdaClass == null) continue;
            try {
                Method serializeLambdaMethod = lambdaClass.getDeclaredMethod("writeReplace", new Class[0]);
                RuntimeReflection.register((Executable[])new Executable[]{serializeLambdaMethod});
            }
            catch (NoSuchMethodException e) {
                throw VMError.shouldNotReachHere("Serializable lambda class must contain the writeReplace method.");
            }
        }
    }

    private static void registerLambdasFromMethod(ResolvedJavaMethod method, DebugContext debug) {
        GraphBuilderPhase lambdaParserPhase = new GraphBuilderPhase(SerializationFeature.buildLambdaParserConfig());
        StructuredGraph graph = SerializationFeature.createMethodGraph(method, lambdaParserPhase, debug);
        SerializationFeature.registerLambdasFromConstantNodesInGraph(graph);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        FeatureImpl.BeforeAnalysisAccessImpl impl = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        for (Class<?> clazz : capturingClasses) {
            ResolvedJavaType clazzType = GraalAccess.getOriginalProviders().getMetaAccess().lookupJavaType(clazz);
            ArrayList<ResolvedJavaMethod> allMethods = new ArrayList<ResolvedJavaMethod>(Arrays.asList(clazzType.getDeclaredMethods()));
            allMethods.addAll(Arrays.asList(clazzType.getDeclaredConstructors()));
            for (ResolvedJavaMethod method : allMethods) {
                if (method.getCode() == null) continue;
                SerializationFeature.registerLambdasFromMethod(method, impl.getDebugContext());
            }
        }
        this.serializationBuilder.flushConditionalConfiguration(access);
        ((FeatureImpl.BeforeAnalysisAccessImpl)access).ensureInitialized("java.io.ObjectInputStream");
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        this.serializationBuilder.flushConditionalConfiguration(access);
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.serializationBuilder.afterAnalysis();
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        FallbackFeature.FallbackImageRequest serializationFallback;
        if (ImageSingletons.contains(FallbackFeature.class) && (serializationFallback = ((FallbackFeature)ImageSingletons.lookup(FallbackFeature.class)).serializationFallback) != null && this.loadedConfigurations == 0) {
            throw serializationFallback;
        }
    }

    static void println(String str) {
        System.out.println(str);
    }

    static void warn(String str) {
        System.err.println("Warning:" + str);
    }
}

