/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateDiagnostics;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.APIOptionGroup;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.option.ImmutableRuntimeOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.util.UserError;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Predicate;
import jdk.internal.misc.Unsafe;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.SpectrePHTMitigations;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class SubstrateOptions {
    public static final HostedOptionKey<Boolean> ParseOnce = new HostedOptionKey<Boolean>(true);
    public static final HostedOptionKey<Boolean> SourceLevelDebug = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<LocatableMultiOptionValue.Strings> SourceLevelDebugFilter = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());
    public static final HostedOptionKey<String> Module = new HostedOptionKey<String>("");
    public static final HostedOptionKey<String> Class = new HostedOptionKey<String>("");
    public static final HostedOptionKey<String> Method = new HostedOptionKey<String>("main");
    @APIOption(name={"-o"}, valueSeparator={32})
    public static final HostedOptionKey<String> Name = new HostedOptionKey<String>("");
    @APIOption(name={"shared"})
    public static final HostedOptionKey<Boolean> SharedLibrary = new HostedOptionKey<Boolean>(false);
    @APIOption(name={"static"})
    public static final HostedOptionKey<Boolean> StaticExecutable = new HostedOptionKey<Boolean>(false);
    @APIOption(name={"target"})
    public static final HostedOptionKey<String> TargetPlatform = new HostedOptionKey<String>(""){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, String oldValue, String newValue) {
            String updatedNewValue = newValue.equals("macos") ? "darwin" : newValue;
            super.onValueUpdate(values, (Object)oldValue, (Object)updatedNewValue);
        }
    };
    public static final HostedOptionKey<Boolean> StaticExecutableWithDynamicLibC = new HostedOptionKey<Boolean>(Boolean.valueOf(false)){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
            StaticExecutable.update(values, true);
            super.onValueUpdate(values, (Object)oldValue, (Object)newValue);
        }
    };
    public static final HostedOptionKey<Boolean> SupportContinuations = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<Boolean> UseLoom = new HostedOptionKey<Boolean>(Boolean.valueOf(false)){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
            if (newValue.booleanValue()) {
                SupportContinuations.update(values, true);
            }
        }
    };
    public static final int ForceFallback = 10;
    public static final int Automatic = 5;
    public static final int NoFallback = 0;
    public static final String OptionNameForceFallback = "force-fallback";
    public static final String OptionNameAutoFallback = "auto-fallback";
    public static final String OptionNameNoFallback = "no-fallback";
    @APIOption.List(value={@APIOption(name={"force-fallback"}, fixedValue={"10"}, customHelp="force building of fallback image"), @APIOption(name={"auto-fallback"}, fixedValue={"5"}, customHelp="build stand-alone image if possible"), @APIOption(name={"no-fallback"}, fixedValue={"0"}, customHelp="build stand-alone image or report failure")})
    public static final HostedOptionKey<Integer> FallbackThreshold = new HostedOptionKey<Integer>(5);
    public static final String IMAGE_CLASSPATH_PREFIX = "-imagecp";
    public static final String IMAGE_MODULEPATH_PREFIX = "-imagemp";
    public static final String WATCHPID_PREFIX = "-watchpid";
    private static ValueUpdateHandler<OptimizationLevel> optimizeValueUpdateHandler;
    private static ValueUpdateHandler<Integer> debugInfoValueUpdateHandler;
    public static final HostedOptionKey<String> Optimize;
    public static final HostedOptionKey<Boolean> IncludeNodeSourcePositions;
    public static final HostedOptionKey<LocatableMultiOptionValue.Strings> CLibraryPath;
    public static final HostedOptionKey<LocatableMultiOptionValue.Strings> LinkerRPath;
    public static final HostedOptionKey<String> Path;
    @APIOption(name={"serial"}, group=GCGroup.class, customHelp="Serial garbage collector")
    public static final HostedOptionKey<Boolean> UseSerialGC;
    @APIOption(name={"epsilon"}, group=GCGroup.class, customHelp="Epsilon garbage collector")
    public static final HostedOptionKey<Boolean> UseEpsilonGC;
    public static final RuntimeOptionKey<Long> StackSize;
    public static final HostedOptionKey<Long> InternalThreadStackSize;
    public static final RuntimeOptionKey<Integer> MaxJavaStackTraceDepth;
    public static final RuntimeOptionKey<Long> MaxDirectMemorySize;
    public static final HostedOptionKey<Boolean> VerifyNamingConventions;
    public static final HostedOptionKey<Boolean> MultiThreaded;
    public static final HostedOptionKey<Boolean> ForceNoROSectionRelocations;
    public static final HostedOptionKey<Boolean> SpawnIsolates;
    public static final HostedOptionKey<Boolean> TraceVMOperations;
    @APIOption(name={"trace-class-initialization"})
    public static final HostedOptionKey<String> TraceClassInitialization;
    @APIOption(name={"trace-object-instantiation"})
    public static final HostedOptionKey<String> TraceObjectInstantiation;
    public static final HostedOptionKey<Boolean> TraceNativeToolUsage;
    public static final HostedOptionKey<String> EntryPointNamePrefix;
    public static final HostedOptionKey<String> APIFunctionPrefix;
    @APIOption.List(value={@APIOption(name={"enable-http"}, fixedValue={"http"}, customHelp="enable http support in the generated image"), @APIOption(name={"enable-https"}, fixedValue={"https"}, customHelp="enable https support in the generated image"), @APIOption(name={"enable-url-protocols"})})
    public static final HostedOptionKey<LocatableMultiOptionValue.Strings> EnableURLProtocols;
    public static final HostedOptionKey<LocatableMultiOptionValue.Strings> DisableURLProtocols;
    @APIOption(name={"enable-all-security-services"})
    public static final HostedOptionKey<Boolean> EnableAllSecurityServices;
    public static final HostedOptionKey<Boolean> JNI;
    public static final HostedOptionKey<Boolean> JNIVerboseLookupErrors;
    public static final HostedOptionKey<Boolean> JNIExportSymbols;
    public static final HostedOptionKey<Integer> CodeAlignment;
    public static final HostedOptionKey<Boolean> BuildOutputUseNewStyle;
    public static final HostedOptionKey<Boolean> BuildOutputPrefix;
    public static final HostedOptionKey<Boolean> BuildOutputColorful;
    public static final HostedOptionKey<Boolean> BuildOutputLinks;
    public static final HostedOptionKey<Boolean> BuildOutputProgress;
    public static final HostedOptionKey<Boolean> BuildOutputBreakdowns;
    public static final HostedOptionKey<Boolean> BuildOutputGCWarnings;
    public static final HostedOptionKey<Integer> AllocatePrefetchLines;
    public static final HostedOptionKey<Integer> AllocateInstancePrefetchLines;
    public static final HostedOptionKey<Integer> AllocatePrefetchStyle;
    public static final HostedOptionKey<Integer> AllocatePrefetchInstr;
    public static final HostedOptionKey<Integer> AllocatePrefetchDistance;
    public static final HostedOptionKey<Integer> AllocatePrefetchStepSize;
    public static final RuntimeOptionKey<Long> TearDownWarningNanos;
    public static final RuntimeOptionKey<Long> TearDownFailureNanos;
    public static final HostedOptionKey<Integer> MaxUnrolledObjectZeroingStores;
    public static final HostedOptionKey<Boolean> StackTrace;
    public static final HostedOptionKey<Boolean> ParseRuntimeOptions;
    public static final HostedOptionKey<Boolean> EnableWildcardExpansion;
    static final HostedOptionKey<Boolean> AOTInline;
    public static final HostedOptionKey<Boolean> AOTTrivialInline;
    public static final HostedOptionKey<LocatableMultiOptionValue.Strings> NeverInline;
    public static final HostedOptionKey<Integer> MaxNodesInTrivialMethod;
    public static final HostedOptionKey<Integer> MaxInvokesInTrivialMethod;
    public static final HostedOptionKey<Integer> MaxNodesInTrivialLeafMethod;
    public static final HostedOptionKey<Boolean> PreserveFramePointer;
    public static final HostedOptionKey<Boolean> UseCalleeSavedRegisters;
    public static final HostedOptionKey<Boolean> UseCompressedFrameEncodings;
    public static final HostedOptionKey<LocatableMultiOptionValue.Strings> ReportAnalysisForbiddenType;
    public static final HostedOptionKey<String> CompilerBackend;
    public static final HostedOptionKey<Boolean> RemoveUnusedSymbols;
    public static final HostedOptionKey<Boolean> DeleteLocalSymbols;
    public static final HostedOptionKey<Boolean> InternalSymbolsAreGlobal;
    public static final HostedOptionKey<String> ImageSymbolsPrefix;
    public static final HostedOptionKey<Boolean> FoldSecurityManagerGetter;
    @APIOption(name={"native-compiler-path"})
    public static final HostedOptionKey<String> CCompilerPath;
    @APIOption(name={"native-compiler-options"})
    public static final HostedOptionKey<LocatableMultiOptionValue.Strings> CCompilerOption;
    public static final HostedOptionKey<Boolean> StrictQueryCodeCompilation;
    @APIOption(name={"native-image-info"})
    public static final HostedOptionKey<Boolean> DumpTargetInfo;
    public static final HostedOptionKey<Boolean> CheckToolchain;
    @APIOption(name={"install-exit-handlers"})
    public static final HostedOptionKey<Boolean> InstallExitHandlers;
    public static final HostedOptionKey<Boolean> DetectUserDirectoriesInImageHeap;
    public static final HostedOptionKey<Boolean> UseNullRegion;
    public static final HostedOptionKey<Integer> DeadlockWatchdogInterval;
    public static final HostedOptionKey<Boolean> DeadlockWatchdogExitOnTimeout;
    public static final HostedOptionKey<Boolean> AllowVMInternalThreads;
    public static final HostedOptionKey<Boolean> IncludeDebugHelperMethods;
    @APIOption(name={"-g"}, fixedValue={"2"}, customHelp="generate debugging information")
    public static final HostedOptionKey<Integer> GenerateDebugInfo;
    public static final HostedOptionKey<LocatableMultiOptionValue.Strings> DebugInfoSourceSearchPath;
    public static final HostedOptionKey<String> DebugInfoSourceCacheRoot;
    public static final HostedOptionKey<Boolean> OmitInlinedMethodDebugLineInfo;
    public static final RuntimeOptionKey<Long> CompilationIsolateAddressSpaceSize;
    public static final RuntimeOptionKey<Integer> ActiveProcessorCount;
    public static final HostedOptionKey<Boolean> DisableTypeIdResultVerification;
    public static final HostedOptionKey<Boolean> EnableSignalAPI;
    public static final RuntimeOptionKey<Boolean> EnableSignalHandling;
    public static final RuntimeOptionKey<Boolean> DumpHeapAndExit;
    public static final RuntimeOptionKey<Boolean> FlightRecorder;
    public static final RuntimeOptionKey<String> StartFlightRecording;
    public static final RuntimeOptionKey<String> FlightRecorderLogging;
    protected static final HostedOptionKey<Integer> PageSize;
    public static final RuntimeOptionKey<String> DiagnosticDetails;
    @APIOption(name={"configure-reflection-metadata"})
    public static final HostedOptionKey<Boolean> ConfigureReflectionMetadata;
    public static final HostedOptionKey<Boolean> IncludeMethodData;
    public static final HostedOptionKey<Boolean> VerifyTypes;
    public static final HostedOptionKey<Boolean> RunReachabilityHandlersConcurrently;
    public static final HostedOptionKey<Boolean> UseDirectCallTrampolinesALot;

    public static boolean parseOnce() {
        return ParseOnce.getValue() != false && !DeoptimizationSupport.enabled();
    }

    @Fold
    public static boolean getSourceLevelDebug() {
        return SourceLevelDebug.getValue();
    }

    @Fold
    public static Predicate<String> getSourceLevelDebugFilter() {
        return SubstrateOptions.makeFilter(SourceLevelDebugFilter.getValue().values());
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static Predicate<String> makeFilter(List<String> definedFilters) {
        if (definedFilters.isEmpty()) {
            return javaName -> true;
        }
        List<String> wildCardList = OptionUtils.flatten(",", definedFilters);
        return javaName -> {
            for (String wildCard : wildCardList) {
                if (!javaName.startsWith(wildCard)) continue;
                return true;
            }
            return false;
        };
    }

    private static OptimizationLevel parseOptimizationLevel(String value) {
        int intLevel;
        if (value.equals("b")) {
            return OptimizationLevel.BUILD_TIME;
        }
        try {
            intLevel = Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            intLevel = -1;
        }
        if (intLevel == 0) {
            return OptimizationLevel.O0;
        }
        if (intLevel == 1) {
            return OptimizationLevel.O1;
        }
        if (intLevel >= 2) {
            return OptimizationLevel.O2;
        }
        throw UserError.abort("Invalid value '%s' provided for option Optimize (expected 'b' or numeric value >= 0)", value);
    }

    @Fold
    public static OptimizationLevel optimizationLevel() {
        return SubstrateOptions.parseOptimizationLevel(Optimize.getValue());
    }

    public static boolean useEconomyCompilerConfig(OptionValues options) {
        return "b".equals(Optimize.getValue(options));
    }

    @Fold
    public static boolean useEconomyCompilerConfig() {
        return SubstrateOptions.useEconomyCompilerConfig(HostedOptionValues.singleton());
    }

    public static void setOptimizeValueUpdateHandler(ValueUpdateHandler<OptimizationLevel> updateHandler) {
        optimizeValueUpdateHandler = updateHandler;
    }

    public static void setDebugInfoValueUpdateHandler(ValueUpdateHandler<Integer> updateHandler) {
        debugInfoValueUpdateHandler = updateHandler;
    }

    public static final long getTearDownWarningNanos() {
        return TearDownWarningNanos.getValue();
    }

    public static final long getTearDownFailureNanos() {
        return TearDownFailureNanos.getValue();
    }

    @Fold
    public static boolean useLLVMBackend() {
        return "llvm".equals(CompilerBackend.getValue());
    }

    @Fold
    public static int codeAlignment() {
        return CodeAlignment.getValue();
    }

    public static void defaultDebugInfoValueUpdateHandler(EconomicMap<OptionKey<?>, Object> values, Integer newValue) {
        GraalOptions.TrackNodeSourcePosition.update(values, (Object)(newValue > 0 ? 1 : 0));
        if (OS.WINDOWS.isCurrent()) {
            DeleteLocalSymbols.update(values, newValue == 0);
        }
    }

    public static Path getDebugInfoSourceCacheRoot() {
        try {
            return Paths.get(Path.getValue(), new String[0]).resolve(DebugInfoSourceCacheRoot.getValue());
        }
        catch (InvalidPathException ipe) {
            throw UserError.abort("Invalid path provided for option DebugInfoSourceCacheRoot %s", DebugInfoSourceCacheRoot.getValue());
        }
    }

    @Fold
    public static boolean supportCompileInIsolates() {
        UserError.guarantee(ConcealedOptions.SupportCompileInIsolates.getValue() == false || SpawnIsolates.getValue() != false, "Option %s must be enabled to support isolated compilations through option %s", SpawnIsolates.getName(), ConcealedOptions.SupportCompileInIsolates.getName());
        return ConcealedOptions.SupportCompileInIsolates.getValue();
    }

    public static boolean shouldCompileInIsolates() {
        return SubstrateOptions.supportCompileInIsolates() && ConcealedOptions.CompileInIsolates.getValue() != false;
    }

    @Fold
    public static boolean useRememberedSet() {
        return UseEpsilonGC.getValue() == false && ConcealedOptions.UseRememberedSet.getValue() != false;
    }

    public static String reportsPath() {
        return Paths.get(Paths.get(Path.getValue(), new String[0]).toString(), ((ReportingSupport)ImageSingletons.lookup(ReportingSupport.class)).reportsPath).toAbsolutePath().toString();
    }

    public static int getPageSize() {
        int value = PageSize.getValue();
        if (value == 0) {
            try {
                return Unsafe.getUnsafe().pageSize();
            }
            catch (IllegalArgumentException e) {
                return 4096;
            }
        }
        return value;
    }

    static {
        debugInfoValueUpdateHandler = SubstrateOptions::defaultDebugInfoValueUpdateHandler;
        Optimize = new HostedOptionKey<String>("2"){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, String oldValue, String newValue) {
                OptimizationLevel newLevel = SubstrateOptions.parseOptimizationLevel(newValue);
                IncludeNodeSourcePositions.update(values, newLevel == OptimizationLevel.O0);
                SourceLevelDebug.update(values, newLevel == OptimizationLevel.O0);
                AOTTrivialInline.update(values, newLevel != OptimizationLevel.O0);
                if (optimizeValueUpdateHandler != null) {
                    optimizeValueUpdateHandler.onValueUpdate(values, newLevel);
                }
            }
        };
        IncludeNodeSourcePositions = new HostedOptionKey<Boolean>(false);
        CLibraryPath = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());
        LinkerRPath = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());
        Path = new HostedOptionKey<Object>(null);
        UseSerialGC = new HostedOptionKey<Boolean>(true);
        UseEpsilonGC = new HostedOptionKey<Boolean>(false);
        StackSize = new RuntimeOptionKey<Long>(0L, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        InternalThreadStackSize = new HostedOptionKey<Long>(0x200000L);
        MaxJavaStackTraceDepth = new RuntimeOptionKey<Integer>(1024, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        MaxDirectMemorySize = new RuntimeOptionKey<Long>(0L, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        VerifyNamingConventions = new HostedOptionKey<Boolean>(false);
        MultiThreaded = new HostedOptionKey<Boolean>(true);
        ForceNoROSectionRelocations = new HostedOptionKey<Boolean>(false);
        SpawnIsolates = new HostedOptionKey<Boolean>(null){

            public Boolean getValueOrDefault(UnmodifiableEconomicMap<OptionKey<?>, Object> values) {
                if (!values.containsKey((Object)this)) {
                    return !SubstrateOptions.useLLVMBackend();
                }
                return (Boolean)values.get((Object)this);
            }

            public Boolean getValue(OptionValues values) {
                assert (this.checkDescriptorExists());
                return this.getValueOrDefault(values.getMap());
            }
        };
        TraceVMOperations = new HostedOptionKey<Boolean>(false);
        TraceClassInitialization = new HostedOptionKey<String>("");
        TraceObjectInstantiation = new HostedOptionKey<String>("");
        TraceNativeToolUsage = new HostedOptionKey<Boolean>(false);
        EntryPointNamePrefix = new HostedOptionKey<String>("");
        APIFunctionPrefix = new HostedOptionKey<String>("graal_");
        EnableURLProtocols = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());
        DisableURLProtocols = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());
        EnableAllSecurityServices = new HostedOptionKey<Boolean>(false);
        JNI = new HostedOptionKey<Boolean>(true);
        JNIVerboseLookupErrors = new HostedOptionKey<Boolean>(false);
        JNIExportSymbols = new HostedOptionKey<Boolean>(true);
        CodeAlignment = new HostedOptionKey<Integer>(16);
        BuildOutputUseNewStyle = new HostedOptionKey<Boolean>(true);
        BuildOutputPrefix = new HostedOptionKey<Boolean>(false);
        BuildOutputColorful = new HostedOptionKey<Boolean>(true);
        BuildOutputLinks = new HostedOptionKey<Boolean>(true);
        BuildOutputProgress = new HostedOptionKey<Boolean>(true);
        BuildOutputBreakdowns = new HostedOptionKey<Boolean>(true);
        BuildOutputGCWarnings = new HostedOptionKey<Boolean>(true);
        AllocatePrefetchLines = new HostedOptionKey<Integer>(4);
        AllocateInstancePrefetchLines = new HostedOptionKey<Integer>(1);
        AllocatePrefetchStyle = new HostedOptionKey<Integer>(1);
        AllocatePrefetchInstr = new HostedOptionKey<Integer>(0);
        AllocatePrefetchDistance = new HostedOptionKey<Integer>(192);
        AllocatePrefetchStepSize = new HostedOptionKey<Integer>(64);
        TearDownWarningNanos = new RuntimeOptionKey<Long>(0L, RuntimeOptionKey.RuntimeOptionKeyFlag.RelevantForCompilationIsolates);
        TearDownFailureNanos = new RuntimeOptionKey<Long>(0L, RuntimeOptionKey.RuntimeOptionKeyFlag.RelevantForCompilationIsolates);
        MaxUnrolledObjectZeroingStores = new HostedOptionKey<Integer>(8);
        StackTrace = new HostedOptionKey<Boolean>(true);
        ParseRuntimeOptions = new HostedOptionKey<Boolean>(true);
        EnableWildcardExpansion = new HostedOptionKey<Boolean>(true);
        AOTInline = new HostedOptionKey<Boolean>(true);
        AOTTrivialInline = new HostedOptionKey<Boolean>(true);
        NeverInline = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());
        MaxNodesInTrivialMethod = new HostedOptionKey<Integer>(20);
        MaxInvokesInTrivialMethod = new HostedOptionKey<Integer>(1);
        MaxNodesInTrivialLeafMethod = new HostedOptionKey<Integer>(40);
        PreserveFramePointer = new HostedOptionKey<Boolean>(false);
        UseCalleeSavedRegisters = new HostedOptionKey<Boolean>(true);
        UseCompressedFrameEncodings = new HostedOptionKey<Boolean>(true);
        ReportAnalysisForbiddenType = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());
        CompilerBackend = new HostedOptionKey<String>("lir"){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, String oldValue, String newValue) {
                if ("llvm".equals(newValue)) {
                    GraalOptions.EmitStringSubstitutions.update(values, (Object)false);
                    RemoveUnusedSymbols.update(values, false);
                    InternalSymbolsAreGlobal.update(values, true);
                    SpectrePHTMitigations.Options.SpectrePHTBarriers.update(values, (Object)SpectrePHTMitigations.None);
                }
            }
        };
        RemoveUnusedSymbols = new HostedOptionKey<Boolean>(OS.getCurrent() != OS.DARWIN);
        DeleteLocalSymbols = new HostedOptionKey<Boolean>(true);
        InternalSymbolsAreGlobal = new HostedOptionKey<Boolean>(false);
        ImageSymbolsPrefix = new HostedOptionKey<String>("");
        FoldSecurityManagerGetter = new HostedOptionKey<Boolean>(true);
        CCompilerPath = new HostedOptionKey<Object>(null);
        CCompilerOption = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());
        StrictQueryCodeCompilation = new HostedOptionKey<Boolean>(true);
        DumpTargetInfo = new HostedOptionKey<Boolean>(false);
        CheckToolchain = new HostedOptionKey<Boolean>(true);
        InstallExitHandlers = new HostedOptionKey<Boolean>(false);
        DetectUserDirectoriesInImageHeap = new HostedOptionKey<Boolean>(false);
        UseNullRegion = new HostedOptionKey<Boolean>(true);
        DeadlockWatchdogInterval = new HostedOptionKey<Integer>(10);
        DeadlockWatchdogExitOnTimeout = new HostedOptionKey<Boolean>(true);
        AllowVMInternalThreads = new HostedOptionKey<Boolean>(true);
        IncludeDebugHelperMethods = new HostedOptionKey<Boolean>(false);
        GenerateDebugInfo = new HostedOptionKey<Integer>(Integer.valueOf(0)){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Integer oldValue, Integer newValue) {
                debugInfoValueUpdateHandler.onValueUpdate(values, newValue);
            }
        };
        DebugInfoSourceSearchPath = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());
        DebugInfoSourceCacheRoot = new HostedOptionKey<String>("sources");
        OmitInlinedMethodDebugLineInfo = new HostedOptionKey<Boolean>(true);
        CompilationIsolateAddressSpaceSize = new RuntimeOptionKey<Long>(0L, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        ActiveProcessorCount = new ImmutableRuntimeOptionKey<Integer>(-1, RuntimeOptionKey.RuntimeOptionKeyFlag.RelevantForCompilationIsolates);
        DisableTypeIdResultVerification = new HostedOptionKey<Boolean>(true);
        EnableSignalAPI = new HostedOptionKey<Boolean>(null){

            public Boolean getValueOrDefault(UnmodifiableEconomicMap<OptionKey<?>, Object> values) {
                if (values.containsKey((Object)this)) {
                    return (Boolean)values.get((Object)this);
                }
                return (Boolean)SharedLibrary.getValueOrDefault(values) == false;
            }

            public Boolean getValue(OptionValues values) {
                return this.getValueOrDefault(values.getMap());
            }
        };
        EnableSignalHandling = new RuntimeOptionKey<Boolean>(null, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]){

            public Boolean getValueOrDefault(UnmodifiableEconomicMap<OptionKey<?>, Object> values) {
                if (values.containsKey((Object)this)) {
                    return (Boolean)values.get((Object)this);
                }
                return ImageInfo.isExecutable();
            }

            public Boolean getValue(OptionValues values) {
                return this.getValueOrDefault(values.getMap());
            }
        };
        DumpHeapAndExit = new ImmutableRuntimeOptionKey<Boolean>(false, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        FlightRecorder = new ImmutableRuntimeOptionKey<Boolean>(false, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        StartFlightRecording = new ImmutableRuntimeOptionKey<String>("", new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        FlightRecorderLogging = new ImmutableRuntimeOptionKey<String>("all=warning", new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        PageSize = new HostedOptionKey<Integer>(0);
        DiagnosticDetails = new RuntimeOptionKey<String>("", new RuntimeOptionKey.RuntimeOptionKeyFlag[]{RuntimeOptionKey.RuntimeOptionKeyFlag.RelevantForCompilationIsolates}){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, String oldValue, String newValue) {
                super.onValueUpdate(values, (Object)oldValue, (Object)newValue);
                SubstrateDiagnostics.updateInitialInvocationCounts(newValue);
            }
        };
        ConfigureReflectionMetadata = new HostedOptionKey<Boolean>(true);
        IncludeMethodData = new HostedOptionKey<Boolean>(true);
        VerifyTypes = new HostedOptionKey<Boolean>(false);
        RunReachabilityHandlersConcurrently = new HostedOptionKey<Boolean>(true);
        UseDirectCallTrampolinesALot = new HostedOptionKey<Boolean>(false);
    }

    public static class ReportingSupport {
        String reportsPath;

        public ReportingSupport(String reportingPath) {
            this.reportsPath = reportingPath;
        }
    }

    public static class ConcealedOptions {
        public static final HostedOptionKey<Boolean> SupportCompileInIsolates = new HostedOptionKey<Boolean>(null){

            public Boolean getValueOrDefault(UnmodifiableEconomicMap<OptionKey<?>, Object> values) {
                if (!values.containsKey((Object)this)) {
                    return (Boolean)SpawnIsolates.getValueOrDefault(values);
                }
                return (Boolean)super.getValueOrDefault(values);
            }

            public Boolean getValue(OptionValues values) {
                return this.getValueOrDefault(values.getMap());
            }
        };
        public static final RuntimeOptionKey<Boolean> CompileInIsolates = new RuntimeOptionKey<Boolean>(true, RuntimeOptionKey.RuntimeOptionKeyFlag.RelevantForCompilationIsolates);
        public static final HostedOptionKey<Boolean> UseRememberedSet = new HostedOptionKey<Boolean>(true);
        public static final HostedOptionKey<Boolean> UseDedicatedVMOperationThread = new HostedOptionKey<Boolean>(false);
        public static final RuntimeOptionKey<Boolean> AutomaticReferenceHandling = new ImmutableRuntimeOptionKey<Boolean>(true, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    }

    public static final class GCGroup
    implements APIOptionGroup {
        @Override
        public String name() {
            return "gc";
        }

        @Override
        public String helpText() {
            return "Select native-image garbage collector implementation.";
        }
    }

    public static interface ValueUpdateHandler<T> {
        public void onValueUpdate(EconomicMap<OptionKey<?>, Object> var1, T var2);
    }

    public static enum OptimizationLevel {
        O0,
        O1,
        O2,
        BUILD_TIME;

    }
}

