/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.SimpleCodeInfoQueryResult;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.graal.nodes.SubstrateNewHybridInstanceNode;
import com.oracle.svm.core.heap.CodeReferenceMapDecoder;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackWalk;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.thread.Continuation;
import com.oracle.svm.core.thread.ContinuationSupport;
import com.oracle.svm.core.thread.Safepoint;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.api.directives.GraalDirectives;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.java.ArrayLengthNode;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class StoredContinuationAccess {
    private static final int IP_OFFSET = 0;
    private static final int FRAMES_OFFSET = 8;

    private StoredContinuationAccess() {
    }

    private static StoredContinuation allocate(int framesSize) {
        int nlongs = Integer.divideUnsigned(8 + framesSize, 8);
        StoredContinuation s = (StoredContinuation)SubstrateNewHybridInstanceNode.allocate(StoredContinuation.class, Long.TYPE, nlongs);
        assert (StoredContinuationAccess.getFramesSizeInBytes(s) == framesSize);
        return s;
    }

    @Node.NodeIntrinsic(value=ArrayLengthNode.class)
    private static native int arrayLength(StoredContinuation var0);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int getSizeInBytes(StoredContinuation s) {
        return StoredContinuationAccess.arrayLength(s) * 8;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int getFramesSizeInBytes(StoredContinuation s) {
        return StoredContinuationAccess.getSizeInBytes(s) - 8;
    }

    @Uninterruptible(reason="Prevent GC during accesses via object address.", callerMustBe=true)
    private static Pointer arrayAddress(StoredContinuation s) {
        int layout = KnownIntrinsics.readHub(s).getLayoutEncoding();
        UnsignedWord baseOffset = LayoutEncoding.getArrayBaseOffset(layout);
        return Word.objectToUntrackedPointer((Object)s).add(baseOffset);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static CodePointer getIP(StoredContinuation s) {
        return (CodePointer)StoredContinuationAccess.arrayAddress(s).readWord(0);
    }

    @Uninterruptible(reason="Prevent GC during accesses via object address.", callerMustBe=true)
    public static Pointer getFramesStart(StoredContinuation s) {
        return StoredContinuationAccess.arrayAddress(s).add(8);
    }

    public static int allocateToYield(Continuation c, Pointer baseSp, Pointer sp, CodePointer ip) {
        assert (sp.isNonNull() && ip.isNonNull());
        return StoredContinuationAccess.allocateFromStack(c, baseSp, sp, ip, (IsolateThread)WordFactory.nullPointer());
    }

    public static int allocateToPreempt(Continuation c, Pointer baseSp, IsolateThread targetThread) {
        return StoredContinuationAccess.allocateFromStack(c, baseSp, (Pointer)WordFactory.nullPointer(), (CodePointer)WordFactory.nullPointer(), targetThread);
    }

    private static int allocateFromStack(Continuation cont, Pointer baseSp, Pointer sp, CodePointer ip, IsolateThread targetThread) {
        boolean yield = sp.isNonNull();
        assert (yield == ip.isNonNull() && yield == targetThread.isNull());
        assert (baseSp.isNonNull());
        Pointer startSp = sp;
        CodePointer startIp = ip;
        if (!yield) {
            PreemptVisitor visitor = new PreemptVisitor(baseSp);
            JavaStackWalker.walkThread(targetThread, visitor);
            if (visitor.preemptStatus != 0) {
                return visitor.preemptStatus;
            }
            startSp = visitor.leafSP;
            startIp = visitor.leafIP;
        }
        VMError.guarantee(startSp.isNonNull());
        int framesSize = UnsignedUtils.safeToInt((UnsignedWord)baseSp.subtract((UnsignedWord)startSp));
        StoredContinuation instance = StoredContinuationAccess.allocate(framesSize);
        StoredContinuationAccess.fillUninterruptibly(instance, startIp, startSp, framesSize);
        cont.stored = instance;
        return 0;
    }

    @Uninterruptible(reason="Prevent modifications to the stack while initializing instance and copying frames.")
    private static void fillUninterruptibly(StoredContinuation stored, CodePointer ip, Pointer sp, int size) {
        StoredContinuationAccess.arrayAddress(stored).writeWord(0, (WordBase)ip);
        UnmanagedMemoryUtil.copy(sp, StoredContinuationAccess.getFramesStart(stored), WordFactory.unsigned((int)size));
        StoredContinuationAccess.afterFill(stored);
    }

    @Uninterruptible(reason="Prevent modifications to the stack while initializing instance.")
    private static void afterFill(StoredContinuation stored) {
        Object opaque = GraalDirectives.opaque((Object)stored);
        Heap.getHeap().dirtyAllReferencesOf(opaque);
    }

    public static StoredContinuation clone(StoredContinuation cont) {
        StoredContinuation clone = StoredContinuationAccess.allocate(StoredContinuationAccess.getFramesSizeInBytes(cont));
        return StoredContinuationAccess.fillCloneUninterruptibly(cont, clone);
    }

    @Uninterruptible(reason="Prevent garbage collection while initializing instance and copying frames.")
    private static StoredContinuation fillCloneUninterruptibly(StoredContinuation cont, StoredContinuation clone) {
        CodePointer ip = ((ContinuationSupport)ImageSingletons.lookup(ContinuationSupport.class)).copyFrames(cont, clone);
        StoredContinuationAccess.arrayAddress(clone).writeWord(0, (WordBase)ip);
        StoredContinuationAccess.afterFill(clone);
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AlwaysInline(value="De-virtualize calls to ObjectReferenceVisitor")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean walkReferences(Pointer baseAddress, ObjectReferenceVisitor visitor, Object holderObject) {
        assert (!Heap.getHeap().isInImageHeap(baseAddress));
        StoredContinuation s = (StoredContinuation)holderObject;
        assert (baseAddress.equal((UnsignedWord)Word.objectToUntrackedPointer((Object)holderObject)));
        CodePointer startIp = StoredContinuationAccess.getIP(s);
        if (startIp.isNull()) {
            return true;
        }
        Pointer startSp = StoredContinuationAccess.getFramesStart(s);
        Pointer endSp = StoredContinuationAccess.arrayAddress(s).add(StoredContinuationAccess.getSizeInBytes(s));
        JavaStackWalk walk = (JavaStackWalk)StackValue.get(JavaStackWalk.class);
        JavaStackWalker.initWalk(walk, startSp, endSp, startIp);
        SimpleCodeInfoQueryResult queryResult = (SimpleCodeInfoQueryResult)StackValue.get(SimpleCodeInfoQueryResult.class);
        do {
            Pointer sp = walk.getSP();
            CodePointer ip = walk.getPossiblyStaleIP();
            UntetheredCodeInfo untetheredCodeInfo = walk.getIPCodeInfo();
            Object tether = CodeInfoAccess.acquireTether(untetheredCodeInfo);
            try {
                CodeInfo codeInfo = CodeInfoAccess.convert(untetheredCodeInfo);
                VMError.guarantee(codeInfo.equal((ComparableWord)CodeInfoTable.getImageCodeInfo()));
                VMError.guarantee(Deoptimizer.checkDeoptimized(sp) == null);
                if (codeInfo.isNull()) {
                    throw JavaStackWalker.reportUnknownFrameEncountered(sp, ip, null);
                }
                CodeInfoAccess.lookupCodeInfo(codeInfo, CodeInfoAccess.relativeIP(codeInfo, ip), queryResult);
                NonmovableArray<Byte> referenceMapEncoding = CodeInfoAccess.getStackReferenceMapEncoding(codeInfo);
                long referenceMapIndex = queryResult.getReferenceMapIndex();
                if (referenceMapIndex == -1L) continue;
                CodeReferenceMapDecoder.walkOffsetsFromPointer((PointerBase)sp, referenceMapEncoding, referenceMapIndex, visitor, holderObject);
            }
            finally {
                CodeInfoAccess.releaseTether(untetheredCodeInfo, tether);
            }
        } while (JavaStackWalker.continueWalk(walk, queryResult, null));
        return true;
    }

    private static final class PreemptVisitor
    extends StackFrameVisitor {
        private final Pointer endSP;
        private boolean startFromNextFrame = false;
        Pointer leafSP;
        CodePointer leafIP;
        int preemptStatus = 0;

        PreemptVisitor(Pointer endSP) {
            this.endSP = endSP;
        }

        @Override
        protected boolean visitFrame(Pointer sp, CodePointer ip, CodeInfo codeInfo, DeoptimizedFrame deoptimizedFrame) {
            if (sp.aboveOrEqual((UnsignedWord)this.endSP)) {
                return false;
            }
            FrameInfoQueryResult frameInfo = CodeInfoTable.lookupCodeInfoQueryResult(codeInfo, ip).getFrameInfo();
            if (frameInfo.getSourceClass().equals(StoredContinuationAccess.class) && frameInfo.getSourceMethodName().equals("allocateToYield")) {
                this.preemptStatus = -2;
                return false;
            }
            if (this.leafSP.isNull()) {
                if (this.startFromNextFrame) {
                    this.leafSP = sp;
                    this.leafIP = ip;
                } else {
                    if (frameInfo.getSourceClass().equals(Safepoint.class) && frameInfo.getSourceMethodName().equals("enterSlowPathSafepointCheck")) {
                        this.startFromNextFrame = true;
                    }
                    return true;
                }
            }
            VMError.guarantee(codeInfo.equal((ComparableWord)CodeInfoTable.getImageCodeInfo()));
            return true;
        }
    }
}

