/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK17OrLater;
import com.oracle.svm.core.jdk.SystemPropertiesSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.function.BooleanSupplier;
import org.graalvm.nativeimage.ImageSingletons;

@Substitute
@TargetClass(className="jdk.internal.util.StaticProperty")
final class Target_jdk_internal_util_StaticProperty {
    Target_jdk_internal_util_StaticProperty() {
    }

    @Substitute
    private static String javaHome() {
        return null;
    }

    @Substitute
    private static String userHome() {
        return ((SystemPropertiesSupport)ImageSingletons.lookup(SystemPropertiesSupport.class)).userHome();
    }

    @Substitute
    private static String userDir() {
        return ((SystemPropertiesSupport)ImageSingletons.lookup(SystemPropertiesSupport.class)).userDir();
    }

    @Substitute
    private static String userName() {
        return ((SystemPropertiesSupport)ImageSingletons.lookup(SystemPropertiesSupport.class)).userName();
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class})
    private static String javaIoTmpDir() {
        return ((SystemPropertiesSupport)ImageSingletons.lookup(SystemPropertiesSupport.class)).javaIoTmpDir();
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class})
    private static String javaLibraryPath() {
        return ((SystemPropertiesSupport)ImageSingletons.lookup(SystemPropertiesSupport.class)).javaLibraryPath();
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class})
    private static String sunBootLibraryPath() {
        String value = ((SystemPropertiesSupport)ImageSingletons.lookup(SystemPropertiesSupport.class)).savedProperties.get("sun.boot.library.path");
        return value == null ? "" : value;
    }

    @Substitute
    private static String jdkSerialFilter() {
        return ((SystemPropertiesSupport)ImageSingletons.lookup(SystemPropertiesSupport.class)).savedProperties.get("jdk.serialFilter");
    }

    @Substitute
    @TargetElement(onlyWith={StaticPropertyJdkSerialFilterFactoryAvailable.class})
    private static String jdkSerialFilterFactory() {
        return ((SystemPropertiesSupport)ImageSingletons.lookup(SystemPropertiesSupport.class)).savedProperties.get("jdk.serialFilterFactory");
    }

    private static class StaticPropertyJdkSerialFilterFactoryAvailable
    implements BooleanSupplier {
        private StaticPropertyJdkSerialFilterFactoryAvailable() {
        }

        @Override
        public boolean getAsBoolean() {
            Method method;
            try {
                method = ReflectionUtil.lookupMethod((boolean)true, Class.forName("jdk.internal.util.StaticProperty"), (String)"jdkSerialFilterFactory", (Class[])new Class[0]);
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            return method != null;
        }
    }
}

