/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.core.option.URIOptionOrigin;
import com.oracle.svm.core.util.VMError;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;

final class JarOptionOrigin
extends URIOptionOrigin {
    protected JarOptionOrigin(URI rawOrigin) {
        String specific = rawOrigin.getSchemeSpecificPart();
        int sep = specific.lastIndexOf(33);
        VMError.guarantee(sep > 0, "Invalid jar origin");
        String origin = specific.substring(0, sep);
        this.container = URIOptionOrigin.originURI(origin);
        this.location = Path.of(specific.substring(sep + 2), new String[0]);
    }

    @Override
    public List<String> getRedirectionValues(Path valuesFile) throws IOException {
        FileSystem probeJarFS;
        URI jarFileURI = URI.create("jar:" + this.container());
        try {
            probeJarFS = FileSystems.newFileSystem(jarFileURI, Collections.emptyMap());
        }
        catch (UnsupportedOperationException e) {
            probeJarFS = null;
        }
        if (probeJarFS == null) {
            throw new IOException("Unable to create jar file system for " + jarFileURI);
        }
        try (FileSystem fs = probeJarFS;){
            Path normalizedRedirPath = this.location().getParent().resolve(valuesFile).normalize();
            List<String> list = JarOptionOrigin.getRedirectionValuesFromPath(normalizedRedirPath);
            return list;
        }
    }
}

