/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.heap.StoredContinuationAccess;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;

public class ContinuationSupport {
    @AlwaysInline(value="If not inlined, this method could overwrite its own frame.")
    @Uninterruptible(reason="Copies stack frames containing references.")
    public CodePointer copyFrames(StoredContinuation storedCont, Pointer to) {
        int totalSize = StoredContinuationAccess.getFramesSizeInBytes(storedCont);
        CodePointer storedIP = StoredContinuationAccess.getIP(storedCont);
        Pointer frameData = StoredContinuationAccess.getFramesStart(storedCont);
        int offset = 0;
        for (int next = offset + 32; next < totalSize; next += 32) {
            Pointer src = frameData.add(offset);
            Pointer dst = to.add(offset);
            long l0 = src.readLong(0);
            long l8 = src.readLong(8);
            long l16 = src.readLong(16);
            long l24 = src.readLong(24);
            dst.writeLong(0, l0);
            dst.writeLong(8, l8);
            dst.writeLong(16, l16);
            dst.writeLong(24, l24);
            offset = next;
        }
        while (offset < totalSize) {
            to.writeByte(offset, frameData.readByte(offset));
            ++offset;
        }
        return storedIP;
    }

    @Uninterruptible(reason="Copies stack frames containing references.")
    public CodePointer copyFrames(StoredContinuation fromCont, StoredContinuation toCont) {
        return this.copyFrames(fromCont, StoredContinuationAccess.getFramesStart(toCont));
    }
}

