/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.stack.JavaFrameAnchor;
import com.oracle.svm.core.stack.JavaFrameAnchors;
import com.oracle.svm.core.thread.Continuation;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.Target_java_lang_Continuation;
import com.oracle.svm.core.thread.Target_java_lang_ContinuationScope;
import com.oracle.svm.core.thread.Target_java_lang_Thread;
import com.oracle.svm.core.thread.Target_java_lang_Thread_FieldHolder;
import com.oracle.svm.core.thread.Target_java_lang_VirtualThread;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import jdk.internal.misc.Unsafe;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public final class LoomSupport {
    public static final int YIELD_SUCCESS = 0;
    public static final int PINNED_CRITICAL_SECTION = 1;
    public static final int PINNED_NATIVE = 2;

    @Fold
    public static boolean isEnabled() {
        return Continuation.isSupported() && SubstrateOptions.UseLoom.getValue() != false;
    }

    public static int yield(Target_java_lang_Continuation cont) {
        return LoomSupport.convertInternalYieldResult(cont.internal.yield());
    }

    static int convertInternalYieldResult(int value) {
        return value;
    }

    public static int isPinned(Target_java_lang_Thread thread, Target_java_lang_ContinuationScope scope, boolean isCurrentThread) {
        IsolateThread vmThread;
        Target_java_lang_Continuation cont = thread.getContinuation();
        IsolateThread isolateThread = vmThread = isCurrentThread ? CurrentIsolate.getCurrentThread() : PlatformThreads.getIsolateThread(SubstrateUtil.cast(thread, Thread.class));
        if (cont != null) {
            while (true) {
                if (cont.cs > 0) {
                    return 1;
                }
                if (cont.getParent() == null || cont.getScope() == scope) break;
                cont = cont.getParent();
            }
            JavaFrameAnchor anchor = JavaFrameAnchors.getFrameAnchor(vmThread);
            if (anchor.isNonNull() && cont.internal.getBaseSP().aboveThan((UnsignedWord)anchor.getLastJavaSP())) {
                return 2;
            }
        }
        return 0;
    }

    public static boolean isStarted(Target_java_lang_Continuation cont) {
        return cont.isStarted();
    }

    public static Pointer getBaseSP(Target_java_lang_Continuation cont) {
        return cont.internal.getBaseSP();
    }

    public static Target_java_lang_Continuation getContinuation(Target_java_lang_Thread thread) {
        if (thread.isVirtual()) {
            Target_java_lang_VirtualThread vthread = SubstrateUtil.cast(thread, Target_java_lang_VirtualThread.class);
            return vthread.cont;
        }
        return thread.cont;
    }

    private LoomSupport() {
    }

    public static class CompatibilityUtil {
        private static final Field FIELDHOLDER_STATUS_FIELD = ImageInfo.inImageCode() && LoomSupport.isEnabled() ? ReflectionUtil.lookupField(Target_java_lang_Thread_FieldHolder.class, (String)"threadStatus") : null;
        private static final Field THREAD_STATUS_FIELD = ImageInfo.inImageCode() && !LoomSupport.isEnabled() ? ReflectionUtil.lookupField(Target_java_lang_Thread.class, (String)"threadStatus") : null;

        static long getStackSize(Target_java_lang_Thread tjlt) {
            return LoomSupport.isEnabled() ? tjlt.holder.stackSize : tjlt.stackSize;
        }

        static int getThreadStatus(Target_java_lang_Thread tjlt) {
            return LoomSupport.isEnabled() ? tjlt.holder.threadStatus : tjlt.threadStatus;
        }

        static void setThreadStatus(Target_java_lang_Thread tjlt, int threadStatus) {
            if (LoomSupport.isEnabled()) {
                tjlt.holder.threadStatus = threadStatus;
            } else {
                tjlt.threadStatus = threadStatus;
            }
        }

        static boolean compareAndSetThreadStatus(Target_java_lang_Thread tjlt, int expectedStatus, int newStatus) {
            if (LoomSupport.isEnabled()) {
                return Unsafe.getUnsafe().compareAndSetInt(tjlt.holder, Unsafe.getUnsafe().objectFieldOffset(FIELDHOLDER_STATUS_FIELD), expectedStatus, newStatus);
            }
            return Unsafe.getUnsafe().compareAndSetInt(tjlt, Unsafe.getUnsafe().objectFieldOffset(THREAD_STATUS_FIELD), expectedStatus, newStatus);
        }

        static int getPriority(Target_java_lang_Thread tjlt) {
            if (LoomSupport.isEnabled()) {
                return tjlt.holder.priority;
            }
            return tjlt.priority;
        }

        static void setPriority(Target_java_lang_Thread tjlt, int priority) {
            if (LoomSupport.isEnabled()) {
                tjlt.holder.priority = priority;
            } else {
                tjlt.priority = priority;
            }
        }

        static void setStackSize(Target_java_lang_Thread tjlt, long stackSize) {
            if (LoomSupport.isEnabled()) {
                tjlt.holder.stackSize = stackSize;
            } else {
                tjlt.stackSize = stackSize;
            }
        }

        static void setDaemon(Target_java_lang_Thread tjlt, boolean isDaemon) {
            if (LoomSupport.isEnabled()) {
                tjlt.holder.daemon = isDaemon;
            } else {
                tjlt.daemon = isDaemon;
            }
        }

        static void setGroup(Target_java_lang_Thread tjlt, ThreadGroup group) {
            if (LoomSupport.isEnabled()) {
                tjlt.holder.group = group;
            } else {
                tjlt.group = group;
            }
        }

        static void setTarget(Target_java_lang_Thread tjlt, Runnable target) {
            if (LoomSupport.isEnabled()) {
                tjlt.holder.task = target;
            } else {
                tjlt.target = target;
            }
        }

        static void initThreadFields(Target_java_lang_Thread tjlt, ThreadGroup group, Runnable target, long stackSize, int priority, boolean daemon, int threadStatus) {
            if (LoomSupport.isEnabled()) {
                tjlt.holder = new Target_java_lang_Thread_FieldHolder(null, null, 0L, 0, false);
            }
            CompatibilityUtil.setGroup(tjlt, group);
            CompatibilityUtil.setPriority(tjlt, priority);
            CompatibilityUtil.setDaemon(tjlt, daemon);
            CompatibilityUtil.setTarget(tjlt, target);
            tjlt.setPriority(priority);
            CompatibilityUtil.setStackSize(tjlt, stackSize);
            CompatibilityUtil.setThreadStatus(tjlt, threadStatus);
        }
    }
}

