/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.option.OptionOrigin;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.ClasspathUtils;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.NativeImageClassLoaderOptions;
import com.oracle.svm.hosted.NativeImageGeneratorRunner;
import com.oracle.svm.hosted.annotation.SubstrateAnnotationExtracter;
import com.oracle.svm.hosted.option.HostedOptionParser;
import com.oracle.svm.util.AnnotationExtracter;
import com.oracle.svm.util.ModuleSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.io.File;
import java.io.IOException;
import java.lang.module.Configuration;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.internal.module.Modules;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;

public class NativeImageClassLoaderSupport {
    private final List<Path> imagecp;
    private final List<Path> buildcp;
    private final List<Path> imagemp;
    private final List<Path> buildmp;
    private final EconomicMap<URI, EconomicSet<String>> classes;
    private final EconomicMap<URI, EconomicSet<String>> packages;
    private final EconomicSet<String> emptySet;
    private final ClassPathClassLoader classPathClassLoader;
    private final ClassLoader classLoader;
    public final ModuleFinder upgradeAndSystemModuleFinder;
    public final ModuleLayer moduleLayerForImageBuild;
    public final ModuleFinder modulepathModuleFinder;
    public final AnnotationExtracter annotationExtracter;
    private HostedOptionParser hostedOptionParser;
    private OptionValues parsedHostedOptions;
    private List<String> remainingArguments;
    final Path excludeDirectoriesRoot = Paths.get("/", new String[0]);
    final Set<Path> excludeDirectories = this.getExcludeDirectories();

    protected NativeImageClassLoaderSupport(ClassLoader defaultSystemClassLoader, String[] classpath, String[] modulePath) {
        String[] builderClassPathEntries;
        this.classes = EconomicMap.create();
        this.packages = EconomicMap.create();
        this.emptySet = EconomicSet.create();
        this.classPathClassLoader = new ClassPathClassLoader(Util.verifyClassPathAndConvertToURLs(classpath), defaultSystemClassLoader);
        this.imagecp = Arrays.stream(this.classPathClassLoader.getURLs()).map(Util::urlToPath).collect(Collectors.toUnmodifiableList());
        String builderClassPathString = System.getProperty("java.class.path");
        String[] stringArray = builderClassPathEntries = builderClassPathString.isEmpty() ? new String[]{} : builderClassPathString.split(File.pathSeparator);
        if (Arrays.asList(builderClassPathEntries).contains(".")) {
            VMError.shouldNotReachHere("The classpath of " + NativeImageGeneratorRunner.class.getName() + " must not contain \".\". This can happen implicitly if the builder runs exclusively on the --module-path but specifies the " + NativeImageGeneratorRunner.class.getName() + " main class without --module.");
        }
        this.buildcp = Arrays.stream(builderClassPathEntries).map(x$0 -> Path.of(x$0, new String[0])).map(Path::toAbsolutePath).collect(Collectors.toUnmodifiableList());
        this.imagemp = Arrays.stream(modulePath).map(x$0 -> Path.of(x$0, new String[0])).collect(Collectors.toUnmodifiableList());
        this.buildmp = Optional.ofNullable(System.getProperty("jdk.module.path")).stream().flatMap(s -> Arrays.stream(s.split(File.pathSeparator))).map(x$0 -> Path.of(x$0, new String[0])).collect(Collectors.toUnmodifiableList());
        this.upgradeAndSystemModuleFinder = NativeImageClassLoaderSupport.createUpgradeAndSystemModuleFinder();
        ModuleLayer moduleLayer = this.createModuleLayer((Path[])this.imagemp.toArray(Path[]::new), this.classPathClassLoader);
        NativeImageClassLoaderSupport.adjustBootLayerQualifiedExports(moduleLayer);
        this.moduleLayerForImageBuild = moduleLayer;
        this.classLoader = this.getSingleClassloader(moduleLayer);
        this.modulepathModuleFinder = ModuleFinder.of((Path[])this.modulepath().toArray(Path[]::new));
        this.annotationExtracter = new SubstrateAnnotationExtracter();
    }

    List<Path> classpath() {
        return Stream.concat(this.imagecp.stream(), this.buildcp.stream()).distinct().collect(Collectors.toList());
    }

    List<Path> applicationClassPath() {
        return this.imagecp;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void initAllClasses(ForkJoinPool executor, ImageClassLoader imageClassLoader) {
        new ClassInit(executor, imageClassLoader).init();
    }

    public void setupHostedOptionParser(List<String> arguments) {
        this.hostedOptionParser = new HostedOptionParser(this.getClassLoader());
        this.remainingArguments = Collections.unmodifiableList(this.hostedOptionParser.parse(arguments));
        this.parsedHostedOptions = new OptionValues(this.hostedOptionParser.getHostedValues());
    }

    public HostedOptionParser getHostedOptionParser() {
        return this.hostedOptionParser;
    }

    public List<String> getRemainingArguments() {
        return this.remainingArguments;
    }

    public OptionValues getParsedHostedOptions() {
        return this.parsedHostedOptions;
    }

    public EconomicSet<String> classes(URI container) {
        return (EconomicSet)this.classes.get((Object)container, this.emptySet);
    }

    public EconomicSet<String> packages(URI container) {
        return (EconomicSet)this.packages.get((Object)container, this.emptySet);
    }

    public boolean noEntryForURI(EconomicSet<String> set) {
        return set == this.emptySet;
    }

    private ModuleLayer createModuleLayer(Path[] modulePaths, ClassLoader parent) {
        ModuleFinder modulePathsFinder = ModuleFinder.of(modulePaths);
        Set<String> moduleNames = modulePathsFinder.findAll().stream().map(moduleReference -> moduleReference.descriptor().name()).collect(Collectors.toSet());
        Configuration configuration = ModuleLayer.boot().configuration().resolve(modulePathsFinder, this.upgradeAndSystemModuleFinder, moduleNames);
        return ModuleLayer.defineModulesWithOneLoader(configuration, List.of(ModuleLayer.boot()), parent).layer();
    }

    private static ModuleFinder createUpgradeAndSystemModuleFinder() {
        ModuleFinder finder = ModuleFinder.ofSystem();
        ModuleFinder upgradeModulePath = NativeImageClassLoaderSupport.finderFor("jdk.module.upgrade.path");
        if (upgradeModulePath != null) {
            finder = ModuleFinder.compose(upgradeModulePath, finder);
        }
        return finder;
    }

    private static ModuleFinder finderFor(String prop) {
        String s = System.getProperty(prop);
        if (s == null || s.isEmpty()) {
            return null;
        }
        String[] dirs = s.split(File.pathSeparator);
        Path[] paths = new Path[dirs.length];
        int i = 0;
        for (String dir : dirs) {
            paths[i++] = Path.of(dir, new String[0]);
        }
        return ModuleFinder.of(paths);
    }

    private static void adjustBootLayerQualifiedExports(ModuleLayer layer) {
        for (Module module : ModuleLayer.boot().modules()) {
            for (ModuleDescriptor.Exports export : module.getDescriptor().exports()) {
                for (String target : export.targets()) {
                    Optional<Module> optExportTargetModule = layer.findModule(target);
                    if (optExportTargetModule.isEmpty()) continue;
                    Module exportTargetModule = optExportTargetModule.get();
                    if (module.isExported(export.source(), exportTargetModule)) continue;
                    Modules.addExports(module, export.source(), exportTargetModule);
                }
            }
        }
    }

    private ClassLoader getSingleClassloader(ModuleLayer moduleLayer) {
        ClassLoader singleClassloader = this.classPathClassLoader;
        for (Module module : moduleLayer.modules()) {
            ClassLoader moduleClassLoader = module.getClassLoader();
            if (singleClassloader == this.classPathClassLoader) {
                singleClassloader = moduleClassLoader;
                continue;
            }
            VMError.guarantee(singleClassloader == moduleClassLoader);
        }
        return singleClassloader;
    }

    private static void implAddReadsAllUnnamed(Module module) {
        try {
            Method implAddReadsAllUnnamed = Module.class.getDeclaredMethod("implAddReadsAllUnnamed", new Class[0]);
            ModuleSupport.accessModuleByClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, NativeImageClassLoaderSupport.class, Module.class);
            implAddReadsAllUnnamed.setAccessible(true);
            implAddReadsAllUnnamed.invoke((Object)module, new Object[0]);
        }
        catch (ReflectiveOperationException | NoSuchElementException e) {
            VMError.shouldNotReachHere("Could reflectively call Module.implAddReadsAllUnnamed", e);
        }
    }

    protected List<Path> modulepath() {
        return Stream.concat(this.imagemp.stream(), this.buildmp.stream()).collect(Collectors.toUnmodifiableList());
    }

    protected List<Path> applicationModulePath() {
        return this.imagemp;
    }

    public Optional<Module> findModule(String moduleName) {
        return this.moduleLayerForImageBuild.findModule(moduleName);
    }

    void processClassLoaderOptions() {
        if (((Boolean)NativeImageClassLoaderOptions.ListModules.getValue(this.parsedHostedOptions)).booleanValue()) {
            NativeImageClassLoaderSupport.processListModulesOption(this.moduleLayerForImageBuild);
        }
        this.processOption(NativeImageClassLoaderOptions.AddExports).forEach(val -> {
            if (val.targetModules.isEmpty()) {
                Modules.addExportsToAllUnnamed(val.module, val.packageName);
            } else {
                for (Module targetModule : val.targetModules) {
                    Modules.addExports(val.module, val.packageName, targetModule);
                }
            }
        });
        this.processOption(NativeImageClassLoaderOptions.AddOpens).forEach(val -> {
            if (val.targetModules.isEmpty()) {
                Modules.addOpensToAllUnnamed(val.module, val.packageName);
            } else {
                for (Module targetModule : val.targetModules) {
                    Modules.addOpens(val.module, val.packageName, targetModule);
                }
            }
        });
        this.processOption(NativeImageClassLoaderOptions.AddReads).forEach(val -> {
            if (val.targetModules.isEmpty()) {
                NativeImageClassLoaderSupport.implAddReadsAllUnnamed(val.module);
            } else {
                for (Module targetModule : val.targetModules) {
                    Modules.addReads(val.module, targetModule);
                }
            }
        });
    }

    private static void processListModulesOption(ModuleLayer layer) {
        Class launcherHelperClass = ReflectionUtil.lookupClass((boolean)false, (String)"sun.launcher.LauncherHelper");
        Method showModuleMethod = ReflectionUtil.lookupMethod((Class)launcherHelperClass, (String)"showModule", (Class[])new Class[]{ModuleReference.class});
        boolean first = true;
        for (ModuleLayer moduleLayer : NativeImageClassLoaderSupport.allLayers(layer)) {
            List resolvedModules = moduleLayer.configuration().modules().stream().sorted(Comparator.comparing(ResolvedModule::name)).collect(Collectors.toList());
            if (first) {
                first = false;
            } else if (!resolvedModules.isEmpty()) {
                System.out.println();
            }
            for (ResolvedModule resolvedModule : resolvedModules) {
                try {
                    showModuleMethod.invoke(null, resolvedModule.reference());
                }
                catch (ReflectiveOperationException e) {
                    throw VMError.shouldNotReachHere("Unable to " + showModuleMethod + " for printing list of modules.", e);
                }
            }
        }
        throw new InterruptImageBuilding("");
    }

    public void propagateQualifiedExports(String fromTargetModule, String toTargetModule) {
        Optional<Module> optFromTarget = this.moduleLayerForImageBuild.findModule(fromTargetModule);
        Optional<Module> optToTarget = this.moduleLayerForImageBuild.findModule(toTargetModule);
        VMError.guarantee(optFromTarget.isPresent() && optToTarget.isPresent());
        Module toTarget = optToTarget.get();
        Module fromTarget = optFromTarget.get();
        NativeImageClassLoaderSupport.allLayers(this.moduleLayerForImageBuild).stream().flatMap(layer -> layer.modules().stream()).forEach(m -> {
            if (!m.equals(toTarget)) {
                for (String p : m.getPackages()) {
                    if (m.isExported(p, fromTarget)) {
                        Modules.addExports(m, p, toTarget);
                    }
                    if (!m.isOpen(p, fromTarget)) continue;
                    Modules.addOpens(m, p, toTarget);
                }
            }
        });
    }

    public static List<ModuleLayer> allLayers(ModuleLayer moduleLayer) {
        ArrayList<ModuleLayer> allLayers = new ArrayList<ModuleLayer>();
        HashSet<ModuleLayer> visited = new HashSet<ModuleLayer>();
        ArrayDeque<ModuleLayer> stack = new ArrayDeque<ModuleLayer>();
        visited.add(moduleLayer);
        stack.push(moduleLayer);
        while (!stack.isEmpty()) {
            ModuleLayer layer = (ModuleLayer)stack.pop();
            allLayers.add(layer);
            for (int i = layer.parents().size() - 1; i >= 0; --i) {
                ModuleLayer parent = layer.parents().get(i);
                if (visited.contains(parent)) continue;
                visited.add(parent);
                stack.push(parent);
            }
        }
        return allLayers;
    }

    private Stream<AddExportsAndOpensAndReadsFormatValue> processOption(OptionKey<LocatableMultiOptionValue.Strings> specificOption) {
        Stream<Pair<Pair, OptionOrigin>> valuesWithOrigins = ((LocatableMultiOptionValue.Strings)specificOption.getValue(this.parsedHostedOptions)).getValuesWithOrigins();
        Stream<AddExportsAndOpensAndReadsFormatValue> parsedOptions = valuesWithOrigins.flatMap(valWithOrig -> {
            try {
                return Stream.of(this.asAddExportsAndOpensAndReadsFormatValue(specificOption, (Pair<String, OptionOrigin>)valWithOrig));
            }
            catch (UserError.UserException e) {
                if (ModuleSupport.modulePathBuild && this.classpath().isEmpty()) {
                    throw e;
                }
                System.out.println("Warning: " + e.getMessage());
                return Stream.empty();
            }
        });
        return parsedOptions;
    }

    private AddExportsAndOpensAndReadsFormatValue asAddExportsAndOpensAndReadsFormatValue(OptionKey<?> option, Pair<String, OptionOrigin> valueOrigin) {
        OptionOrigin optionOrigin = (OptionOrigin)valueOrigin.getRight();
        String optionValue = (String)valueOrigin.getLeft();
        boolean reads = option.equals(NativeImageClassLoaderOptions.AddReads);
        String format = reads ? "<module>=<target-module>(,<target-module>)*" : "<module>/<package>=<target-module>(,<target-module>)*";
        String syntaxErrorMessage = " Allowed value format: " + format;
        String[] modulePackageAndTargetModules = optionValue.split("=", 2);
        if (modulePackageAndTargetModules.length != 2) {
            throw NativeImageClassLoaderSupport.userErrorAddExportsAndOpensAndReads(option, optionOrigin, optionValue, syntaxErrorMessage);
        }
        String modulePackage = modulePackageAndTargetModules[0];
        String targetModuleNames = modulePackageAndTargetModules[1];
        String[] moduleAndPackage = modulePackage.split("/");
        if (moduleAndPackage.length > 1 + (reads ? 0 : 1)) {
            throw NativeImageClassLoaderSupport.userErrorAddExportsAndOpensAndReads(option, optionOrigin, optionValue, syntaxErrorMessage);
        }
        String moduleName = moduleAndPackage[0];
        String packageName = moduleAndPackage.length > 1 ? moduleAndPackage[1] : null;
        List<String> targetModuleNamesList = Arrays.asList(targetModuleNames.split(","));
        if (targetModuleNamesList.isEmpty()) {
            throw NativeImageClassLoaderSupport.userErrorAddExportsAndOpensAndReads(option, optionOrigin, optionValue, syntaxErrorMessage);
        }
        Module module = this.findModule(moduleName).orElseThrow(() -> NativeImageClassLoaderSupport.userErrorAddExportsAndOpensAndReads(option, optionOrigin, optionValue, " Specified module '" + moduleName + "' is unknown."));
        List<Module> targetModules = targetModuleNamesList.contains("ALL-UNNAMED") ? Collections.emptyList() : targetModuleNamesList.stream().map(mn -> this.findModule((String)mn).orElseThrow(() -> {
            throw NativeImageClassLoaderSupport.userErrorAddExportsAndOpensAndReads(option, optionOrigin, optionValue, " Specified target-module '" + mn + "' is unknown.");
        })).collect(Collectors.toList());
        return new AddExportsAndOpensAndReadsFormatValue(module, packageName, targetModules);
    }

    private static UserError.UserException userErrorAddExportsAndOpensAndReads(OptionKey<?> option, OptionOrigin origin, String value, String detailMessage) {
        Objects.requireNonNull(detailMessage, "missing detailMessage");
        return UserError.abort("Invalid option %s provided by %s.%s", SubstrateOptionsParser.commandArgument(option, value), origin, detailMessage);
    }

    Class<?> loadClassFromModule(Object module, String className) {
        assert (module instanceof Module) : "Argument `module` is not an instance of java.lang.Module";
        Module m = (Module)module;
        assert (NativeImageClassLoaderSupport.isModuleClassLoader(this.classLoader, m.getClassLoader())) : "Argument `module` is java.lang.Module from unknown ClassLoader";
        return Class.forName(m, className);
    }

    private static boolean isModuleClassLoader(ClassLoader loader, ClassLoader moduleClassLoader) {
        if (moduleClassLoader == loader) {
            return true;
        }
        if (loader == null) {
            return false;
        }
        return NativeImageClassLoaderSupport.isModuleClassLoader(loader.getParent(), moduleClassLoader);
    }

    Optional<String> getMainClassFromModule(Object module) {
        assert (module instanceof Module) : "Argument `module` is not an instance of java.lang.Module";
        return ((Module)module).getDescriptor().mainClass();
    }

    private Set<Path> getExcludeDirectories() {
        return Stream.of("dev", "sys", "proc", "etc", "var", "tmp", "boot", "lost+found").map(this.excludeDirectoriesRoot::resolve).collect(Collectors.toUnmodifiableSet());
    }

    private class ClassInit {
        protected final ForkJoinPool executor;
        protected final ImageClassLoader imageClassLoader;
        protected static final String CLASS_EXTENSION = ".class";

        protected ClassInit(ForkJoinPool executor, ImageClassLoader imageClassLoader) {
            this.executor = executor;
            this.imageClassLoader = imageClassLoader;
        }

        protected void init() {
            List<String> requiresInit = Arrays.asList("jdk.internal.vm.ci", "jdk.internal.vm.compiler", "com.oracle.graal.graal_enterprise", "org.graalvm.sdk", "org.graalvm.truffle");
            for (ModuleReference moduleReference : NativeImageClassLoaderSupport.this.upgradeAndSystemModuleFinder.findAll()) {
                if (!requiresInit.contains(moduleReference.descriptor().name())) continue;
                this.initModule(moduleReference);
            }
            for (ModuleReference moduleReference : NativeImageClassLoaderSupport.this.modulepathModuleFinder.findAll()) {
                this.initModule(moduleReference);
            }
            NativeImageClassLoaderSupport.this.classpath().parallelStream().forEach(this::loadClassesFromPath);
        }

        private void initModule(ModuleReference moduleReference) {
            Optional<Module> optionalModule = NativeImageClassLoaderSupport.this.findModule(moduleReference.descriptor().name());
            if (optionalModule.isEmpty()) {
                return;
            }
            try (ModuleReader moduleReader = moduleReference.open();){
                Module module = optionalModule.get();
                moduleReader.list().forEach(moduleResource -> {
                    if (moduleResource.endsWith(CLASS_EXTENSION)) {
                        this.executor.execute(() -> this.handleClassFileName(moduleReference.location().orElseThrow(), module, (String)moduleResource, '/'));
                    }
                });
            }
            catch (IOException e) {
                throw new RuntimeException("Unable get list of resources in module" + moduleReference.descriptor().name(), e);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void loadClassesFromPath(Path path) {
            if (ClasspathUtils.isJar(path)) {
                try {
                    FileSystem probeJarFileSystem;
                    URI container = path.toAbsolutePath().toUri();
                    URI jarURI = new URI("jar:" + container);
                    try {
                        probeJarFileSystem = FileSystems.newFileSystem(jarURI, Collections.emptyMap());
                    }
                    catch (UnsupportedOperationException e) {
                        return;
                    }
                    if (probeJarFileSystem == null) return;
                    try (FileSystem jarFileSystem = probeJarFileSystem;){
                        this.loadClassesFromPath(container, jarFileSystem.getPath("/", new String[0]), null, Collections.emptySet());
                        return;
                    }
                }
                catch (ClosedByInterruptException ignored) {
                    throw new InterruptImageBuilding();
                }
                catch (IOException | URISyntaxException e) {
                    throw VMError.shouldNotReachHere(e);
                }
            }
            URI container = path.toUri();
            this.loadClassesFromPath(container, path, NativeImageClassLoaderSupport.this.excludeDirectoriesRoot, NativeImageClassLoaderSupport.this.excludeDirectories);
        }

        private void loadClassesFromPath(final URI container, final Path root, Path excludeRoot, final Set<Path> excludes) {
            final boolean useFilter = root.equals(excludeRoot);
            if (useFilter) {
                String excludesStr = excludes.stream().map(Path::toString).collect(Collectors.joining(", "));
                System.err.println("Warning: Using directory " + excludeRoot + " on classpath is discouraged. Reading classes/resources from directories " + excludesStr + " will be suppressed.");
            }
            SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(){
                private final char fileSystemSeparatorChar;
                {
                    this.fileSystemSeparatorChar = root.getFileSystem().getSeparator().charAt(0);
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (useFilter && excludes.contains(dir)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return super.preVisitDirectory(dir, attrs);
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    assert (!excludes.contains(file.getParent())) : "Visiting file '" + file + "' with excluded parent directory";
                    String fileName = root.relativize(file).toString();
                    if (fileName.endsWith(ClassInit.CLASS_EXTENSION)) {
                        ClassInit.this.executor.execute(() -> ClassInit.this.handleClassFileName(container, null, fileName, this.fileSystemSeparatorChar));
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            };
            try {
                Files.walkFileTree(root, (FileVisitor<? super Path>)visitor);
            }
            catch (IOException ex) {
                throw VMError.shouldNotReachHere(ex);
            }
        }

        private String strippedClassFileName(String fileName) {
            int versionedSuffixIndex;
            String versionedPrefix = "META-INF/versions/";
            String versionedSuffix = "/";
            String result = fileName;
            if (fileName.startsWith("META-INF/versions/") && (versionedSuffixIndex = fileName.indexOf("/", "META-INF/versions/".length())) >= 0) {
                result = fileName.substring(versionedSuffixIndex + "/".length());
            }
            return result.substring(0, result.length() - CLASS_EXTENSION.length());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleClassFileName(URI container, Object module, String fileName, char fileSystemSeparatorChar) {
            String strippedClassFileName = this.strippedClassFileName(fileName);
            if (strippedClassFileName.equals("module-info")) {
                return;
            }
            String className = strippedClassFileName.replace(fileSystemSeparatorChar, '.');
            EconomicMap<URI, EconomicSet<String>> economicMap = NativeImageClassLoaderSupport.this.classes;
            synchronized (economicMap) {
                EconomicSet classNames = (EconomicSet)NativeImageClassLoaderSupport.this.classes.get((Object)container);
                if (classNames == null) {
                    classNames = EconomicSet.create();
                    NativeImageClassLoaderSupport.this.classes.put((Object)container, (Object)classNames);
                }
                classNames.add((Object)className);
            }
            int packageSep = className.lastIndexOf(46);
            String packageName = packageSep > 0 ? className.substring(0, packageSep) : "";
            EconomicMap<URI, EconomicSet<String>> economicMap2 = NativeImageClassLoaderSupport.this.packages;
            synchronized (economicMap2) {
                EconomicSet packageNames = (EconomicSet)NativeImageClassLoaderSupport.this.packages.get((Object)container);
                if (packageNames == null) {
                    packageNames = EconomicSet.create();
                    NativeImageClassLoaderSupport.this.packages.put((Object)container, (Object)packageNames);
                }
                packageNames.add((Object)packageName);
            }
            Class<?> clazz = null;
            try {
                clazz = this.imageClassLoader.forName(className, module);
            }
            catch (AssertionError error) {
                VMError.shouldNotReachHere((Throwable)((Object)error));
            }
            catch (Throwable t) {
                ImageClassLoader.handleClassLoadingError(t);
            }
            if (clazz != null) {
                this.imageClassLoader.handleClass(clazz);
            }
        }
    }

    private static final class AddExportsAndOpensAndReadsFormatValue {
        private final Module module;
        private final String packageName;
        private final List<Module> targetModules;

        private AddExportsAndOpensAndReadsFormatValue(Module module, String packageName, List<Module> targetModules) {
            this.module = module;
            this.packageName = packageName;
            this.targetModules = targetModules;
        }
    }

    protected static class Util {
        protected Util() {
        }

        static URL[] verifyClassPathAndConvertToURLs(String[] classpath) {
            Stream<URL> pathStream = new LinkedHashSet<String>(Arrays.asList(classpath)).stream().flatMap(Util::toClassPathEntries);
            return (URL[])pathStream.map(v -> {
                try {
                    return v.toAbsolutePath().toUri().toURL();
                }
                catch (MalformedURLException e) {
                    throw UserError.abort("Invalid classpath element '%s'. Make sure that all paths provided with '%s' are correct.", v, "-imagecp");
                }
            }).toArray(URL[]::new);
        }

        static Stream<Path> toClassPathEntries(String classPathEntry) {
            Path entry = ClasspathUtils.stringToClasspath(classPathEntry);
            if (entry.endsWith("$JavaCla$$pathWildcard$ubstitute$")) {
                try {
                    return Files.list(entry.getParent()).filter(ClasspathUtils::isJar);
                }
                catch (IOException e) {
                    return Stream.empty();
                }
            }
            if (Files.isReadable(entry)) {
                return Stream.of(entry);
            }
            return Stream.empty();
        }

        static Path urlToPath(URL url) {
            try {
                return Paths.get(url.toURI());
            }
            catch (URISyntaxException e) {
                throw VMError.shouldNotReachHere();
            }
        }
    }

    static final class ClassPathClassLoader
    extends URLClassLoader {
        ClassPathClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }
    }
}

