/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.aarch64;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordBase;

public class AArch64FrameAccess
extends FrameAccess {
    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public CodePointer readReturnAddress(Pointer sourceSp) {
        return (CodePointer)sourceSp.readWord(-AArch64FrameAccess.returnAddressSize());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void writeReturnAddress(Pointer sourceSp, CodePointer newReturnAddress) {
        sourceSp.writeWord(-AArch64FrameAccess.returnAddressSize(), (WordBase)newReturnAddress);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Pointer getReturnAddressLocation(Pointer sourceSp) {
        return sourceSp.subtract(AArch64FrameAccess.returnAddressSize());
    }

    @Override
    @Fold
    public int savedBasePointerSize() {
        return AArch64FrameAccess.wordSize();
    }

    @Override
    @Fold
    public int stackPointerAdjustmentOnCall() {
        return 0;
    }
}

